/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.mapper.DeliveryMapper;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.DeliveryVO;
import com.ejianc.foundation.message.api.IPushMessageApi;
import com.ejianc.foundation.message.vo.PushMsgParameter;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.DateFormater;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryService")
public class DeliveryServiceImpl
extends BaseServiceImpl<DeliveryMapper, DeliveryEntity>
implements IDeliveryService {
    private static final String WZXT_DELIVERY_BILL_CODE = "WZXT_DELIVERY";
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IPushMessageApi pushMessageApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Value(value="${weChat.cgdd-agentid}")
    private String cgddAgentid;
    @Value(value="${weChat.cgdd-secret}")
    private String cgddSecret;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public DeliveryVO queryDetails(Long id) {
        OrderEntity entity = (OrderEntity)((Object)this.orderService.selectById(id));
        DeliveryVO deliveryVO = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        deliveryVO.setOrderId(id);
        deliveryVO.setBillCode(null);
        deliveryVO.setId(null);
        deliveryVO.setBillState(null);
        deliveryVO.setCreateUserCode(null);
        deliveryVO.setCreateTime(null);
        deliveryVO.setUpdateUserCode(null);
        deliveryVO.setUpdateTime(null);
        deliveryVO.setLinkId(null);
        deliveryVO.setLinkName(null);
        deliveryVO.setLinkTelephone(null);
        deliveryVO.setDeliveryDate(entity.getOrderExpiryDate());
        deliveryVO.setDeliveryNote(entity.getOrderNote());
        deliveryVO.setDeliveryAddress(entity.getOrderAddress());
        deliveryVO.setCustomTenantId(entity.getTenantId());
        deliveryVO.setTenantId(entity.getSupplierTenantId());
        deliveryVO.setConstruction(entity.getConstruction());
        return deliveryVO;
    }

    @Override
    public CommonResponse<DeliveryVO> saveOrUpdate(DeliveryVO deliveryVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)deliveryVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_DELIVERY_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                deliveryVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        DeliveryEntity entity = (DeliveryEntity)((Object)BeanMapper.map((Object)deliveryVO, DeliveryEntity.class));
        List<DeliveryDetailEntity> deliveryDetail = entity.getDeliveryDetail();
        String materialName = "";
        if (deliveryDetail != null && deliveryDetail.size() > 0) {
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetail) {
                materialName = materialName + deliveryDetailEntity.getMaterialName() + ",";
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.deliveryService.saveOrUpdate((Object)entity, false);
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    public CommonResponse<DeliveryVO> deliver(Long id) {
        LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
        updateWrapper.eq(BaseEntity::getId, (Object)id);
        updateWrapper.set(DeliveryEntity::getBillState, (Object)1);
        updateWrapper.set(DeliveryEntity::getDeliverState, (Object)1);
        boolean flag = this.deliveryService.update((Wrapper)updateWrapper);
        if (!flag) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
        queryWrapperDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)id);
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)queryWrapperDetail);
        if (deliveryDetailList != null && deliveryDetailList.size() > 0) {
            ArrayList<Long> orderDetailIdList = new ArrayList<Long>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                orderDetailIdList.add(deliveryDetailEntity.getOrderDetailId());
            }
            LambdaQueryWrapper queryWrapperOrderDetail = Wrappers.lambdaQuery();
            queryWrapperOrderDetail.in(BaseEntity::getId, orderDetailIdList);
            List orderDetailEntityList = this.orderDetailService.list((Wrapper)queryWrapperOrderDetail);
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                for (OrderDetailEntity orderDetailEntity : orderDetailEntityList) {
                    if (!deliveryDetailEntity.getOrderDetailId().equals(orderDetailEntity.getId())) continue;
                    orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().add(deliveryDetailEntity.getDeliverNumsSum()));
                }
            }
            boolean flagOrder = this.orderDetailService.updateBatchById(orderDetailEntityList);
            if (!flagOrder) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
            LambdaQueryWrapper wrapperOrderDetail = Wrappers.lambdaQuery();
            wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, (Object)entity.getOrderId());
            wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, (Object)false);
            List orderDetailList = this.orderDetailService.list((Wrapper)wrapperOrderDetail);
            if (orderDetailList != null && orderDetailList.size() > 0) {
                Boolean b = true;
                for (OrderDetailEntity orderDetailEntity : orderDetailList) {
                    BigDecimal deliverNumsSum;
                    BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                    if (receiveNumsSum.compareTo(deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum()) != 1) continue;
                    b = false;
                }
                if (b.booleanValue()) {
                    LambdaUpdateWrapper updateOrderWrapper = new LambdaUpdateWrapper();
                    updateOrderWrapper.eq(BaseEntity::getId, (Object)entity.getOrderId());
                    updateOrderWrapper.set(OrderEntity::getDeliverState, (Object)1);
                    boolean updateFlagOrder = this.orderService.update((Wrapper)updateOrderWrapper);
                    if (!updateFlagOrder) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
            }
        }
        ArrayList<String> messageType = new ArrayList<String>();
        messageType.add("sys");
        messageType.add("weChat");
        ArrayList<String> sender = new ArrayList<String>();
        DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getById(entity.getOrderId()));
        sender.add(String.valueOf(orderEntity.getCommitId()));
        String subject = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "+" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u53d1\u8d27\uff0c\u8bf7\u53ca\u65f6\u9a8c\u6536!";
        String content = "\u60a8\u7684\u8ba2\u5355\u3010" + orderEntity.getProjectName() + "+" + orderEntity.getMaterialName() + "\u3011\u5df2\u7ecf\u5728" + DateFormater.getInstance().format("yyyy-MM-dd") + "\u88ab\u4f9b\u5e94\u5546\u3010" + orderEntity.getSupplierName() + "\u3011\u53d1\u8d27\uff0c\u8bf7\u5230\u4f01\u4e1a\u5fae\u4fe1\u9a8c\u6536!";
        this.sendMsg(messageType, sender, "notice", subject, content, String.valueOf(orderEntity.getTenantId()));
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u53d1\u8d27\u6210\u529f\uff01", (Object)vo);
    }

    @Override
    @Transactional
    public CommonResponse<DeliveryVO> unDeliver(Long id) {
        DeliveryEntity entity = (DeliveryEntity)((Object)this.deliveryService.selectById(id));
        boolean removeById = this.deliveryService.removeById(id);
        if (!removeById) {
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u5355\u64a4\u56de\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
        }
        LambdaQueryWrapper queryWrapperDetail = Wrappers.lambdaQuery();
        queryWrapperDetail.eq(DeliveryDetailEntity::getDeliveryId, (Object)id);
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)queryWrapperDetail);
        if (deliveryDetailList != null && deliveryDetailList.size() > 0) {
            ArrayList<Long> orderDetailIdList = new ArrayList<Long>();
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                orderDetailIdList.add(deliveryDetailEntity.getOrderDetailId());
            }
            LambdaQueryWrapper queryWrapperOrderDetail = Wrappers.lambdaQuery();
            queryWrapperOrderDetail.in(BaseEntity::getId, orderDetailIdList);
            List orderDetailEntityList = this.orderDetailService.list((Wrapper)queryWrapperOrderDetail);
            for (DeliveryDetailEntity deliveryDetailEntity : deliveryDetailList) {
                for (OrderDetailEntity orderDetailEntity : orderDetailEntityList) {
                    if (!deliveryDetailEntity.getOrderDetailId().equals(orderDetailEntity.getId())) continue;
                    orderDetailEntity.setDeliverNumsSum(orderDetailEntity.getDeliverNumsSum().subtract(deliveryDetailEntity.getDeliverNumsSum()));
                }
            }
            boolean flagOrder = this.orderDetailService.updateBatchById(orderDetailEntityList);
            if (!flagOrder) {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u53d1\u8d27\u6570\u91cf\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
            LambdaQueryWrapper wrapperOrderDetail = Wrappers.lambdaQuery();
            wrapperOrderDetail.eq(OrderDetailEntity::getOrderId, (Object)entity.getOrderId());
            wrapperOrderDetail.eq(OrderDetailEntity::getLeafFlag, (Object)false);
            List orderDetailList = this.orderDetailService.list((Wrapper)wrapperOrderDetail);
            if (orderDetailList != null && orderDetailList.size() > 0) {
                LambdaUpdateWrapper updateOrderWrapper;
                Boolean b = true;
                for (OrderDetailEntity orderDetailEntity : orderDetailList) {
                    BigDecimal deliverNumsSum;
                    BigDecimal receiveNumsSum = orderDetailEntity.getReceiveNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getReceiveNumsSum();
                    if (receiveNumsSum.compareTo(deliverNumsSum = orderDetailEntity.getDeliverNumsSum() == null ? BigDecimal.ZERO : orderDetailEntity.getDeliverNumsSum()) != 1) continue;
                    b = false;
                }
                if (b.booleanValue()) {
                    updateOrderWrapper = new LambdaUpdateWrapper();
                    updateOrderWrapper.eq(BaseEntity::getId, (Object)entity.getOrderId());
                    updateOrderWrapper.set(OrderEntity::getDeliverState, (Object)1);
                    boolean updateFlagOrder = this.orderService.update((Wrapper)updateOrderWrapper);
                    if (!updateFlagOrder) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                } else {
                    updateOrderWrapper = new LambdaUpdateWrapper();
                    updateOrderWrapper.eq(BaseEntity::getId, (Object)entity.getOrderId());
                    updateOrderWrapper.set(OrderEntity::getDeliverState, (Object)0);
                    boolean updateFlagOrder = this.orderService.update((Wrapper)updateOrderWrapper);
                    if (!updateFlagOrder) {
                        throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u8ba2\u5355\u53d1\u8d27\u72b6\u6001\u66f4\u65b0\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
                    }
                }
            }
        }
        DeliveryVO vo = (DeliveryVO)BeanMapper.map((Object)((Object)entity), DeliveryVO.class);
        return CommonResponse.success((String)"\u64a4\u56de\u6210\u529f\uff01", (Object)vo);
    }

    public void sendMsg(List<String> messageType, List<String> user, String msgType, String subject, String content, String tenantId) {
        this.logger.info("\u53d1\u9001\u6d88\u606f\u5f00\u59cb\uff01===========");
        PushMsgParameter parameter = new PushMsgParameter();
        ArrayList<String> channel = new ArrayList<String>();
        if (messageType.contains("sys")) {
            channel.add("sys");
        }
        if (messageType.contains("smsg")) {
            // empty if block
        }
        if (messageType.contains("weChat")) {
            channel.add("weixinee");
        }
        String[] receivers = user.toArray(new String[user.size()]);
        parameter.setReceivers(receivers);
        parameter.setChannel(channel.toArray(new String[channel.size()]));
        parameter.setMsgType(msgType);
        parameter.setSubject(subject);
        parameter.setContent(content);
        parameter.setTenantId(tenantId);
        parameter.setSendUserId(InvocationInfoProxy.getUserid());
        if (messageType.contains("weChat")) {
            JSONObject weixineeParams = new JSONObject();
            weixineeParams.put("agentid", (Object)this.cgddAgentid);
            weixineeParams.put("secret", (Object)this.cgddSecret);
            weixineeParams.put("content", (Object)subject);
            parameter.setWeixineeParams(weixineeParams);
        }
        try {
            CommonResponse result = this.pushMessageApi.pushMessage(parameter);
            if (result.isSuccess()) {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u6210\u529f---------------->" + result.getMsg());
            } else {
                this.logger.error("\u6d88\u606f\u53d1\u9001\u5931\u8d25---------------->" + result.getMsg());
            }
        }
        catch (Exception e) {
            this.logger.error("\u8c03\u7528\u6d88\u606f\u4e2d\u5fc3RPC\u670d\u52a1\u5f02\u5e38--------------" + e);
        }
    }
}

