/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.dataTransfor.service.ISdbjDataTransforService;
import com.ejianc.framework.skeleton.refer.constants.MetaDataUrlconstants;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ExceptionUtil;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service(value="planSdbjDataTransforService")
public class PlanSdbjDataTransforServiceImpl
implements ISdbjDataTransforService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String REFER_CACHE_KEY = "refer_cache_key:";
    @Autowired
    private IPlanService planService;
    @Value(value="${common.env.base-host}")
    private String baseHost;
    @Autowired
    private IAttachmentApi attachmentApi;

    public CommonResponse<String> dataTransfor(Map<String, Object> params) {
        if (params.get("billId") == null) {
            throw new BusinessException("\u7f3a\u5c11\u5355\u636eid");
        }
        if (params.get("billTypeCode") == null) {
            throw new BusinessException("\u7f3a\u5c11\u5355\u636e\u7c7b\u578b\u7f16\u7801");
        }
        Long billId = Long.parseLong(params.get("billId").toString());
        String billTypeCode = params.get("billTypeCode").toString();
        PlanEntity entity = (PlanEntity)((Object)this.planService.selectById(billId));
        if (entity == null) {
            return CommonResponse.error((String)("\u672a\u83b7\u53d6\u5230\u5355\u636e\uff1a" + billId + "\u4fe1\u606f"));
        }
        JSONObject json = new JSONObject();
        json.put("fdProjectName", (Object)entity.getProjectName());
        json.put("fdPlanName", (Object)entity.getPlanName());
        json.put("fdPlanDate", (Object)entity.getPlanDate());
        json.put("fdPlanSite", (Object)entity.getConstruction());
        json.put("fdCompiler", (Object)entity.getEmployeeName());
        String createDate = "";
        if (entity.getCreateDate() != null) {
            createDate = new SimpleDateFormat("yyyy-MM-dd").format(entity.getCreateDate());
        }
        json.put("fdDompilerDate", (Object)createDate);
        ArrayList<String> fdMmNoList = new ArrayList<String>();
        ArrayList<String> fdMmCategoryList = new ArrayList<String>();
        ArrayList<String> fdMmNameList = new ArrayList<String>();
        ArrayList<String> fdSpecificationList = new ArrayList<String>();
        ArrayList<String> fdUnitList = new ArrayList<String>();
        ArrayList<String> fdAuditQuantityList = new ArrayList<String>();
        ArrayList<String> fdDemandQuantityList = new ArrayList<String>();
        ArrayList<String> fdRemarksList = new ArrayList<String>();
        CommonResponse attachmentlistResponse = this.attachmentApi.queryListBySourceId(entity.getId(), "BT200918000000001", "planBill002", null);
        if (attachmentlistResponse.isSuccess() && ((List)attachmentlistResponse.getData()).size() > 0) {
            List attachmentlist = (List)attachmentlistResponse.getData();
            Object fdAttachment = "";
            for (AttachmentVO vo : attachmentlist) {
                if (((String)fdAttachment).length() > 0) {
                    fdAttachment = (String)fdAttachment + ",<a href=\"" + this.baseHost + "ejc-file-web/onlinePreview?fileId=" + vo.getId() + '\"' + ">" + vo.getFileName() + "</a>";
                    continue;
                }
                fdAttachment = (String)fdAttachment + "<a href=\"" + this.baseHost + "ejc-file-web/onlinePreview?fileId=" + vo.getId() + '\"' + ">" + vo.getFileName() + "</a>";
            }
            json.put("fdAttachment", fdAttachment);
        }
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        for (PlanDetailEntity item : planDetail) {
            fdMmNoList.add(item.getMaterialCode());
            fdMmCategoryList.add(item.getMaterialTypeName());
            fdMmNameList.add(item.getMaterialName());
            fdSpecificationList.add(item.getSpec());
            fdUnitList.add(item.getUnit());
            fdAuditQuantityList.add(item.getNums().toString());
            fdDemandQuantityList.add(item.getPlanNum().toString());
            fdRemarksList.add(item.getMemo());
        }
        JSONObject fdDetail = new JSONObject();
        fdDetail.put("fdDetail.fdDemandQuantity", fdDemandQuantityList);
        fdDetail.put("fdDetail.fdUnit", fdUnitList);
        fdDetail.put("fdDetail.fdRemarks", fdRemarksList);
        fdDetail.put("fdDetail.fdAuditQuantity", fdAuditQuantityList);
        fdDetail.put("fdDetail.fdMmName", fdMmNameList);
        fdDetail.put("fdDetail.fdMmCategory", fdMmCategoryList);
        fdDetail.put("fdDetail.fdMmNo", fdMmNoList);
        fdDetail.put("fdDetail.fdSpecification", fdSpecificationList);
        json.put("fdDetail", (Object)fdDetail);
        json.put("fdCreator", (Object)PlanSdbjDataTransforServiceImpl.getUserName(entity.getCreateUserCode()));
        String createTime = "";
        if (entity.getCreateTime() != null) {
            createTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(entity.getCreateTime());
        }
        json.put("fdCreateTime", (Object)createTime);
        json.put("fdAltor", (Object)PlanSdbjDataTransforServiceImpl.getUserName(entity.getUpdateUserCode()));
        String updateTime = "";
        if (entity.getUpdateTime() != null) {
            updateTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(entity.getUpdateTime());
        }
        json.put("fdAlterTime", (Object)updateTime);
        return CommonResponse.success((String)"\u6570\u636e\u8f6c\u6362\u6210\u529f", (Object)json.toJSONString());
    }

    public static String getUserName(String userCode) {
        block8: {
            try {
                MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
                if (!StringUtils.isNotBlank((CharSequence)userCode) || !StringUtils.isNotBlank((CharSequence)urlconstants.getBaseHost())) break block8;
                String cacheKey = "refer_cache_key:idm-employee:" + userCode;
                RedisTemplate redisTemplate = (RedisTemplate)ContextUtil.getBean((String)"redisTemplate", RedisTemplate.class);
                Object cacheValue = redisTemplate.opsForValue().get((Object)cacheKey);
                JSONObject jsonObject = null;
                if (cacheValue != null) {
                    jsonObject = JSON.parseObject((String)cacheValue.toString());
                } else {
                    String referData = PlanSdbjDataTransforServiceImpl.getReferRestUrl("idm-employee");
                    JSONObject json = JSON.parseObject((String)referData);
                    String referUrl = json.get((Object)"projectName").toString();
                    Map<String, String> reflist = new HashMap();
                    reflist = (Map)json.get((Object)"refMapList");
                    reflist.put("userCode", userCode);
                    String url = urlconstants.getBaseHost() + referUrl + "/commonrefer/getAuditInfo";
                    String jsonbackstr = null;
                    try {
                        jsonbackstr = ReferHttpClientUtils.getAndHeader((String)url, reflist);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (StringUtils.isNotBlank((CharSequence)jsonbackstr)) {
                        jsonObject = JSON.parseObject((String)jsonbackstr);
                        redisTemplate.opsForValue().set((Object)cacheKey, (Object)jsonbackstr, 5L, TimeUnit.DAYS);
                    }
                }
                if (jsonObject != null) {
                    return jsonObject.getString("userName");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return userCode;
    }

    private static String getReferRestUrl(String referCode) {
        String data = null;
        MetaDataUrlconstants urlconstants = (MetaDataUrlconstants)ContextUtil.getBean(MetaDataUrlconstants.class);
        String backData = null;
        try {
            backData = ReferHttpClientUtils.getAndHeader((String)(urlconstants.getMetaDataBaseUrl() + referCode), null);
        }
        catch (Exception exception) {
            // empty catch block
        }
        JSONObject jsonobject = JSON.parseObject(backData);
        if (jsonobject.getString("code").equals("0")) {
            if (jsonobject.getString("data") != null) {
                data = JSON.parseObject((String)jsonobject.getString("data")).toJSONString();
            }
        } else {
            ExceptionUtil.wrappBusinessException((String)("\u53c2\u7167\u7f16\u7801" + referCode + "\u7684\u5b9e\u4f53\u6ca1\u6709\u53d1\u5e03\u5143\u6570\u636e!"));
        }
        return data;
    }
}

