package com.ejianc.business.wzxt.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 订单实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_wzxt_order")
public class OrderEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_source_id")
    private java.lang.String projectSourceId; // 项目来源id
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="contract_id")
    private java.lang.String contractId; // 合同主键
    @TableField(value="contract_name")
    private java.lang.String contractName; // 合同名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商名称
    @TableField(value="supplier_tenant_id")
    private java.lang.Long supplierTenantId; // 供应商租户ID
    @TableField(value="supplier_source_id")
    private java.lang.String supplierSourceId; // 供应商来源ID
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="construction")
    private java.lang.String construction; // 施工部位
    @TableField(value="commit_id")
    private java.lang.Long commitId; // 提交人
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="link_id")
    private java.lang.Long linkId; // 联系人
    @TableField(value="link_name")
    private java.lang.String linkName; // 联系人名称
    @TableField(value="link_telephone")
    private java.lang.String linkTelephone; // 联系人电话
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="order_create_date")
    private java.util.Date orderCreateDate; // 订单日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    @TableField(value="order_expiry_date")
    private java.util.Date orderExpiryDate; // 到货日期
    @TableField(value="order_note")
    private java.lang.String orderNote; // 送货要求
    @TableField(value="order_address")
    private java.lang.String orderAddress; // 送货地址
    @TableField(value="receive_state")
    private java.lang.Integer receiveState; // 接收状态（0-待确认,1-全部接收，2-部分接受，3-已拒绝）
    @TableField(value="deliver_state")
    private java.lang.Integer deliverState; // 发货状态（0-待发货，1-已发货，2-已验收）
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="is_push_third")
    private String isPushThird; // 推送第三方是否成功 sucPushed   unSucPush
    @TableField(value="un_suc_reason")
    private String unSucReason;//失败原因
    @TableField(value="automatic_weigh")
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）
    @TableField(value="ignore_flag")
    private Integer ignoreFlag; // 是否忽略（0：正常，1忽略）

    // 采购订单明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="orderDetailService",pidName = "orderId")
    private List<OrderDetailEntity> purchaseOrderDetail = new ArrayList<>();

    public List<OrderDetailEntity> getPurchaseOrderDetail() {
        return purchaseOrderDetail;
    }

    public void setPurchaseOrderDetail(List<OrderDetailEntity> purchaseOrderDetail) {
        this.purchaseOrderDetail = purchaseOrderDetail;
    }

    public String getSupplierSourceId() {
        return supplierSourceId;
    }

    public void setSupplierSourceId(String supplierSourceId) {
        this.supplierSourceId = supplierSourceId;
    }

    public Integer getIgnoreFlag() {
        return ignoreFlag;
    }

    public void setIgnoreFlag(Integer ignoreFlag) {
        this.ignoreFlag = ignoreFlag;
    }

    public String getIsPushThird() {
        return isPushThird;
    }

    public void setIsPushThird(String isPushThird) {
        this.isPushThird = isPushThird;
    }

    public String getUnSucReason() {
        return unSucReason;
    }

    public void setUnSucReason(String unSucReason) {
        this.unSucReason = unSucReason;
    }

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    public Long getCommitId() {
        return commitId;
    }

    public void setCommitId(Long commitId) {
        this.commitId = commitId;
    }

    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }
    /**
     * 合同主键
     */
    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 供应商租户ID
     */
    public java.lang.Long getSupplierTenantId() {
        return supplierTenantId;
    }

    /**
     * 供应商租户ID
     */
    public void setSupplierTenantId(java.lang.Long supplierTenantId) {
        this.supplierTenantId = supplierTenantId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 联系人
     */
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 联系人
     */
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 联系人名称
     */
    public java.lang.String getLinkName() {
        return linkName;
    }

    /**
     * 联系人名称
     */
    public void setLinkName(java.lang.String linkName) {
        this.linkName = linkName;
    }
    /**
     * 联系人电话
     */
    public java.lang.String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(java.lang.String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 订单日期
     */
    public java.util.Date getOrderCreateDate() {
        return orderCreateDate;
    }

    /**
     * 订单日期
     */
    public void setOrderCreateDate(java.util.Date orderCreateDate) {
        this.orderCreateDate = orderCreateDate;
    }
    /**
     * 到货日期
     */
    public java.util.Date getOrderExpiryDate() {
        return orderExpiryDate;
    }

    /**
     * 到货日期
     */
    public void setOrderExpiryDate(java.util.Date orderExpiryDate) {
        this.orderExpiryDate = orderExpiryDate;
    }
    /**
     * 送货要求
     */
    public java.lang.String getOrderNote() {
        return orderNote;
    }

    /**
     * 送货要求
     */
    public void setOrderNote(java.lang.String orderNote) {
        this.orderNote = orderNote;
    }
    /**
     * 送货地址
     */
    public java.lang.String getOrderAddress() {
        return orderAddress;
    }

    /**
     * 送货地址
     */
    public void setOrderAddress(java.lang.String orderAddress) {
        this.orderAddress = orderAddress;
    }
    /**
     * 接收状态（0-全部接收，1-部分接受，2-已拒绝）
     */
    public java.lang.Integer getReceiveState() {
        return receiveState;
    }

    /**
     * 接收状态（0-全部接收，1-部分接受，2-已拒绝）
     */
    public void setReceiveState(java.lang.Integer receiveState) {
        this.receiveState = receiveState;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public java.lang.Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(java.lang.Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
}
