package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.service.IPlanService;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 使用计划实体
 * 
 * @author generator
 * 
 */
@Service("planService")
public class PlanServiceImpl extends BaseServiceImpl<PlanMapper, PlanEntity> implements IPlanService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String SDBJ_CACHE_KEY_PREFIX = "SDBJ::";
    @Autowired
    private CacheManager cacheManager;

    @Value("${sdbj.serverUrl}")
    private String SDBJ_SERVER_URL;

    @Value("${sdbj.appid}")
    private String APPID;
    @Value("${sdbj.accessTokenUrl}")
    private String ACCESS_TOKEN_URL;

    @Value("${sdbj.materialrequirefullplandetaillistUrl}")
    private String PM_SUBJECT_LIST_URL;
    @Value("${sdbj.pmSubjectListUrl}")
    private String PM_BW_LIST_URL;

    private static final String WZXT_PLAN_BILL_CODE = "WZXT_PLAN";

    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;
    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(planVO.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE,tenantId);
            if(billCode.isSuccess()) {
                planVO.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常，编码生成失败，请稍后再试");
            }
        }

        PlanEntity entity = BeanMapper.map(planVO, PlanEntity.class);
        //todo 校验数量是否超累计使用量
        if(entity.getMaterialVerification()&&StringUtils.isNotEmpty(entity.getConstructionId())){
            StringBuffer msg = new StringBuffer();
            //第一步：根据项目获取该项目下所有部位
            List<PmTreeVO> listPmtree = new ArrayList<>();
            Map<String, Object> params = new HashMap<>(10);
            params.put("prjid", entity.getProjectSourceId());
            CommonResponse<JSONObject> bwres = null;
            try {
                bwres = sendGetReq(PM_BW_LIST_URL, params);
            } catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("查询水电八局项目工程部位参照失败");
            }
            if(bwres.isSuccess()){
                JSONObject result = bwres.getData();
                JSONArray list = result.getJSONObject("data").getJSONArray("list");
                if(list!=null){
                    list.forEach(l->{
                        String jsonString = JSON.toJSONString(l);
                        PmTreeVO j  = JSON.parseObject(jsonString, PmTreeVO.class);
                        listPmtree.add(j);
                    });
                }
            }else {
                throw new BusinessException(bwres.getMsg());
            }


            //第二步：根据项目+材料主键  取到末级部位+材料+计划量map<材料，map<部位，PM量>>
            Map<String, Object> param = new HashMap<>();
            Map<String, Object> data = new HashMap<>();
            List<String> pks = entity.getPlanDetail().stream().map(PlanDetailEntity::getMaterialSourceId).collect(Collectors.toList());
            data.put("projectid", entity.getProjectSourceId()); //八局项目Id
            data.put("materialidlist", pks); //材料Id
            param.put("data", data);
            CommonResponse<JSONObject> response = null;
            try {
                response = sendPostReq(PM_SUBJECT_LIST_URL, JSON.toJSONString(param));
                if(!response.isSuccess()) {
                    return CommonResponse.error("查询水电八局材料需求总预算接口失败，" + response.getMsg());
                }
            } catch (Exception e) {
                e.printStackTrace();
                return CommonResponse.error("查询水电八局材料需求总预算接口失败");
            }
            Map<String,Map<String,BigDecimal>> mapPm = new HashMap<>();  //pm量结果集
            JSONObject result = response.getData();
            JSONArray list = result.getJSONArray("list");
            if(list!=null){
                list.forEach(l->{
                    String jsonString = JSON.toJSONString(l);
                    PmDetailVO j  = JSON.parseObject(jsonString, PmDetailVO.class);
                    if(mapPm.containsKey(j.getMaterialId())){
                        mapPm.get(j.getMaterialId()).put(j.getPartsID(),j.getJhl());
                    }else{
                        Map<String,BigDecimal> mapBw = new HashMap<>();
                        mapBw.put(j.getPartsID(),j.getJhl());
                        mapPm.put(j.getMaterialId(),mapBw);
                    }
                });
            }

            //第三步  查询该项目下所有审批通过的计划  根据材料主键+部位主键  group by   取到项目下所有部位+材料group by  Map<材料主键，map<部位，累计使用量>>
            Map<String,Map<String,BigDecimal>> mapSum = new HashMap<>();//累计使用量结果集
            List<PlanDetailVO> listDetials = baseMapper.queryDetails(entity.getProjectId());
            if(CollectionUtils.isNotEmpty(listDetials)){
                listDetials.forEach(j->{
                    if(mapSum.containsKey(j.getMaterialSourceId())){
                        mapSum.get(j.getMaterialSourceId()).put(j.getConstructionId(),j.getNums());
                    }else{
                        Map<String,BigDecimal> mapBw = new HashMap<>();
                        mapBw.put(j.getConstructionId(),j.getNums());
                        mapSum.put(j.getMaterialSourceId(),mapBw);
                    }
                });
            }

            //第四步 循环每个材料
            List<PlanDetailEntity> planDetail = entity.getPlanDetail();
            if(CollectionUtils.isNotEmpty(planDetail)){
                planDetail.forEach(e->{
                    // 第五步  汇总1,2,3结果得到    部位，PM量 ，累计使用量
                    List<PmTreeVO> listPm = new ArrayList<>();
                    listPm.addAll(listPmtree);
                    listPm.forEach(p->{
                        if(mapPm.containsKey(e.getMaterialSourceId())){
                            if(mapPm.get(e.getMaterialSourceId()).containsKey(p.getId())){
                                BigDecimal jhl = mapPm.get(e.getMaterialSourceId()).get(p.getId())==null?BigDecimal.ZERO:mapPm.get(e.getMaterialSourceId()).get(p.getId());
                                p.setJhl(jhl);
                            }
                        }
                        if(mapSum.containsKey(e.getMaterialSourceId())){
                            if(mapSum.get(e.getMaterialSourceId()).containsKey(p.getId())){
                                BigDecimal sum = mapSum.get(e.getMaterialSourceId()).get(p.getId())==null?BigDecimal.ZERO:mapSum.get(e.getMaterialSourceId()).get(p.getId());
                                p.setPlanNum(sum);
                            }
                        }
                    });

                    // 第六步    树形汇总 PM量    累计使用量(本加下)
                    List<PmTreeVO> listres = new ArrayList<>();//汇总后的树
                    calculateValue(listPm,listres);

//                    List<PmTreeVO> listres2 = new ArrayList<>();//汇总后的树
//                    listres.forEach(pl->{
//                        if(null==pl.getParentid()||"".equals(pl.getParentid())){
//                            listres2.add(pl);
//                        }
//                    });
                    //第六步  校验是否超过本级 与本上 剩余量

                    boolean flag = cheeckNum(listres,entity.getConstructionId(),e.getPlanNum()==null?BigDecimal.ZERO:e.getPlanNum());
//                    e.setExcess(flag);
                    if(flag&&StringUtils.isEmpty(e.getMemo())){
                        msg.append("【"+e.getMaterialName()+"】");
                    }
                });
            }
            if(StringUtils.isNotEmpty(msg)){
                return CommonResponse.error("您所录入的物资名称为"+msg.toString()+"需求数量已超出易建PM系统计划量,需填写备注后可保存");
            }
        }

        //汇总物资明细名称
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        if(planDetail != null && planDetail.size() > 0){
            for(PlanDetailEntity applyDetailEntity : planDetail){
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";

                if (applyDetailEntity.getNums() != null){
                    BigDecimal nums = applyDetailEntity.getNums() == null ? BigDecimal.ZERO : applyDetailEntity.getNums();
                    BigDecimal occupyNums = applyDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : applyDetailEntity.getOccupyNums();
                    BigDecimal surplusNums = nums.subtract(occupyNums);
                    applyDetailEntity.setSurplusNums(surplusNums);
                    applyDetailEntity.setOccupyNums(occupyNums);
                    applyDetailEntity.setNums(nums);
                }
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        planService.saveOrUpdate(entity, false);
        PlanVO vo = BeanMapper.map(entity, PlanVO.class);
        return CommonResponse.success("保存或修改单据成功！",vo);
    }

    //找到最底层的叶子节点
    public List<PmTreeVO> getBottomNode(List<PmTreeVO> listPmTreeVO) {
        Map<String, PmTreeVO> map = new HashMap<String, PmTreeVO>();
        for (PmTreeVO g : listPmTreeVO) {
            map.put(g.getId(), g);
        }

        for (PmTreeVO g : listPmTreeVO) {
            String pid = g.getParentid();
            if (map.containsKey(pid)) {
                map.remove(pid);
            }
        }

        return new ArrayList<PmTreeVO>(map.values());
    }



    public List<PmTreeVO> setParentValue(List<PmTreeVO> listAllPmTreeVO, List<PmTreeVO> listBottomPmTreeVO) {

        Map<String, List<PmTreeVO>> map = new HashMap<String, List<PmTreeVO>>();
        for (PmTreeVO g : listBottomPmTreeVO) {
            String pid = g.getParentid();
            List<PmTreeVO> listPmTreeVO = map.get(pid);
            if (listPmTreeVO == null) {
                listPmTreeVO = new ArrayList<PmTreeVO>();
            }
            listPmTreeVO.add(g);
            map.put(pid, listPmTreeVO);
        }

        for (String i : map.keySet()) {
            List<PmTreeVO> tempListPmTreeVO = map.get(i);
            BigDecimal jhl = BigDecimal.ZERO;
            BigDecimal ljnum = BigDecimal.ZERO;
            for (PmTreeVO g : tempListPmTreeVO) {
                jhl = jhl.add(g.getJhl()==null?BigDecimal.ZERO:g.getJhl());
                ljnum = ljnum.add(g.getPlanNum()==null?BigDecimal.ZERO:g.getPlanNum());
            }
            for (PmTreeVO g : listAllPmTreeVO) {
                String id = g.getId();
                if (id.equals(i)) {
                    g.setJhl(jhl);
                    BigDecimal plannum = g.getPlanNum()==null?BigDecimal.ZERO:g.getPlanNum();
                    g.setPlanNum(plannum.add(ljnum));
                }
            }
        }

        for (PmTreeVO g : listBottomPmTreeVO) {
            listAllPmTreeVO.remove(g);
        }

        return listAllPmTreeVO;
    }

    public PmTreeVO calculateValue(List<PmTreeVO> listPmTreeVO,List<PmTreeVO> listRes) {
        if (listPmTreeVO.size() == 1) {
            listRes.add(listPmTreeVO.get(0));
            return listPmTreeVO.get(0);
        } else {
            List<PmTreeVO> listBottomPmTreeVO = getBottomNode(listPmTreeVO);
            List<PmTreeVO> list = setParentValue(listPmTreeVO, listBottomPmTreeVO);
            listRes.addAll(listBottomPmTreeVO);
            return calculateValue(list,listRes);
        }
    }


    public boolean  cheeckNum(List<PmTreeVO> listPmTreeVO,String constructionId,BigDecimal plnum) {
        for (PmTreeVO g : listPmTreeVO) {
             if(StringUtils.isNotEmpty(constructionId)&&constructionId.equals(g.getId())){
                BigDecimal jhl = g.getJhl()==null?BigDecimal.ZERO:g.getJhl();
                BigDecimal planNum = g.getPlanNum()==null?BigDecimal.ZERO:g.getPlanNum();
                if(plnum.compareTo(jhl.subtract(planNum))<0){
                    return cheeckNum(listPmTreeVO,g.getParentid(),plnum);
                }else{
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId,QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = baseMapper.getPlanByMaterialId(materialListId,queryWrapper);
        return planVOList;
    }

    private CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();

        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL+url;
        String reqResp =  HttpTookit.get(newUrl, params, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, JSON.toJSONString(params), headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData);
    }
    private CommonResponse<JSONObject> sendPostReq(String url, String paramJson) throws Exception {
        Map<String, String> headers = new HashMap<>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = getSDBJAccessToken();
        if(null == accessToken) {
            throw new BusinessException("获取服务accessToken失败！");
        }
        headers.put("access_token", accessToken.get("token").toString());
        String newUrl = SDBJ_SERVER_URL+url;
        String reqResp =  HttpTookit.postByJson(newUrl, paramJson, headers, 10000, 20000);
        logger.info("发送get请求【地址： {}, 参数：{}, header: {}】, 响应结果：{}", newUrl, paramJson, headers, reqResp);

        JSONObject jsonData = JSONObject.parseObject(reqResp);
        if(BooleanUtils.isNotTrue(jsonData.getBoolean("success"))) {
            return CommonResponse.error(null != jsonData.get("message") ? jsonData.get("message").toString() : "查询失败！");
        }
        return CommonResponse.success(jsonData.getJSONObject("data"));
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String key = SDBJ_CACHE_KEY_PREFIX + "ACCESS_TOKEN";
        String reqUrl = SDBJ_SERVER_URL + ACCESS_TOKEN_URL;

        String tokenInfo = cacheManager.get(key);
        if(org.apache.commons.lang3.StringUtils.isNotBlank(tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject(tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get("invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if(invalidateTime > curTime) {
                return tokenData;
            }
        }

        Map<String, Object> params = new HashMap<>(2);
        params.put("appId", APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader(reqUrl, params);
            logger.info("获取水电八局服务访问Token服务-[地址：{}, 参数：{}]，返回结果：{}", reqUrl, JSONObject.toJSONString(params), reqRespStr);

            JSONObject reqResp = JSONObject.parseObject(reqRespStr);
            if(BooleanUtils.isNotTrue((Boolean) reqResp.get("success"))) {
                logger.error(null != reqResp.get("message") ? reqResp.get("message").toString() : "获取水电八局服务请求Token失败！");
                return null;
            }

            Map<String, Object> tokenData = (Map<String, Object>) reqResp.get("data");
            JSONObject invalidateInfo = (JSONObject) tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get("time").toString());

            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", invalidateTime);

            //放入缓存，有效时间1小时
            cacheManager.setex(key, JSONObject.toJSONString(resp), 60 * 50);

            return resp;
        } catch (Exception e) {
            logger.error("请求水电八局服务访问Token异常, ", e);
            return null;
        }
    }
}
