package com.ejianc.business.wzxt.bean;

import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 发货实体
 * 
 * @author generator
 * 
 */
 @TableName("ejc_wzxt_delivery")
public class DeliveryEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableField(value="order_id")
    private java.lang.Long orderId; // 订单主键
    @TableField(value="bill_code")
    private java.lang.String billCode; // 单据编号
    @TableField(value="project_id")
    private java.lang.Long projectId; // 项目
    @TableField(value="project_name")
    private java.lang.String projectName; // 项目名称
    @TableField(value="org_id")
    private java.lang.Long orgId; // 组织
    @TableField(value="org_name")
    private java.lang.String orgName; // 组织名称
    @TableField(value="contract_id")
    private java.lang.String contractId; // 合同主键
    @TableField(value="contract_name")
    private java.lang.String contractName; // 合同名称
    @TableField(value="supplier_id")
    private java.lang.Long supplierId; // 设备供应商
    @TableField(value="supplier_name")
    private java.lang.String supplierName; // 供应商名称
    @TableField(value="custom_tenant_id")
    private java.lang.Long customTenantId; // 客户租户ID
    @TableField(value="material_name")
    private java.lang.String materialName; // 物资名称
    @TableField(value="employee_id")
    private java.lang.Long employeeId; // 经办人
    @TableField(value="employee_name")
    private java.lang.String employeeName; // 经办人名称
    @TableField(value="link_id")
    private java.lang.Long linkId; // 送货人
    @TableField(value="link_name")
    private java.lang.String linkName; // 送货人名称
    @TableField(value="delivery_car_number")
    private java.lang.String deliveryCarNumber; // 车牌号
    @TableField(value="link_telephone")
    private java.lang.String linkTelephone; // 联系人电话
    @TableField(value="delivery_date")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private java.util.Date deliveryDate; // 送货日期
    @TableField(value="delivery_note")
    private java.lang.String deliveryNote; // 送货要求
    @TableField(value="delivery_address")
    private java.lang.String deliveryAddress; // 送货地址
    @TableField(value="deliver_state")
    private java.lang.Integer deliverState; // 发货状态（0-自由态，1-已发货，2-已验收）
    @TableField(value="bill_state")
    private java.lang.Integer billState; // 单据状态（审批必须字段）
    @TableField(value="project_source_id")
    private java.lang.String projectSourceId; // 项目来源id
    // 设备明细子表
    @TableField(exist = false)
    @SubEntity(serviceName="deliveryDetailService",pidName = "deliveryId")
    private List<DeliveryDetailEntity> deliveryDetail = new ArrayList<>();
    @TableField(value="construction")
    private java.lang.String construction; // 使用部位

    @TableField(value="automatic_weigh")
    private Integer automaticWeigh; // 自动称重设置（0：自动称重，1非自动称重）

    public Integer getAutomaticWeigh() {
        return automaticWeigh;
    }

    public void setAutomaticWeigh(Integer automaticWeigh) {
        this.automaticWeigh = automaticWeigh;
    }

    public String getConstruction() {
        return construction;
    }

    public void setConstruction(String construction) {
        this.construction = construction;
    }
    public List<DeliveryDetailEntity> getDeliveryDetail() {
        return deliveryDetail;
    }

    public void setDeliveryDetail(List<DeliveryDetailEntity> deliveryDetail) {
        this.deliveryDetail = deliveryDetail;
    }

    public String getProjectSourceId() {
        return projectSourceId;
    }

    public void setProjectSourceId(String projectSourceId) {
        this.projectSourceId = projectSourceId;
    }

    /**
     * 订单主键
     */
    public java.lang.Long getOrderId() {
        return orderId;
    }

    /**
     * 订单主键
     */
    public void setOrderId(java.lang.Long orderId) {
        this.orderId = orderId;
    }
    /**
     * 单据编号
     */
    public java.lang.String getBillCode() {
        return billCode;
    }

    /**
     * 单据编号
     */
    public void setBillCode(java.lang.String billCode) {
        this.billCode = billCode;
    }
    /**
     * 项目
     */
    public java.lang.Long getProjectId() {
        return projectId;
    }

    /**
     * 项目
     */
    public void setProjectId(java.lang.Long projectId) {
        this.projectId = projectId;
    }
    /**
     * 项目名称
     */
    public java.lang.String getProjectName() {
        return projectName;
    }

    /**
     * 项目名称
     */
    public void setProjectName(java.lang.String projectName) {
        this.projectName = projectName;
    }
    /**
     * 组织
     */
    public java.lang.Long getOrgId() {
        return orgId;
    }

    /**
     * 组织
     */
    public void setOrgId(java.lang.Long orgId) {
        this.orgId = orgId;
    }
    /**
     * 组织名称
     */
    public java.lang.String getOrgName() {
        return orgName;
    }

    /**
     * 组织名称
     */
    public void setOrgName(java.lang.String orgName) {
        this.orgName = orgName;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }

    /**
     * 合同名称
     */
    public java.lang.String getContractName() {
        return contractName;
    }

    /**
     * 合同名称
     */
    public void setContractName(java.lang.String contractName) {
        this.contractName = contractName;
    }
    /**
     * 设备供应商
     */
    public java.lang.Long getSupplierId() {
        return supplierId;
    }

    /**
     * 设备供应商
     */
    public void setSupplierId(java.lang.Long supplierId) {
        this.supplierId = supplierId;
    }
    /**
     * 供应商名称
     */
    public java.lang.String getSupplierName() {
        return supplierName;
    }

    /**
     * 供应商名称
     */
    public void setSupplierName(java.lang.String supplierName) {
        this.supplierName = supplierName;
    }
    /**
     * 客户租户ID
     */
    public java.lang.Long getCustomTenantId() {
        return customTenantId;
    }

    /**
     * 客户租户ID
     */
    public void setCustomTenantId(java.lang.Long customTenantId) {
        this.customTenantId = customTenantId;
    }
    /**
     * 物资名称
     */
    public java.lang.String getMaterialName() {
        return materialName;
    }

    /**
     * 物资名称
     */
    public void setMaterialName(java.lang.String materialName) {
        this.materialName = materialName;
    }
    /**
     * 经办人
     */
    public java.lang.Long getEmployeeId() {
        return employeeId;
    }

    /**
     * 经办人
     */
    public void setEmployeeId(java.lang.Long employeeId) {
        this.employeeId = employeeId;
    }
    /**
     * 经办人名称
     */
    public java.lang.String getEmployeeName() {
        return employeeName;
    }

    /**
     * 经办人名称
     */
    public void setEmployeeName(java.lang.String employeeName) {
        this.employeeName = employeeName;
    }
    /**
     * 送货人
     */
    public java.lang.Long getLinkId() {
        return linkId;
    }

    /**
     * 送货人
     */
    public void setLinkId(java.lang.Long linkId) {
        this.linkId = linkId;
    }
    /**
     * 送货人名称
     */
    public java.lang.String getLinkName() {
        return linkName;
    }

    /**
     * 送货人名称
     */
    public void setLinkName(java.lang.String linkName) {
        this.linkName = linkName;
    }
    /**
     * 车牌号
     */
    public java.lang.String getDeliveryCarNumber() {
        return deliveryCarNumber;
    }

    /**
     * 车牌号
     */
    public void setDeliveryCarNumber(java.lang.String deliveryCarNumber) {
        this.deliveryCarNumber = deliveryCarNumber;
    }
    /**
     * 联系人电话
     */
    public java.lang.String getLinkTelephone() {
        return linkTelephone;
    }

    /**
     * 联系人电话
     */
    public void setLinkTelephone(java.lang.String linkTelephone) {
        this.linkTelephone = linkTelephone;
    }
    /**
     * 送货日期
     */
    public java.util.Date getDeliveryDate() {
        return deliveryDate;
    }

    /**
     * 送货日期
     */
    public void setDeliveryDate(java.util.Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }
    /**
     * 送货要求
     */
    public java.lang.String getDeliveryNote() {
        return deliveryNote;
    }

    /**
     * 送货要求
     */
    public void setDeliveryNote(java.lang.String deliveryNote) {
        this.deliveryNote = deliveryNote;
    }
    /**
     * 送货地址
     */
    public java.lang.String getDeliveryAddress() {
        return deliveryAddress;
    }

    /**
     * 送货地址
     */
    public void setDeliveryAddress(java.lang.String deliveryAddress) {
        this.deliveryAddress = deliveryAddress;
    }
    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public java.lang.Integer getDeliverState() {
        return deliverState;
    }

    /**
     * 发货状态（0-自由态，1-已发货，2-已验收）
     */
    public void setDeliverState(java.lang.Integer deliverState) {
        this.deliverState = deliverState;
    }
    /**
     * 单据状态（审批必须字段）
     */
    public java.lang.Integer getBillState() {
        return billState;
    }

    /**
     * 单据状态（审批必须字段）
     */
    public void setBillState(java.lang.Integer billState) {
        this.billState = billState;
    }
    
}
