package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import static com.ejianc.framework.skeleton.template.BaseServiceImpl.changeToQueryWrapper;

@RestController
@RequestMapping("/api/order/")
public class OrderApi {

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private IOrderService orderService;

	@Autowired
	private IOrderDetailService orderDetailService;

	/**
	 * @Description queryList 订单内项目参照
	 * @param
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/queryOrderProjects", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<IPage<OrderProjectVO>> queryOrderProjects(
			@RequestParam(defaultValue = "1") Integer pageNumber,
			@RequestParam(defaultValue = "10") Integer pageSize,
			@RequestParam(value = "condition", required = false) String condition,
			@RequestParam(value = "searchText", required = false) String searchText) {
		/** 模糊搜索配置字段示例 */
		QueryParam queryParam = new QueryParam();
		queryParam.setPageIndex(pageNumber);
		queryParam.setPageSize(pageSize);
		queryParam.setSearchText(searchText);
		List<String> fuzzyFields = queryParam.getFuzzyFields();
		fuzzyFields.add("orgName");
		fuzzyFields.add("projectName");
		/** 租户隔离 */
		Long supplierId = null;
		if(StringUtils.isNotBlank(condition)) {
			Map<String, Object> conditionMap = JSONObject.parseObject(condition, Map.class);
			if(null != conditionMap.get("supplierId")) {
				supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
				logger.info("参数supplierId--"+supplierId);
			}
		}
		Page<OrderProjectVO> page = new Page<>((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
		QueryWrapper wrapper = changeToQueryWrapper(queryParam);
		List<OrderProjectVO> listres = orderService.queryOrderProjects(page,wrapper,supplierId);
		IPage<OrderProjectVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		pageData.setRecords(listres);
		return CommonResponse.success("查询列表数据成功！",pageData);
	}

	/**
	 * 根据物资明细id 获取发货单详情
	 *
	 * @param detailId 明细id
	 * @return
	 */
	@ApiOperation("根据物资明细id 获取订单详情")
	@RequestMapping(value = "/queryOrderByDetailId", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<OrderVO> queryOrderByDetailId(@RequestParam("detailId") Long detailId) {
		logger.info("物资明细id，查询参数：{}", detailId);
		OrderVO resVo = new OrderVO();
		OrderDetailEntity orderDetailEntity = orderDetailService.getById(detailId);
		if(null!=orderDetailEntity){
			OrderEntity orderEntity = orderService.getById(orderDetailEntity.getOrderId());
			resVo = BeanMapper.map(orderEntity,OrderVO.class);
			OrderDetailVO orderDetailVO = BeanMapper.map(orderDetailEntity,OrderDetailVO.class);
			List<OrderDetailVO> list = new ArrayList<>();
			list.add(orderDetailVO);
			resVo.setPurchaseOrderDetail(list);
		}
		logger.info("根据物资明细id 获取订单详情，查询结果：{}", JSONObject.toJSONString(resVo));
		return CommonResponse.success("查询成功",resVo);
	}


}
