package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.business.wzxt.bean.*;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.*;
import com.ejianc.business.wzxt.util.ThirdSystemUtil;
import com.ejianc.business.wzxt.vo.*;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 验收实体
 * 
 * @author generator
 * 
 */
@Service("checkService")
public class CheckServiceImpl extends BaseServiceImpl<CheckMapper, CheckEntity> implements ICheckService{
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static final String WZXT_CHECK = "WZXT_CHECK";

    @Autowired
    private IBillCodeApi billCodeApi;

    @Autowired
    private IMaterialApi materialApi;

    @Autowired
    private IUserApi userApi;

    @Autowired
    private ICheckDetailService checkDetailService;

    @Autowired
    private IOrderService orderService;

    @Autowired
    private IWeighbillApi weighbillApi;

    @Autowired
    private IOrderDetailService orderDetailService;

    @Autowired
    private IDeliveryService deliveryService;

    @Autowired
    private ICheckWeighService checkWeighService;

    @Autowired
    private IDeliveryDetailService deliveryDetailService;

    @Value("${sdbj.instoreUrl}")
    private String IN_STORE_URL;

    @Autowired
    private ThirdSystemUtil systemUtil;

    @Autowired
    private ISupplierApi supplierApi;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        CheckEntity entity = BeanMapper.map(saveorUpdateVO, CheckEntity.class);
        Long tenantId = InvocationInfoProxy.getTenantid();
        if(StringUtils.isEmpty(entity.getBillCode())){
            CommonResponse<String> billCode = billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if(billCode.isSuccess()) {
                entity.setBillCode(billCode.getData());
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }
        // 新增
        if(entity.getId() == null){
            entity.setUseState(0);// 未引用
            entity.setCheckState(1);// 已验收
            if(null==entity.getCheckWeighType()){
                entity.setCheckWeighType(CheckWeighTypeEnum.否磅单验收.getCode());
            }
            if(null==entity.getAutomaticWeigh()){// 自动称重设置（0：自动称重，1非自动称重）
                entity.setAutomaticWeigh(1);
            }
        }
        // 验收人来源ID
        if(entity.getEmployeeId() != null){
            entity.setEmployeeSourceId(this.getUserSourceId(entity.getEmployeeId()));
        }
        // 物料明细
        List<CheckDetailEntity> detailList = entity.getDetailList();
        if(CollectionUtils.isNotEmpty(detailList)){
            // 物料名称
            List<Long> materialIds = detailList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse<List<MaterialVO>> materialRes = materialApi.queryMaterialByIds(materialIds);
            if(!materialRes.isSuccess()){
                throw new BusinessException(materialRes.getCode(), materialRes.getMsg());
            }
            Map<Long, MaterialVO> materialVOMap = materialRes.getData().stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            StringBuffer materialName = new StringBuffer();
            detailList.forEach(detail ->{
                materialName.append(detail.getMaterialName()+",");
                if(materialVOMap.containsKey(detail.getMaterialId())){
                    MaterialVO materialVO = materialVOMap.get(detail.getMaterialId());
                    detail.setMaterialSourceId(materialVO.getSourceId());
                    detail.setMaterialTypeSourceId(materialVO.getCategorySourceId());
                    detail.setSystemId(materialVO.getSystemId());
                }
            });
            entity.setDetailList(detailList);
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
        }
        //磅单验收回显磅单数据信息
        if(CheckWeighTypeEnum.是磅单验收.getCode().equals(entity.getCheckWeighType())) {
            List<CheckWeighEntity> checkWeighListDel = new ArrayList<>();
            for (CheckWeighEntity checkWeighEntity : entity.getCheckWeighList()) {
                if("del".equals(checkWeighEntity.getRowState())){
                    checkWeighListDel.add(checkWeighEntity);
                }
            }
            this.delWeighBill(checkWeighListDel);
        }
        super.saveOrUpdate(entity, false);
        //磅单验收回显磅单数据信息
        if(CheckWeighTypeEnum.是磅单验收.getCode().equals(entity.getCheckWeighType())) {
            this.addOrUpdateWeighBill(entity.getDetailList(),entity.getCheckWeighList());
        }
        // 回写发货单验收状态及明细验收数量
        this.writeBackDelivery(saveorUpdateVO, true);
        // 回写订单验收状态及明细验收数量
        this.writeBackOrder(saveorUpdateVO, true);

        return BeanMapper.map(entity, CheckVO.class);
    }

    //保存删除回显磅单
    private void delWeighBill(List<CheckWeighEntity> checkWeighList) {
        List<WeighbillVO> upDateWeighBill = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(checkWeighList)){//验收删除磅单明细组合数据
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(checkWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(checkWeighEntity.getId());
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(0);//("验收状态，0-未验收,1-已验收")
                upDateWeighBill.add(weighbillVO);
            }
        }
        if(CollectionUtils.isNotEmpty(upDateWeighBill)){
            logger.info("保存删除回显磅单，数据信息：{}",JSONObject.toJSONString(upDateWeighBill));
            weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }
    //新增修改回显磅单
    private void addOrUpdateWeighBill(List<CheckDetailEntity> checkDetailList,List<CheckWeighEntity> checkWeighList) {
        List<WeighbillVO> upDateWeighBill = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(checkWeighList)){//循环验收明细和验收磅单明细组合数据
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if(CollectionUtils.isNotEmpty(checkDetailList)){
                    for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                        if(null!=checkWeighEntity.getDeliveryDetailId() && checkWeighEntity.getDeliveryDetailId().equals(checkDetailEntity.getDeliveryDetailId())){
                            weighbillVO.setCheckId(checkDetailEntity.getCheckId());
                            weighbillVO.setCheckDetailId(checkDetailEntity.getId());
                            //更新验收磅单信息
                            checkWeighEntity.setCheckDetailId(checkDetailEntity.getId());
                            checkWeighEntity.setCheckStatus(1);
                        }
                    }
                }
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(1);//("验收状态，0-未验收,1-已验收")
                upDateWeighBill.add(weighbillVO);
            }
        }
        if(CollectionUtils.isNotEmpty(checkWeighList)){
            logger.info("新增修改更新验收磅单，数据信息：{}",JSONObject.toJSONString(checkWeighList));
            checkWeighService.updateBatchById(checkWeighList);
        }
        if(CollectionUtils.isNotEmpty(upDateWeighBill)){
            logger.info("新增修改回显磅单，数据信息：{}",JSONObject.toJSONString(upDateWeighBill));
            weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return baseMapper.querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return baseMapper.queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = deliveryService.getById(deliveryId);
        OrderEntity orderEntity = orderService.selectById(delivery.getOrderId());
        vo.setProjectId(delivery.getProjectId());// 项目主键
        vo.setProjectSourceId(delivery.getProjectSourceId());// 项目来源id
        vo.setProjectName(delivery.getProjectName());// 项目名称
        vo.setOrgId(delivery.getOrgId());// 组织主键
        vo.setOrgName(delivery.getOrgName());// 组织名称
        vo.setContractId(delivery.getContractId());// 合同主键
        vo.setContractName(delivery.getContractName());// 合同名称
        vo.setSupplierId(delivery.getSupplierId());// 供方主键
        vo.setSupplierName(delivery.getSupplierName());// 供方名称
        vo.setSupplierTenantId(delivery.getTenantId());// 发货单租户id为供方租户id
        vo.setLicensePlate(delivery.getDeliveryCarNumber());// 车牌号
        vo.setMaterialName(delivery.getMaterialName());// 物资名称
        vo.setOrderId(delivery.getOrderId());// 订单主键
        vo.setDeliveryId(deliveryId);// 发货单主键
        vo.setConstruction(delivery.getConstruction());// 使用部位
        vo.setAutomaticWeigh(orderEntity.getAutomaticWeigh()==null?1:orderEntity.getAutomaticWeigh());//根据订单判断 是否智能称重
        // 发货单明细生成验收单明细
        List<DeliveryDetailEntity> deliveryDetailList = deliveryDetailService.list(
                new LambdaQueryWrapper<DeliveryDetailEntity>().eq(DeliveryDetailEntity::getDeliveryId, delivery.getId()));
        if(CollectionUtils.isNotEmpty(deliveryDetailList)){
            Map<Long,Integer> map=new HashMap<>();
            orderEntity.getPurchaseOrderDetail().forEach(e->{
                if(!map.containsKey(e.getId())){
                    map.put(e.getId(),e.getDetailAutomaticWeigh()==null?1:e.getDetailAutomaticWeigh());
                }
            });
            List<CheckDetailVO> detailList = new ArrayList<>();
            deliveryDetailList.forEach(dd ->{
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);// 发货单主键
                detail.setDeliveryDetailId(dd.getId());// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getOrderDetailId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());// 发货数量
                if(null!=map&&map.size()>0){
                    detail.setDetailAutomaticWeigh(map.get(dd.getOrderDetailId()));//根据订单判断 是否智能称重
                }else{
                    detail.setDetailAutomaticWeigh(1);//根据订单判断 是否智能称重
                }
                detailList.add(detail);
            });
            if(CollectionUtils.isNotEmpty(detailList)){
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public CheckVO orderToCheck(Long orderId) {
        // 发货单生成验收单
        CheckVO vo = new CheckVO();
        OrderEntity orderEntity = orderService.selectById(orderId);
        vo.setProjectId(orderEntity.getProjectId());// 项目主键
        vo.setProjectSourceId(orderEntity.getProjectSourceId());// 项目来源id
        vo.setProjectName(orderEntity.getProjectName());// 项目名称
        vo.setOrgId(orderEntity.getOrgId());// 组织主键
        vo.setOrgName(orderEntity.getOrgName());// 组织名称
        vo.setContractId(orderEntity.getContractId());// 合同主键
        vo.setContractName(orderEntity.getContractName());// 合同名称
        vo.setSupplierId(orderEntity.getSupplierId());// 供方主键
        vo.setSupplierName(orderEntity.getSupplierName());// 供方名称
        vo.setSupplierTenantId(orderEntity.getTenantId());// 发货单租户id为供方租户id
//        vo.setLicensePlate(orderEntity.getDeliveryCarNumber());// 车牌号
        vo.setMaterialName(orderEntity.getMaterialName());// 物资名称
        vo.setOrderId(orderId);// 订单主键
//        vo.setDeliveryId(orderEntityId);// 发货单主键
        vo.setConstruction(orderEntity.getConstruction());// 使用部位
        vo.setAutomaticWeigh(orderEntity.getAutomaticWeigh()==null?1:orderEntity.getAutomaticWeigh());//根据订单判断 是否智能称重
        // 发货单明细生成验收单明细
        List<OrderDetailEntity> orderEntityDetailList = orderDetailService.list(
                new LambdaQueryWrapper<OrderDetailEntity>().eq(OrderDetailEntity::getOrderId, orderEntity.getId()));
        if(CollectionUtils.isNotEmpty(orderEntityDetailList)){
            List<CheckDetailVO> detailList = new ArrayList<>();
            orderEntityDetailList.forEach(dd ->{
                CheckDetailVO detail = new CheckDetailVO();
//                detail.setDeliveryId(deliveryId);// 发货单主键
//                detail.setDeliveryDetailId(dd.getId());// 发货单明细主键
                detail.setOrderId(dd.getOrderId());// 订单主键
                detail.setOrderDetailId(dd.getId());// 订单明细主键
                detail.setMaterialTypeId(dd.getMaterialTypeId());// 物料分类主键
                detail.setMaterialTypeName(dd.getMaterialTypeName());// 物料分类名称
                detail.setMaterialId(dd.getMaterialId());// 物料主键
                detail.setMaterialCode(dd.getMaterialCode());// 物料编码
                detail.setMaterialName(dd.getMaterialName());// 物料名称
                detail.setUnit(dd.getUnit());// 单位
                detail.setSpec(dd.getSpec());// 规格型号
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());// 生产厂家
//                detail.setDeliverNumsSum(dd.getDeliverNumsSum());// 发货数量
                detail.setDetailAutomaticWeigh(dd.getDetailAutomaticWeigh()==null?1:dd.getDetailAutomaticWeigh());//根据订单判断 是否智能称重
                detailList.add(detail);
            });
            if(CollectionUtils.isNotEmpty(detailList)){
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List<CheckEntity> entityList = baseMapper.selectList(new QueryWrapper<CheckEntity>().in("id", ids));
        if(CollectionUtils.isNotEmpty(entityList)){
            entityList.forEach(entity ->{
                if(entity.getUseState() == 1){
                    throw new BusinessException("单据已被引用，不允许删除！");
                }
            });
        }
        List<CheckVO> vos = BeanMapper.mapList(entityList, CheckVO.class);
        if(CollectionUtils.isNotEmpty(vos)){
            vos.forEach(vo ->{
                // 回写发货单验收状态及明细验收数量
                this.writeBackDelivery(vo, false);
                // 回写订单验收状态及明细验收数量
                this.writeBackOrder(vo, false);

            });
        }
        if(CollectionUtils.isNotEmpty(entityList)){
            entityList.forEach(entity ->{
                List<CheckWeighEntity> checkWeighList = entity.getCheckWeighList();
                this.delWeighBill(checkWeighList);//删除回显磅单
            });
        }
        return super.removeByIds(ids, true);
    }

    @Override
    public Boolean pushThirdStore(Long id) {
        CheckEntity entity = super.selectById(id);
        if(entity.getPushState() != null && entity.getPushState() == 1){
            throw new BusinessException("验收单已经推送，请勿重复推送！");
        }
        // 1:甲供材;2:自购周转材;4:租赁周转材;5:工程退库;6:自购消耗材;8:调拨;9:零星采购;10:代保管产品及自制半成品;11:委托加工验收入库
        String type = "";
        if(entity.getCheckType().equals("1")) {
            type = "6";// 自购消耗材
        } else if(entity.getCheckType().equals("2")) {
            type = "2";// 自购周转材
        } else if(entity.getCheckType().equals("3")) {
            type = "4";// 租赁周转材
        } else if(entity.getCheckType().equals("4")) {
            type = "9";// 零星采购
        } else if(entity.getCheckType().equals("5")) {
            type = "1";// 甲供材
        }
        String provdercode = "";
        CommonResponse<SupplierVO> resp = supplierApi.queryById(entity.getSupplierId());
        if(resp.isSuccess()){
            provdercode = resp.getData().getCode();
        }
        Map<String, Object> param = new HashMap<>();
        param.put("acceptno", entity.getId());
        param.put("projectid", entity.getProjectSourceId());
        param.put("name", StringUtils.isNotEmpty(entity.getBillName()) ? entity.getBillName() : entity.getBillCode());
        param.put("type", type);
        param.put("provdercode", provdercode);
        param.put("storehouseid", entity.getProjectInstoreId());
        param.put("iscontract", StringUtils.isNotEmpty(entity.getContractId()) ? "2" : "1");// 1:否;2:是
        param.put("isprovisional", "1");// 1:否;2:是（可以默认为否）
        param.put("contractid", entity.getContractId());
        param.put("checkdate", entity.getCheckDate());
        param.put("acceptmanid", entity.getEmployeeSourceId());
        JSONArray details = new JSONArray();
        for(CheckDetailEntity detail : entity.getDetailList()){
            JSONObject obj = new JSONObject();
            obj.put("resourceid", detail.getMaterialSourceId());
            obj.put("delivernum", detail.getDeliverNumsSum());
            obj.put("qty", detail.getCheckNumsSum());
            details.add(obj);
        }
        param.put("details", details);
        try {
            CommonResponse<JSONObject> response = systemUtil.sendPostReq(IN_STORE_URL, JSON.toJSONString(param));
            if(!response.isSuccess()) {
                throw new BusinessException("物资验收入库推送失败，" + response.getMsg());
            }
        } catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("物资验收入库推送失败");
        }
        entity.setPushState(1);
        super.saveOrUpdate(entity, false);
        return true;
    }

    /**
     * 回写发货单验收状态及明细验收数量
     * @param checkVO
     */
    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        // 回写验收状态
        if(checkVO.getDeliveryId() != null){
            if(null == checkVO.getId() || !flag){
                DeliveryEntity delivery = deliveryService.getById(checkVO.getDeliveryId());
                delivery.setDeliverState(flag ? 2 : 1);
                deliveryService.updateById(delivery);
            }
        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<DeliveryDetailEntity> ddEditList = new ArrayList<>();// 发货单明细
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                if(vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum()==null?BigDecimal.ZERO:vo.getCheckNumsSum();//前端传的验收数量
                    if(null == vo.getId() || !flag || "del".equals(vo.getRowState())){
                        // 新增或删除
                        DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                        BigDecimal ddCheckNums = ddEntity.getCheckNumsSum()==null?BigDecimal.ZERO:ddEntity.getCheckNumsSum();// 发货单明细验收数量
                        ddCheckNums = flag ? "del".equals(vo.getRowState()) ? ddCheckNums.subtract(checkNums) : ddCheckNums.add(checkNums) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum()==null?BigDecimal.ZERO:detailEntity.getCheckNumsSum();// 数据库验收数量
                        if(checkNums.compareTo(checkNumsDb) != 0){
                            //说明验收数量有修改
                            DeliveryDetailEntity ddEntity = deliveryDetailService.getById(vo.getDeliveryDetailId());
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum()==null?BigDecimal.ZERO:ddEntity.getCheckNumsSum();// 发货单明细验收数量
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(ddEditList)){
                deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    /**
     * 回写订单验收状态及明细验收数量
     * @param checkVO
     */
    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        // 回写验收状态（暂不回写）
//        if(checkVO.getOrderId() != null){
//            if(null == checkVO.getId() || !flag){
//                OrderEntity order = orderService.getById(checkVO.getOrderId());
//                order.setDeliverState(flag ? 2 : 1);
//                orderService.updateById(order);
//            }
//        }

        // 验收单明细
        List<CheckDetailVO> detailList = checkVO.getDetailList();
        // 回写明细验收数量
        List<OrderDetailEntity> odEditList = new ArrayList<>();// 订单明细
        if(CollectionUtils.isNotEmpty(detailList)){
            detailList.forEach(vo -> {
                if(vo.getOrderDetailId() != null) {
                    BigDecimal checkNums = vo.getCheckNumsSum()==null?BigDecimal.ZERO:vo.getCheckNumsSum();//前端传的验收数量
                    if(null == vo.getId() || !flag || "del".equals(vo.getRowState())){
                        // 新增或删除
                        OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                        BigDecimal odCheckNums = odEntity.getCheckNumsSum()==null?BigDecimal.ZERO:odEntity.getCheckNumsSum();// 订单明细验收数量
                        odCheckNums = flag ? "del".equals(vo.getRowState()) ? odCheckNums.subtract(checkNums) : odCheckNums.add(checkNums) : odCheckNums.subtract(checkNums);//例子  200 + 80
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        // 编辑
                        CheckDetailEntity detailEntity = checkDetailService.getById(vo.getId());
                        BigDecimal checkNumsDb = detailEntity.getCheckNumsSum()==null?BigDecimal.ZERO:detailEntity.getCheckNumsSum();// 数据库验收数量
                        if(checkNums.compareTo(checkNumsDb) != 0){
                            //说明验收数量有修改
                            OrderDetailEntity odEntity = orderDetailService.getById(vo.getOrderDetailId());
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum()==null?BigDecimal.ZERO:odEntity.getCheckNumsSum();// 订单明细验收数量
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if(CollectionUtils.isNotEmpty(odEditList)){
                orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    /**
     * 获取用户sourceId
     * @return
     */
    private String getUserSourceId(Long userid) {
        CommonResponse<List<UserVO>> res = userApi.queryListByIds(new String[]{String.valueOf(userid)});
        if(!res.isSuccess()){
            throw new BusinessException("查询用户失败！");
        }
        if(CollectionUtils.isNotEmpty(res.getData())){
            UserVO vo = res.getData().get(0);// 获取用户VO
            if(vo != null && StringUtils.isNotEmpty(vo.getSourceId())){
                return vo.getSourceId();// 来源ID
            }
        }
        return null;
    }

    @Override
    public CheckVO queryDetailWeigh(CheckVO vo) {
        CheckVO checkVO = new CheckVO();
        if(null!=vo.getDeliveryId()){
            //基于发货单验收
            checkVO = this.deliveryToCheck(vo.getDeliveryId());
        }else{
            checkVO = this.orderToCheck(vo.getOrderId());
        }
        logger.info("----磅单验收原数据 ：{}",JSONObject.toJSONString(checkVO));
        List<CheckDetailVO> checkDetailList = checkVO.getDetailList();
        List<CheckWeighVO> checkWeighList = vo.getCheckWeighList();
        List<CheckWeighVO> checkWeighVOS = new ArrayList<>();
        if(CollectionUtils.isNotEmpty(checkWeighList)){
            List<Long> collect = checkWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse<List<WeighbillVO>> listCommonResponse = weighbillApi.queryWeighbills(checkVO.getProjectId(), collect);
            if(!listCommonResponse.isSuccess()){
                throw new BusinessException("查询磅单失败！错误信息："+listCommonResponse.getMsg());
            }
            List<WeighbillVO> data = listCommonResponse.getData();
            if(CollectionUtils.isNotEmpty(data)){
                for (WeighbillVO weighbillVO : data) {
                    CheckWeighVO checkWeighVO = BeanMapper.map(weighbillVO, CheckWeighVO.class);
                    if(null!=vo.getDeliveryId()){
                        //基于发货单验收
                    }else{
                        checkWeighVO.setOrderId(checkWeighVO.getDeliveryId());
                        checkWeighVO.setOrderDetailId(checkWeighVO.getDeliveryDetailId());
                        checkWeighVO.setDeliveryId(null);
                        checkWeighVO.setDeliveryDetailId(null);
                    }
                    BigDecimal netWeight = weighbillVO.getNetWeight();//净重
                    BigDecimal coefficient = weighbillVO.getCoefficient();//换算系数
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Long, List<CheckWeighVO>> weighMap = new HashMap<>();

                if(null!=vo.getDeliveryId()){
                    //基于发货单验收
                    weighMap = checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getDeliveryDetailId));
                }else{
                    weighMap = checkWeighVOS.stream().filter(t -> null != t.getOrderDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getOrderDetailId));
                }
                if(CollectionUtils.isNotEmpty(checkDetailList)){
                    for (CheckDetailVO checkDetailVO : checkDetailList) {
                        List<CheckWeighVO> checkWeighS = new ArrayList<>();
                        if(null!=vo.getDeliveryId()){
                            //基于发货单验收
                            checkWeighS = weighMap.get(checkDetailVO.getDeliveryDetailId());
                        }else{
                            checkWeighS = weighMap.get(checkDetailVO.getOrderDetailId());
                        }
                        if(null!=checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)){
                            BigDecimal checkNum = checkWeighS.stream().map(CheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(CheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(CheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv(detailNetWeightCoefficient,checkNum));
                            checkDetailVO.setCheckNumsSum(checkNum);
                        }else {
                            checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                            checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                            checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                            checkDetailVO.setCheckNumsSum(BigDecimal.ZERO);
                        }
                    }
                }
            }
        }
        checkVO.setCheckWeighType(CheckWeighTypeEnum.是磅单验收.getCode());
        checkVO.setDetailList(checkDetailList);
        checkVO.setCheckWeighList(checkWeighVOS);
        return checkVO;
    }

    public Map<String,BigDecimal> getCheckNum(String weighUnit,BigDecimal netWeight,BigDecimal coefficient){
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        Map<String,BigDecimal>  map = new HashMap<>();
        if(null==coefficient){
            coefficient = BigDecimal.ZERO;
        }
        if(null==netWeight){
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if(org.apache.commons.lang.StringUtils.isNotEmpty(weighUnit)){
            billStateCode = WeighUnitEnum.getEnumByStateCode(weighUnit).getBillStateCode();
        }
        switch (billStateCode){
            case 0:
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient,coefficient); break;
            case 1:
                detailNetWeightCoefficient = ComputeUtil.safeMultiply(netWeight,new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv(detailNetWeightCoefficient,coefficient);;break;
        }
        map.put("checkNum",checkNum);
        map.put("detailNetWeightCoefficient",detailNetWeightCoefficient);
        return map;
    }
}
