/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.weigh.weighbill.api.IWeighbillApi;
import com.ejianc.business.weigh.weighbill.vo.WeighbillVO;
import com.ejianc.business.wzxt.bean.CheckDetailEntity;
import com.ejianc.business.wzxt.bean.CheckEntity;
import com.ejianc.business.wzxt.bean.CheckWeighEntity;
import com.ejianc.business.wzxt.bean.DeliveryDetailEntity;
import com.ejianc.business.wzxt.bean.DeliveryEntity;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.mapper.CheckMapper;
import com.ejianc.business.wzxt.service.ICheckDetailService;
import com.ejianc.business.wzxt.service.ICheckService;
import com.ejianc.business.wzxt.service.ICheckWeighService;
import com.ejianc.business.wzxt.service.IDeliveryDetailService;
import com.ejianc.business.wzxt.service.IDeliveryService;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.util.ThirdSystemUtil;
import com.ejianc.business.wzxt.vo.CheckAnalysisVO;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckDetailsVO;
import com.ejianc.business.wzxt.vo.CheckVO;
import com.ejianc.business.wzxt.vo.CheckWeighTypeEnum;
import com.ejianc.business.wzxt.vo.CheckWeighVO;
import com.ejianc.business.wzxt.vo.WeighUnitEnum;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.share.api.IMaterialApi;
import com.ejianc.foundation.share.vo.MaterialVO;
import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.ISupplierApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="checkService")
public class CheckServiceImpl
extends BaseServiceImpl<CheckMapper, CheckEntity>
implements ICheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final String WZXT_CHECK = "WZXT_CHECK";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IMaterialApi materialApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private ICheckDetailService checkDetailService;
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IWeighbillApi weighbillApi;
    @Autowired
    private IOrderDetailService orderDetailService;
    @Autowired
    private IDeliveryService deliveryService;
    @Autowired
    private ICheckWeighService checkWeighService;
    @Autowired
    private IDeliveryDetailService deliveryDetailService;
    @Value(value="${sdbj.instoreUrl}")
    private String IN_STORE_URL;
    @Autowired
    private ThirdSystemUtil systemUtil;
    @Autowired
    private ISupplierApi supplierApi;

    @Override
    public CheckVO saveOrUpdate(CheckVO saveorUpdateVO) {
        List<CheckDetailEntity> detailList;
        CheckEntity entity = (CheckEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, CheckEntity.class));
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (com.baomidou.mybatisplus.core.toolkit.StringUtils.isEmpty((CharSequence)entity.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_CHECK, tenantId);
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (entity.getId() == null) {
            entity.setUseState(0);
            entity.setCheckState(1);
            if (null == entity.getCheckWeighType()) {
                entity.setCheckWeighType(CheckWeighTypeEnum.\u5426\u78c5\u5355\u9a8c\u6536.getCode());
            }
            if (null == entity.getAutomaticWeigh()) {
                entity.setAutomaticWeigh(1);
            }
        }
        if (entity.getEmployeeId() != null) {
            entity.setEmployeeSourceId(this.getUserSourceId(entity.getEmployeeId()));
        }
        if (CollectionUtils.isNotEmpty(detailList = entity.getDetailList())) {
            List materialIds = detailList.stream().map(CheckDetailEntity::getMaterialId).collect(Collectors.toList());
            CommonResponse materialRes = this.materialApi.queryMaterialByIds(materialIds);
            if (!materialRes.isSuccess()) {
                throw new BusinessException(Integer.valueOf(materialRes.getCode()), materialRes.getMsg());
            }
            Map materialVOMap = ((List)materialRes.getData()).stream().collect(Collectors.toMap(MaterialVO::getId, Function.identity()));
            StringBuffer materialName = new StringBuffer();
            detailList.forEach(detail -> {
                materialName.append(detail.getMaterialName() + ",");
                if (materialVOMap.containsKey(detail.getMaterialId())) {
                    MaterialVO materialVO = (MaterialVO)materialVOMap.get(detail.getMaterialId());
                    detail.setMaterialSourceId(materialVO.getSourceId());
                    detail.setMaterialTypeSourceId(materialVO.getCategorySourceId());
                    detail.setSystemId(materialVO.getSystemId());
                }
            });
            entity.setDetailList(detailList);
            String materialNames = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(materialNames);
        }
        if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
            ArrayList<CheckWeighEntity> checkWeighListDel = new ArrayList<CheckWeighEntity>();
            for (CheckWeighEntity checkWeighEntity : entity.getCheckWeighList()) {
                if (!"del".equals(checkWeighEntity.getRowState())) continue;
                checkWeighListDel.add(checkWeighEntity);
            }
            this.delWeighBill(checkWeighListDel);
        }
        super.saveOrUpdate((Object)entity, false);
        if (CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode().equals(entity.getCheckWeighType())) {
            this.addOrUpdateWeighBill(entity.getDetailList(), entity.getCheckWeighList());
        }
        this.writeBackDelivery(saveorUpdateVO, true);
        this.writeBackOrder(saveorUpdateVO, true);
        return (CheckVO)BeanMapper.map((Object)((Object)entity), CheckVO.class);
    }

    private void delWeighBill(List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                weighbillVO.setCheckId(checkWeighEntity.getCheckId());
                weighbillVO.setCheckDetailId(checkWeighEntity.getId());
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(0));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u4fdd\u5b58\u5220\u9664\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    private void addOrUpdateWeighBill(List<CheckDetailEntity> checkDetailList, List<CheckWeighEntity> checkWeighList) {
        ArrayList<WeighbillVO> upDateWeighBill = new ArrayList<WeighbillVO>();
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            for (CheckWeighEntity checkWeighEntity : checkWeighList) {
                WeighbillVO weighbillVO = new WeighbillVO();
                if (CollectionUtils.isNotEmpty(checkDetailList)) {
                    for (CheckDetailEntity checkDetailEntity : checkDetailList) {
                        if (null == checkWeighEntity.getDeliveryDetailId() || !checkWeighEntity.getDeliveryDetailId().equals(checkDetailEntity.getDeliveryDetailId())) continue;
                        weighbillVO.setCheckId(checkDetailEntity.getCheckId());
                        weighbillVO.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckDetailId(checkDetailEntity.getId());
                        checkWeighEntity.setCheckStatus(1);
                    }
                }
                weighbillVO.setId(checkWeighEntity.getWeightId());
                weighbillVO.setCheckStatus(Integer.valueOf(1));
                upDateWeighBill.add(weighbillVO);
            }
        }
        if (CollectionUtils.isNotEmpty(checkWeighList)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u66f4\u65b0\u9a8c\u6536\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(checkWeighList));
            this.checkWeighService.updateBatchById(checkWeighList);
        }
        if (CollectionUtils.isNotEmpty(upDateWeighBill)) {
            this.logger.info("\u65b0\u589e\u4fee\u6539\u56de\u663e\u78c5\u5355\uff0c\u6570\u636e\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(upDateWeighBill));
            this.weighbillApi.updateWeighbills(upDateWeighBill);
        }
    }

    @Override
    public List<CheckAnalysisVO> querAnalysisList(Page<CheckAnalysisVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).querAnalysisList(page, queryWrapper);
    }

    @Override
    public List<CheckDetailsVO> queryDetailsList(Page<CheckDetailsVO> page, QueryWrapper queryWrapper) {
        return ((CheckMapper)this.baseMapper).queryDetailsList(page, queryWrapper);
    }

    @Override
    public CheckVO deliveryToCheck(Long deliveryId) {
        CheckVO vo = new CheckVO();
        DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(deliveryId));
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(delivery.getOrderId()));
        vo.setProjectId(delivery.getProjectId());
        vo.setProjectSourceId(delivery.getProjectSourceId());
        vo.setProjectName(delivery.getProjectName());
        vo.setOrgId(delivery.getOrgId());
        vo.setOrgName(delivery.getOrgName());
        vo.setContractId(delivery.getContractId());
        vo.setContractName(delivery.getContractName());
        vo.setSupplierId(delivery.getSupplierId());
        vo.setSupplierName(delivery.getSupplierName());
        vo.setSupplierTenantId(delivery.getTenantId());
        vo.setLicensePlate(delivery.getDeliveryCarNumber());
        vo.setMaterialName(delivery.getMaterialName());
        vo.setOrderId(delivery.getOrderId());
        vo.setDeliveryId(deliveryId);
        vo.setConstruction(delivery.getConstruction());
        vo.setAutomaticWeigh(Integer.valueOf(orderEntity.getAutomaticWeigh() == null ? 1 : orderEntity.getAutomaticWeigh()));
        List deliveryDetailList = this.deliveryDetailService.list((Wrapper)new LambdaQueryWrapper().eq(DeliveryDetailEntity::getDeliveryId, (Object)delivery.getId()));
        if (CollectionUtils.isNotEmpty((Collection)deliveryDetailList)) {
            HashMap map = new HashMap();
            orderEntity.getPurchaseOrderDetail().forEach(e -> {
                if (!map.containsKey(e.getId())) {
                    map.put(e.getId(), e.getDetailAutomaticWeigh() == null ? 1 : e.getDetailAutomaticWeigh());
                }
            });
            ArrayList detailList = new ArrayList();
            deliveryDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setDeliveryId(deliveryId);
                detail.setDeliveryDetailId(dd.getId());
                detail.setOrderId(dd.getOrderId());
                detail.setOrderDetailId(dd.getOrderDetailId());
                detail.setMaterialTypeId(dd.getMaterialTypeId());
                detail.setMaterialTypeName(dd.getMaterialTypeName());
                detail.setMaterialId(dd.getMaterialId());
                detail.setMaterialCode(dd.getMaterialCode());
                detail.setMaterialName(dd.getMaterialName());
                detail.setUnit(dd.getUnit());
                detail.setSpec(dd.getSpec());
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());
                detail.setDeliverNumsSum(dd.getDeliverNumsSum());
                if (null != map && map.size() > 0) {
                    detail.setDetailAutomaticWeigh((Integer)map.get(dd.getOrderDetailId()));
                } else {
                    detail.setDetailAutomaticWeigh(Integer.valueOf(1));
                }
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(detailList)) {
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public CheckVO orderToCheck(Long orderId) {
        CheckVO vo = new CheckVO();
        OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.selectById(orderId));
        vo.setProjectId(orderEntity.getProjectId());
        vo.setProjectSourceId(orderEntity.getProjectSourceId());
        vo.setProjectName(orderEntity.getProjectName());
        vo.setOrgId(orderEntity.getOrgId());
        vo.setOrgName(orderEntity.getOrgName());
        vo.setContractId(orderEntity.getContractId());
        vo.setContractName(orderEntity.getContractName());
        vo.setSupplierId(orderEntity.getSupplierId());
        vo.setSupplierName(orderEntity.getSupplierName());
        vo.setSupplierTenantId(orderEntity.getTenantId());
        vo.setMaterialName(orderEntity.getMaterialName());
        vo.setOrderId(orderId);
        vo.setConstruction(orderEntity.getConstruction());
        vo.setAutomaticWeigh(Integer.valueOf(orderEntity.getAutomaticWeigh() == null ? 1 : orderEntity.getAutomaticWeigh()));
        List orderEntityDetailList = this.orderDetailService.list((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(OrderDetailEntity::getOrderId, (Object)orderEntity.getId())).eq(OrderDetailEntity::getLeafFlag, (Object)true));
        if (CollectionUtils.isNotEmpty((Collection)orderEntityDetailList)) {
            ArrayList detailList = new ArrayList();
            orderEntityDetailList.forEach(dd -> {
                CheckDetailVO detail = new CheckDetailVO();
                detail.setOrderId(dd.getOrderId());
                detail.setOrderDetailId(dd.getId());
                detail.setMaterialTypeId(dd.getMaterialTypeId());
                detail.setMaterialTypeName(dd.getMaterialTypeName());
                detail.setMaterialId(dd.getMaterialId());
                detail.setMaterialCode(dd.getMaterialCode());
                detail.setMaterialName(dd.getMaterialName());
                detail.setUnit(dd.getUnit());
                detail.setSpec(dd.getSpec());
                detail.setMaterialManufacturer(dd.getMaterialManufacturer());
                detail.setDetailAutomaticWeigh(Integer.valueOf(dd.getDetailAutomaticWeigh() == null ? 1 : dd.getDetailAutomaticWeigh()));
                detailList.add(detail);
            });
            if (CollectionUtils.isNotEmpty(detailList)) {
                vo.setDetailList(detailList);
            }
        }
        return vo;
    }

    @Override
    public Boolean deleteIds(List<Long> ids) {
        List vos;
        List entityList = ((CheckMapper)this.baseMapper).selectList((Wrapper)new QueryWrapper().in((Object)"id", ids));
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                if (entity.getUseState() == 1) {
                    throw new BusinessException("\u5355\u636e\u5df2\u88ab\u5f15\u7528\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
                }
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)(vos = BeanMapper.mapList((Iterable)entityList, CheckVO.class)))) {
            vos.forEach(vo -> {
                this.writeBackDelivery((CheckVO)vo, false);
                this.writeBackOrder((CheckVO)vo, false);
            });
        }
        if (CollectionUtils.isNotEmpty((Collection)entityList)) {
            entityList.forEach(entity -> {
                List<CheckWeighEntity> checkWeighList = entity.getCheckWeighList();
                this.delWeighBill(checkWeighList);
            });
        }
        return super.removeByIds(ids, true);
    }

    @Override
    public Boolean pushThirdStore(Long id) {
        CheckEntity entity = (CheckEntity)((Object)super.selectById((Serializable)id));
        if (entity.getPushState() != null && entity.getPushState() == 1) {
            throw new BusinessException("\u9a8c\u6536\u5355\u5df2\u7ecf\u63a8\u9001\uff0c\u8bf7\u52ff\u91cd\u590d\u63a8\u9001\uff01");
        }
        String type = "";
        if (entity.getCheckType().equals("1")) {
            type = "6";
        } else if (entity.getCheckType().equals("2")) {
            type = "2";
        } else if (entity.getCheckType().equals("3")) {
            type = "4";
        } else if (entity.getCheckType().equals("4")) {
            type = "9";
        } else if (entity.getCheckType().equals("5")) {
            type = "1";
        }
        String provdercode = "";
        CommonResponse resp = this.supplierApi.queryById(entity.getSupplierId());
        if (resp.isSuccess()) {
            provdercode = ((SupplierVO)resp.getData()).getCode();
        }
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("acceptno", entity.getId());
        param.put("projectid", entity.getProjectSourceId());
        param.put("name", com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)entity.getBillName()) ? entity.getBillName() : entity.getBillCode());
        param.put("type", type);
        param.put("provdercode", provdercode);
        param.put("storehouseid", entity.getProjectInstoreId());
        param.put("iscontract", com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)entity.getContractId()) ? "2" : "1");
        param.put("isprovisional", "1");
        param.put("contractid", entity.getContractId());
        param.put("checkdate", entity.getCheckDate());
        param.put("acceptmanid", entity.getEmployeeSourceId());
        JSONArray details = new JSONArray();
        for (CheckDetailEntity detail : entity.getDetailList()) {
            JSONObject obj = new JSONObject();
            obj.put("resourceid", (Object)detail.getMaterialSourceId());
            obj.put("delivernum", (Object)detail.getDeliverNumsSum());
            obj.put("qty", (Object)detail.getCheckNumsSum());
            details.add((Object)obj);
        }
        param.put("details", details);
        try {
            CommonResponse<JSONObject> response = this.systemUtil.sendPostReq(this.IN_STORE_URL, JSON.toJSONString(param));
            if (!response.isSuccess()) {
                throw new BusinessException("\u7269\u8d44\u9a8c\u6536\u5165\u5e93\u63a8\u9001\u5931\u8d25\uff0c" + response.getMsg());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BusinessException("\u7269\u8d44\u9a8c\u6536\u5165\u5e93\u63a8\u9001\u5931\u8d25");
        }
        entity.setPushState(1);
        super.saveOrUpdate((Object)entity, false);
        return true;
    }

    private void writeBackDelivery(CheckVO checkVO, Boolean flag) {
        if (!(checkVO.getDeliveryId() == null || null != checkVO.getId() && flag.booleanValue())) {
            DeliveryEntity delivery = (DeliveryEntity)((Object)this.deliveryService.getById(checkVO.getDeliveryId()));
            delivery.setDeliverState(flag != false ? 2 : 1);
            this.deliveryService.updateById((Object)delivery);
        }
        List detailList = checkVO.getDetailList();
        ArrayList ddEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getDeliveryDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue() || "del".equals(vo.getRowState())) {
                        BigDecimal ddCheckNums;
                        DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                        BigDecimal bigDecimal2 = ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                        ddCheckNums = flag.booleanValue() ? ("del".equals(vo.getRowState()) ? ddCheckNums.subtract(checkNums) : ddCheckNums.add(checkNums)) : ddCheckNums.subtract(checkNums);
                        ddEntity.setCheckNumsSum(ddCheckNums);
                        ddEditList.add(ddEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal3 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            DeliveryDetailEntity ddEntity = (DeliveryDetailEntity)((Object)((Object)this.deliveryDetailService.getById(vo.getDeliveryDetailId())));
                            BigDecimal ddCheckNums = ddEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : ddEntity.getCheckNumsSum();
                            ddCheckNums = ddCheckNums.subtract(checkNumsDb).add(checkNums);
                            ddEntity.setCheckNumsSum(ddCheckNums);
                            ddEditList.add(ddEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(ddEditList)) {
                this.deliveryDetailService.updateBatchById(ddEditList);
            }
        }
    }

    private void writeBackOrder(CheckVO checkVO, Boolean flag) {
        List detailList = checkVO.getDetailList();
        ArrayList odEditList = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)detailList)) {
            detailList.forEach(vo -> {
                if (vo.getOrderDetailId() != null) {
                    BigDecimal checkNums;
                    BigDecimal bigDecimal = checkNums = vo.getCheckNumsSum() == null ? BigDecimal.ZERO : vo.getCheckNumsSum();
                    if (null == vo.getId() || !flag.booleanValue() || "del".equals(vo.getRowState())) {
                        BigDecimal odCheckNums;
                        OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                        BigDecimal bigDecimal2 = odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                        odCheckNums = flag.booleanValue() ? ("del".equals(vo.getRowState()) ? odCheckNums.subtract(checkNums) : odCheckNums.add(checkNums)) : odCheckNums.subtract(checkNums);
                        odEntity.setCheckNumsSum(odCheckNums);
                        odEditList.add(odEntity);
                    } else {
                        BigDecimal checkNumsDb;
                        CheckDetailEntity detailEntity = (CheckDetailEntity)((Object)((Object)this.checkDetailService.getById(vo.getId())));
                        BigDecimal bigDecimal3 = checkNumsDb = detailEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : detailEntity.getCheckNumsSum();
                        if (checkNums.compareTo(checkNumsDb) != 0) {
                            OrderDetailEntity odEntity = (OrderDetailEntity)((Object)((Object)this.orderDetailService.getById(vo.getOrderDetailId())));
                            BigDecimal odCheckNums = odEntity.getCheckNumsSum() == null ? BigDecimal.ZERO : odEntity.getCheckNumsSum();
                            odCheckNums = odCheckNums.subtract(checkNumsDb).add(checkNums);
                            odEntity.setCheckNumsSum(odCheckNums);
                            odEditList.add(odEntity);
                        }
                    }
                }
            });
            if (CollectionUtils.isNotEmpty(odEditList)) {
                this.orderDetailService.updateBatchById(odEditList);
            }
        }
    }

    private String getUserSourceId(Long userid) {
        UserVO vo;
        CommonResponse res = this.userApi.queryListByIds(new String[]{String.valueOf(userid)});
        if (!res.isSuccess()) {
            throw new BusinessException("\u67e5\u8be2\u7528\u6237\u5931\u8d25\uff01");
        }
        if (CollectionUtils.isNotEmpty((Collection)((Collection)res.getData())) && (vo = (UserVO)((List)res.getData()).get(0)) != null && com.baomidou.mybatisplus.core.toolkit.StringUtils.isNotEmpty((CharSequence)vo.getSourceId())) {
            return vo.getSourceId();
        }
        return null;
    }

    @Override
    public CheckVO queryDetailWeigh(CheckVO vo) {
        CheckVO checkVO = new CheckVO();
        checkVO = null != vo.getDeliveryId() ? this.deliveryToCheck(vo.getDeliveryId()) : this.orderToCheck(vo.getOrderId());
        this.logger.info("----\u78c5\u5355\u9a8c\u6536\u539f\u6570\u636e \uff1a{}", (Object)JSONObject.toJSONString((Object)checkVO));
        List checkDetailList = checkVO.getDetailList();
        List checkWeighList = vo.getCheckWeighList();
        ArrayList<CheckWeighVO> checkWeighVOS = new ArrayList<CheckWeighVO>();
        if (CollectionUtils.isNotEmpty((Collection)checkWeighList)) {
            List collect = checkWeighList.stream().filter(item -> null != item.getId()).map(item -> item.getId()).collect(Collectors.toList());
            CommonResponse listCommonResponse = this.weighbillApi.queryWeighbills(checkVO.getProjectId(), collect);
            if (!listCommonResponse.isSuccess()) {
                throw new BusinessException("\u67e5\u8be2\u78c5\u5355\u5931\u8d25\uff01\u9519\u8bef\u4fe1\u606f\uff1a" + listCommonResponse.getMsg());
            }
            List data = (List)listCommonResponse.getData();
            if (CollectionUtils.isNotEmpty((Collection)data)) {
                for (WeighbillVO weighbillVO : data) {
                    CheckWeighVO checkWeighVO = (CheckWeighVO)BeanMapper.map((Object)weighbillVO, CheckWeighVO.class);
                    if (null == vo.getDeliveryId()) {
                        checkWeighVO.setOrderId(checkWeighVO.getDeliveryId());
                        checkWeighVO.setOrderDetailId(checkWeighVO.getDeliveryDetailId());
                        checkWeighVO.setDeliveryId(null);
                        checkWeighVO.setDeliveryDetailId(null);
                    }
                    BigDecimal netWeight = weighbillVO.getNetWeight();
                    BigDecimal coefficient = weighbillVO.getCoefficient();
                    String weightUnit = weighbillVO.getWeightUnit();
                    Map<String, BigDecimal> checkNumMap = this.getCheckNum(weightUnit, netWeight, coefficient);
                    checkWeighVO.setCheckNum(checkNumMap.get("checkNum"));
                    checkWeighVO.setDetailNetWeightCoefficient(checkNumMap.get("detailNetWeightCoefficient"));
                    checkWeighVO.setWeightId(weighbillVO.getId());
                    checkWeighVO.setCheckId(null);
                    checkWeighVO.setId(null);
                    checkWeighVO.setWeighMemo(weighbillVO.getMemo());
                    checkWeighVO.setRowState("add");
                    checkWeighVOS.add(checkWeighVO);
                }
                Map<Object, Object> weighMap = new HashMap();
                weighMap = null != vo.getDeliveryId() ? checkWeighVOS.stream().filter(t -> null != t.getDeliveryDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getDeliveryDetailId)) : checkWeighVOS.stream().filter(t -> null != t.getOrderDetailId()).collect(Collectors.groupingBy(CheckWeighVO::getOrderDetailId));
                if (CollectionUtils.isNotEmpty((Collection)checkDetailList)) {
                    for (CheckDetailVO checkDetailVO : checkDetailList) {
                        List checkWeighS = new ArrayList();
                        checkWeighS = null != vo.getDeliveryId() ? (List)weighMap.get(checkDetailVO.getDeliveryDetailId()) : (List)weighMap.get(checkDetailVO.getOrderDetailId());
                        if (null != checkWeighS && CollectionUtils.isNotEmpty(checkWeighS)) {
                            BigDecimal checkNum = checkWeighS.stream().map(CheckWeighVO::getCheckNum).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal detailNetWeightCoefficient = checkWeighS.stream().map(CheckWeighVO::getDetailNetWeightCoefficient).reduce(BigDecimal.ZERO, BigDecimal::add);
                            BigDecimal netWeight = checkWeighS.stream().map(CheckWeighVO::getNetWeight).reduce(BigDecimal.ZERO, BigDecimal::add);
                            checkDetailVO.setDetailNetWeight(netWeight);
                            checkDetailVO.setDetailNetWeightCoefficient(detailNetWeightCoefficient);
                            checkDetailVO.setDetailCoefficient(ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)checkNum));
                            checkDetailVO.setCheckNumsSum(checkNum);
                            continue;
                        }
                        checkDetailVO.setDetailNetWeightCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setDetailNetWeight(BigDecimal.ZERO);
                        checkDetailVO.setDetailCoefficient(BigDecimal.ZERO);
                        checkDetailVO.setCheckNumsSum(BigDecimal.ZERO);
                    }
                }
            }
        }
        checkVO.setCheckWeighType(CheckWeighTypeEnum.\u662f\u78c5\u5355\u9a8c\u6536.getCode());
        checkVO.setDetailList(checkDetailList);
        checkVO.setCheckWeighList(checkWeighVOS);
        return checkVO;
    }

    public Map<String, BigDecimal> getCheckNum(String weighUnit, BigDecimal netWeight, BigDecimal coefficient) {
        BigDecimal checkNum = BigDecimal.ZERO;
        BigDecimal detailNetWeightCoefficient = BigDecimal.ZERO;
        HashMap<String, BigDecimal> map = new HashMap<String, BigDecimal>();
        if (null == coefficient) {
            coefficient = BigDecimal.ZERO;
        }
        if (null == netWeight) {
            netWeight = BigDecimal.ZERO;
        }
        Integer billStateCode = 0;
        if (StringUtils.isNotEmpty((String)weighUnit)) {
            billStateCode = WeighUnitEnum.getEnumByStateCode((String)weighUnit).getBillStateCode();
        }
        switch (billStateCode) {
            case 0: {
                detailNetWeightCoefficient = netWeight;
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
                break;
            }
            case 1: {
                detailNetWeightCoefficient = ComputeUtil.safeMultiply((BigDecimal)netWeight, (BigDecimal)new BigDecimal("1000"));
                checkNum = ComputeUtil.safeDiv((BigDecimal)detailNetWeightCoefficient, (BigDecimal)coefficient);
            }
        }
        map.put("checkNum", checkNum);
        map.put("detailNetWeightCoefficient", detailNetWeightCoefficient);
        return map;
    }
}

