/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.ejianc.business.wzxt.bean.PlanDetailEntity;
import com.ejianc.business.wzxt.bean.PlanEntity;
import com.ejianc.business.wzxt.mapper.PlanMapper;
import com.ejianc.business.wzxt.service.IPlanService;
import com.ejianc.business.wzxt.vo.PlanDetailRefVO;
import com.ejianc.business.wzxt.vo.PlanDetailVO;
import com.ejianc.business.wzxt.vo.PlanVO;
import com.ejianc.business.wzxt.vo.PmDetailVO;
import com.ejianc.business.wzxt.vo.PmTreeVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service(value="planService")
public class PlanServiceImpl
extends BaseServiceImpl<PlanMapper, PlanEntity>
implements IPlanService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String SDBJ_CACHE_KEY_PREFIX = "SDBJ::";
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${sdbj.serverUrl}")
    private String SDBJ_SERVER_URL;
    @Value(value="${sdbj.appid}")
    private String APPID;
    @Value(value="${sdbj.accessTokenUrl}")
    private String ACCESS_TOKEN_URL;
    @Value(value="${sdbj.materialrequirefullplandetaillistUrl}")
    private String PM_SUBJECT_LIST_URL;
    @Value(value="${sdbj.pmSubjectListUrl}")
    private String PM_BW_LIST_URL;
    private static final String WZXT_PLAN_BILL_CODE = "WZXT_PLAN";
    private static final String WZXT_PLAN_NAME = "WZXT_PLAN_NAME";
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IPlanService planService;

    @Override
    public CommonResponse<PlanVO> saveOrUpdate(PlanVO planVO) {
        PlanEntity entity;
        Long tenantId = InvocationInfoProxy.getTenantid();
        if (StringUtils.isEmpty((CharSequence)planVO.getBillCode())) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_BILL_CODE, tenantId);
            if (billCode.isSuccess()) {
                planVO.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if (StringUtils.isEmpty((CharSequence)planVO.getPlanName())) {
            CommonResponse planName = this.billCodeApi.getCodeBatchByRuleCode(WZXT_PLAN_NAME, tenantId);
            if (planName.isSuccess()) {
                planVO.setPlanName((String)planName.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c\u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        if ((entity = (PlanEntity)((Object)BeanMapper.map((Object)planVO, PlanEntity.class))).getMaterialVerification().booleanValue() && StringUtils.isNotEmpty((CharSequence)entity.getConstructionId())) {
            List<PlanDetailEntity> planDetail;
            StringBuffer msg = new StringBuffer();
            ArrayList listPmtree = new ArrayList();
            HashMap params = new HashMap(10);
            params.put("prjid", entity.getProjectSourceId());
            CommonResponse<JSONObject> bwres = null;
            try {
                bwres = this.sendGetReq(this.PM_BW_LIST_URL, params);
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new BusinessException("\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u9879\u76ee\u5de5\u7a0b\u90e8\u4f4d\u53c2\u7167\u5931\u8d25");
            }
            if (bwres.isSuccess()) {
                JSONObject result = (JSONObject)bwres.getData();
                JSONArray list = result.getJSONObject("data").getJSONArray("list");
                if (list != null) {
                    list.forEach(l -> {
                        String jsonString = JSON.toJSONString((Object)l);
                        PmTreeVO j = (PmTreeVO)JSON.parseObject((String)jsonString, PmTreeVO.class);
                        listPmtree.add(j);
                    });
                }
            } else {
                throw new BusinessException(bwres.getMsg());
            }
            HashMap param = new HashMap();
            HashMap<String, Object> data = new HashMap<String, Object>();
            List pks = entity.getPlanDetail().stream().map(PlanDetailEntity::getMaterialSourceId).collect(Collectors.toList());
            data.put("projectid", entity.getProjectSourceId());
            data.put("materialidlist", pks);
            param.put("data", data);
            CommonResponse<JSONObject> response = null;
            try {
                response = this.sendPostReq(this.PM_SUBJECT_LIST_URL, JSON.toJSONString(param));
                if (!response.isSuccess()) {
                    return CommonResponse.error((String)("\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u6750\u6599\u9700\u6c42\u603b\u9884\u7b97\u63a5\u53e3\u5931\u8d25\uff0c" + response.getMsg()));
                }
            }
            catch (Exception e3) {
                e3.printStackTrace();
                return CommonResponse.error((String)"\u67e5\u8be2\u6c34\u7535\u516b\u5c40\u6750\u6599\u9700\u6c42\u603b\u9884\u7b97\u63a5\u53e3\u5931\u8d25");
            }
            HashMap mapPm = new HashMap();
            JSONObject result = (JSONObject)response.getData();
            JSONArray list = result.getJSONArray("list");
            if (list != null) {
                list.forEach(l -> {
                    String jsonString = JSON.toJSONString((Object)l);
                    PmDetailVO j = (PmDetailVO)JSON.parseObject((String)jsonString, PmDetailVO.class);
                    if (mapPm.containsKey(j.getMaterialId())) {
                        ((Map)mapPm.get(j.getMaterialId())).put(j.getPartsID(), j.getJhl());
                    } else {
                        HashMap<String, BigDecimal> mapBw = new HashMap<String, BigDecimal>();
                        mapBw.put(j.getPartsID(), j.getJhl());
                        mapPm.put(j.getMaterialId(), mapBw);
                    }
                });
            }
            HashMap mapSum = new HashMap();
            List<PlanDetailVO> listDetials = ((PlanMapper)this.baseMapper).queryDetails(entity.getProjectId());
            if (CollectionUtils.isNotEmpty(listDetials)) {
                listDetials.forEach(j -> {
                    if (mapSum.containsKey(j.getMaterialSourceId())) {
                        ((Map)mapSum.get(j.getMaterialSourceId())).put(j.getConstructionId(), j.getNums());
                    } else {
                        HashMap<String, BigDecimal> mapBw = new HashMap<String, BigDecimal>();
                        mapBw.put(j.getConstructionId(), j.getNums());
                        mapSum.put(j.getMaterialSourceId(), mapBw);
                    }
                });
            }
            if (CollectionUtils.isNotEmpty(planDetail = entity.getPlanDetail())) {
                planDetail.forEach(e -> {
                    ArrayList<PmTreeVO> listPm = new ArrayList<PmTreeVO>();
                    listPm.addAll(listPmtree);
                    listPm.forEach(p -> {
                        if (mapPm.containsKey(e.getMaterialSourceId()) && ((Map)mapPm.get(e.getMaterialSourceId())).containsKey(p.getId())) {
                            BigDecimal jhl = ((Map)mapPm.get(e.getMaterialSourceId())).get(p.getId()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)mapPm.get(e.getMaterialSourceId())).get(p.getId());
                            p.setJhl(jhl);
                        }
                        if (mapSum.containsKey(e.getMaterialSourceId()) && ((Map)mapSum.get(e.getMaterialSourceId())).containsKey(p.getId())) {
                            BigDecimal sum = ((Map)mapSum.get(e.getMaterialSourceId())).get(p.getId()) == null ? BigDecimal.ZERO : (BigDecimal)((Map)mapSum.get(e.getMaterialSourceId())).get(p.getId());
                            p.setPlanNum(sum);
                        }
                    });
                    ArrayList<PmTreeVO> listres = new ArrayList<PmTreeVO>();
                    this.calculateValue(listPm, listres);
                    boolean flag = this.cheeckNum(listres, entity.getConstructionId(), e.getPlanNum() == null ? BigDecimal.ZERO : e.getPlanNum());
                    if (flag && StringUtils.isEmpty((CharSequence)e.getMemo())) {
                        msg.append("\u3010" + e.getMaterialName() + "\u3011");
                    }
                });
            }
            if (StringUtils.isNotEmpty((CharSequence)msg)) {
                return CommonResponse.error((String)("\u60a8\u6240\u5f55\u5165\u7684\u7269\u8d44\u540d\u79f0\u4e3a" + msg.toString() + "\u9700\u6c42\u6570\u91cf\u5df2\u8d85\u51fa\u6613\u5efaPM\u7cfb\u7edf\u8ba1\u5212\u91cf,\u9700\u586b\u5199\u5907\u6ce8\u540e\u53ef\u4fdd\u5b58"));
            }
        }
        List<PlanDetailEntity> planDetail = entity.getPlanDetail();
        String materialName = "";
        if (planDetail != null && planDetail.size() > 0) {
            for (PlanDetailEntity applyDetailEntity : planDetail) {
                materialName = materialName + applyDetailEntity.getMaterialName() + ",";
                if (applyDetailEntity.getNums() == null) continue;
                BigDecimal nums = applyDetailEntity.getNums() == null ? BigDecimal.ZERO : applyDetailEntity.getNums();
                BigDecimal occupyNums = applyDetailEntity.getOccupyNums() == null ? BigDecimal.ZERO : applyDetailEntity.getOccupyNums();
                BigDecimal surplusNums = nums.subtract(occupyNums);
                applyDetailEntity.setSurplusNums(surplusNums);
                applyDetailEntity.setOccupyNums(occupyNums);
                applyDetailEntity.setNums(nums);
            }
            String substring = materialName.substring(0, materialName.length() - 1);
            entity.setMaterialName(substring);
        }
        this.planService.saveOrUpdate((Object)entity, false);
        PlanVO vo = (PlanVO)BeanMapper.map((Object)((Object)entity), PlanVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    public List<PmTreeVO> getBottomNode(List<PmTreeVO> listPmTreeVO) {
        HashMap<String, PmTreeVO> map = new HashMap<String, PmTreeVO>();
        for (PmTreeVO g : listPmTreeVO) {
            map.put(g.getId(), g);
        }
        for (PmTreeVO g : listPmTreeVO) {
            String pid = g.getParentid();
            if (!map.containsKey(pid)) continue;
            map.remove(pid);
        }
        return new ArrayList<PmTreeVO>(map.values());
    }

    public List<PmTreeVO> setParentValue(List<PmTreeVO> listAllPmTreeVO, List<PmTreeVO> listBottomPmTreeVO) {
        HashMap<String, ArrayList<PmTreeVO>> map = new HashMap<String, ArrayList<PmTreeVO>>();
        for (PmTreeVO g : listBottomPmTreeVO) {
            String pid = g.getParentid();
            ArrayList<PmTreeVO> listPmTreeVO = (ArrayList<PmTreeVO>)map.get(pid);
            if (listPmTreeVO == null) {
                listPmTreeVO = new ArrayList<PmTreeVO>();
            }
            listPmTreeVO.add(g);
            map.put(pid, listPmTreeVO);
        }
        for (String i : map.keySet()) {
            List tempListPmTreeVO = (List)map.get(i);
            BigDecimal jhl = BigDecimal.ZERO;
            BigDecimal ljnum = BigDecimal.ZERO;
            for (PmTreeVO g : tempListPmTreeVO) {
                jhl = jhl.add(g.getJhl() == null ? BigDecimal.ZERO : g.getJhl());
                ljnum = ljnum.add(g.getPlanNum() == null ? BigDecimal.ZERO : g.getPlanNum());
            }
            for (PmTreeVO g : listAllPmTreeVO) {
                String id = g.getId();
                if (!id.equals(i)) continue;
                g.setJhl(jhl);
                BigDecimal plannum = g.getPlanNum() == null ? BigDecimal.ZERO : g.getPlanNum();
                g.setPlanNum(plannum.add(ljnum));
            }
        }
        for (PmTreeVO g : listBottomPmTreeVO) {
            listAllPmTreeVO.remove(g);
        }
        return listAllPmTreeVO;
    }

    public PmTreeVO calculateValue(List<PmTreeVO> listPmTreeVO, List<PmTreeVO> listRes) {
        if (listPmTreeVO.size() == 1) {
            listRes.add(listPmTreeVO.get(0));
            return listPmTreeVO.get(0);
        }
        List<PmTreeVO> listBottomPmTreeVO = this.getBottomNode(listPmTreeVO);
        List<PmTreeVO> list = this.setParentValue(listPmTreeVO, listBottomPmTreeVO);
        listRes.addAll(listBottomPmTreeVO);
        return this.calculateValue(list, listRes);
    }

    public boolean cheeckNum(List<PmTreeVO> listPmTreeVO, String constructionId, BigDecimal plnum) {
        for (PmTreeVO g : listPmTreeVO) {
            BigDecimal planNum;
            if (!StringUtils.isNotEmpty((CharSequence)constructionId) || !constructionId.equals(g.getId())) continue;
            BigDecimal jhl = g.getJhl() == null ? BigDecimal.ZERO : g.getJhl();
            BigDecimal bigDecimal = planNum = g.getPlanNum() == null ? BigDecimal.ZERO : g.getPlanNum();
            if (plnum.compareTo(jhl.subtract(planNum)) < 0) {
                return this.cheeckNum(listPmTreeVO, g.getParentid(), plnum);
            }
            return true;
        }
        return false;
    }

    @Override
    public List<PlanDetailRefVO> getPlanByMaterialId(List<Long> materialListId, QueryWrapper queryWrapper) {
        List<PlanDetailRefVO> planVOList = ((PlanMapper)this.baseMapper).getPlanByMaterialId(materialListId, queryWrapper);
        return planVOList;
    }

    private CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = this.SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.get((String)newUrl, params, headers, (int)10000, (int)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, JSON.toJSONString(params), headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    private CommonResponse<JSONObject> sendPostReq(String url, String paramJson) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = this.SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.postByJson((String)newUrl, (String)paramJson, headers, (Integer)10000, (Integer)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, paramJson, headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData.getJSONObject("data"));
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String key = "SDBJ::ACCESS_TOKEN";
        String reqUrl = this.SDBJ_SERVER_URL + this.ACCESS_TOKEN_URL;
        String tokenInfo = (String)((Object)this.cacheManager.get(key));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject((String)tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get((Object)"invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if (invalidateTime > curTime) {
                return tokenData;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("appId", this.APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader((String)reqUrl, params);
            this.logger.info("\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u670d\u52a1-[\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(params), reqRespStr});
            JSONObject reqResp = JSONObject.parseObject((String)reqRespStr);
            if (BooleanUtils.isNotTrue((Boolean)((Boolean)reqResp.get((Object)"success")))) {
                this.logger.error(null != reqResp.get((Object)"message") ? reqResp.get((Object)"message").toString() : "\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bf7\u6c42Token\u5931\u8d25\uff01");
                return null;
            }
            Map tokenData = (Map)reqResp.get((Object)"data");
            JSONObject invalidateInfo = (JSONObject)tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get((Object)"time").toString());
            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", (Object)invalidateTime);
            this.cacheManager.setex(key, (Serializable)((Object)JSONObject.toJSONString((Object)resp)), 3000);
            return resp;
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u5f02\u5e38, ", (Throwable)e);
            return null;
        }
    }
}

