package com.ejianc.business.wzxt.util;

import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.CamelAndUnderLineConverter;
import org.apache.commons.lang3.StringUtils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.*;

/**
 * @author yqls
 * @date 2024-11-14 19:10:57
 */
public class ParamUtil {

    public final static String columns = "*";

    /** 基础字段查询*/
    public static <T> String paramToString(Map<String, Parameter> params){
        StringBuilder builder = new StringBuilder();
        builder.append("dr = 0");
        for(Map.Entry<String, Parameter> entry: params.entrySet()){
            Parameter param = entry.getValue();
            String type = param.getType();
            String key = CamelAndUnderLineConverter.humpToLine(entry.getKey());

            switch(type) {
                case QueryParam.EQ:
                    if(null == param.getValue()) {
                        builder.append(" and " + key + " is null");
                    } else {
                        builder.append(" and " + key + " = '" + param.getValue() + "'");
                    }
                    break;
                case QueryParam.NE:
                    if(null == param.getValue()) {
                        builder.append(" and " + key + " is not null");
                    } else {
                        builder.append(" and " + key + " <> '" + param.getValue() + "'");
                    }
                    break;
                case QueryParam.SQL:
                    /** 严禁前端直接传入 仅用于后端使用 ！！！ */
                    if(param.getValue()!=null) {
                        builder.append(param.getValue().toString());
                    }
                    break;
                case QueryParam.IN:
                    if(param.getValue() instanceof List) {
                        builder.append(" and " + key + " in ('" + StringUtils.join((List<?>)param.getValue(), "', '") + "')");
                    }else if(param.getValue() instanceof String) {
                        String[] paramArr = param.getValue().toString().split(",");
                        builder.append(" and " + key + " in ('" + StringUtils.join(paramArr, "', '") + "')");
                    }
                    break;
                case QueryParam.NOT_IN:
                    if(param.getValue() instanceof List) {
                        builder.append(" and " + key + " not in ('" + StringUtils.join((List<?>)param.getValue(), "', '") + "')");
                    }else if(param.getValue() instanceof String) {
                        String[] paramArr = param.getValue().toString().split(",");
                        builder.append(" and " + key + " not in ('" + StringUtils.join(paramArr, "', '") + "')");
                    }
                    break;
                case QueryParam.LIKE:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " like '%" + param.getValue() + "%'");
                    }
                    break;
                case QueryParam.NOT_LIKE:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " not like '%" + param.getValue() + "%'");
                    }
                    break;
                case QueryParam.LIKE_LEFT:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " like '%" + param.getValue() + "'");
                    }
                    break;
                case QueryParam.LIKE_RIGHT:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " like '" + param.getValue() + "%'");
                    }
                    break;
                case QueryParam.BETWEEN:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        String[] paramArr = param.getValue().toString().split(",");
                        if("dateInSelect".equals(param.getInputType()) && paramArr[0].length() == 7){
                            /** 日期区间 月份区间 */
                            if(paramArr[0].equals(paramArr[1])){
                                /** 月份相同，就是一个月 */
                                builder.append(" and " + key + " = '" + paramArr[0] + "'");
                            } else {
                                builder.append(" and " + key + " in ('" + StringUtils.join(getMonthRange(paramArr[0], paramArr[1]), "', '") + "')");
                            }
                        } else {
                            builder.append(" and " + key + " between '" + paramArr[0] + "' and '" + paramArr[1] + "'");
                        }
                    }
                    break;
                case QueryParam.LT:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " < '" + param.getValue() + "'");
                    }
                    break;
                case QueryParam.LE:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " <= '" + param.getValue() + "'");
                    }
                    break;
                case QueryParam.GT:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " > '" + param.getValue() + "'");
                    }
                    break;
                case QueryParam.GE:
                    if(param.getValue() != null && StringUtils.isNotBlank(param.getValue().toString())) {
                        builder.append(" and " + key + " >= '" + param.getValue() + "'");
                    }
                    break;
            }
        }
        return builder.toString();
    }

    public static List<String> getMonthRange(String startDateStr, String endDateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM");
        Date startDate = null;
        Date endDate = null;
        try {
            startDate = sdf.parse(startDateStr);
            endDate = sdf.parse(endDateStr);
        } catch (ParseException e) {
            e.printStackTrace();
        }
        List<String> monthList = new ArrayList<>();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (!calendar.getTime().after(endDate)) {
            int year = calendar.get(Calendar.YEAR);
            int month = calendar.get(Calendar.MONTH) + 1;
            String monthStr = String.format("%04d-%02d", year, month);
            monthList.add(monthStr);
            calendar.add(Calendar.MONTH, 1);
        }
        return monthList;
    }
}
