package com.ejianc.business.wzxt.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.utils.MathUtil;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.CheckDetailsVO;
import com.ejianc.business.wzxt.vo.PickingOutStoreDetailVO;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.business.wzxt.mapper.PickingOutStoreDetailMapper;
import com.ejianc.business.wzxt.bean.PickingOutStoreDetailEntity;
import com.ejianc.business.wzxt.service.IPickingOutStoreDetailService;

import java.util.List;
import java.util.stream.Stream;

/**
 * 领料出库（子）
 * 
 * @author generator
 * 
 */
@Service("pickingOutStoreDetailService")
public class PickingOutStoreDetailServiceImpl extends BaseServiceImpl<PickingOutStoreDetailMapper, PickingOutStoreDetailEntity> implements IPickingOutStoreDetailService{

    @Autowired
    private PickingOutStoreDetailMapper detailMapper;

    @Override
    public IPage<CheckDetailVO> queryNumPageData(String searchText, Integer pageNumber, Integer pageSize) {
        IPage<CheckDetailVO> page = new Page<>();
        page.setCurrent(pageNumber);
        page.setSize(pageSize);
        List<CheckDetailVO> records = detailMapper.queryNumPageData(searchText,page);
        for (CheckDetailVO record : records) {
            record.setStockNumber(MathUtil.safeSub(record.getCheckNumber(),record.getOutStoreNumbers()));
        }
        page.setRecords(records);
        return page;
    }
}
