/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.PickingOutStoreEntity;
import com.ejianc.business.wzxt.service.IPickingOutStoreDetailService;
import com.ejianc.business.wzxt.service.IPickingOutStoreService;
import com.ejianc.business.wzxt.vo.CheckDetailVO;
import com.ejianc.business.wzxt.vo.PickingOutStoreExportVO;
import com.ejianc.business.wzxt.vo.PickingOutStoreVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.time.DateFormatUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.skeleton.template.BaseVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pickingOutStore"})
public class PickingOutStoreController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "PICKING-OUTSTORE";
    @Autowired
    private IPickingOutStoreService service;
    @Autowired
    private IPickingOutStoreDetailService detailService;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<PickingOutStoreVO> saveOrUpdate(@RequestBody PickingOutStoreVO saveorUpdateVO) {
        PickingOutStoreEntity entity = (PickingOutStoreEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, PickingOutStoreEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            CommonResponse billCode = this.billCodeApi.getCodeBatchByRuleCode(BILL_CODE, InvocationInfoProxy.getTenantid());
            if (billCode.isSuccess()) {
                entity.setBillCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        this.service.saveOrUpdate((Object)entity, false);
        PickingOutStoreVO vo = (PickingOutStoreVO)BeanMapper.map((Object)((Object)entity), PickingOutStoreVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<PickingOutStoreVO> queryDetail(Long id) {
        PickingOutStoreEntity entity = (PickingOutStoreEntity)((Object)this.service.selectById(id));
        PickingOutStoreVO vo = (PickingOutStoreVO)BeanMapper.map((Object)((Object)entity), PickingOutStoreVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PickingOutStoreVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<PickingOutStoreVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("pickingUnitName");
        fuzzyFields.add("pickingName");
        fuzzyFields.add("creatorName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useFor");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), PickingOutStoreVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialNames");
        fuzzyFields.add("orgName");
        fuzzyFields.add("pickingUnitName");
        fuzzyFields.add("pickingName");
        fuzzyFields.add("creatorName");
        fuzzyFields.add("projectName");
        fuzzyFields.add("useFor");
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        ArrayList exportVOS = new ArrayList();
        list.forEach(val -> {
            PickingOutStoreExportVO exportVO = (PickingOutStoreExportVO)BeanMapper.map((Object)val, PickingOutStoreExportVO.class);
            exportVO.setOutDate(DateFormatUtil.formatDate((String)"yyyy-MM-dd", (Date)val.getOutDate()));
            exportVO.setCreatorTime(DateFormatUtil.formatDate((String)"yyyy-MM-dd HH:mm:ss", (Date)val.getCreatorTime()));
            switch (val.getBillState()) {
                case 0: {
                    exportVO.setBillState("\u81ea\u7531\u6001");
                    break;
                }
                case 1: {
                    exportVO.setBillState("\u5df2\u63d0\u4ea4");
                    break;
                }
                case 2: {
                    exportVO.setBillState("\u5ba1\u6279\u4e2d");
                    break;
                }
                case 3: {
                    exportVO.setBillState("\u5ba1\u6279\u901a\u8fc7");
                    break;
                }
                case 4: {
                    exportVO.setBillState("\u5ba1\u6279\u9a73\u56de");
                    break;
                }
                case 5: {
                    exportVO.setBillState("\u5ba1\u6279\u4e2d");
                }
            }
            exportVOS.add(exportVO);
        });
        HashMap beans = new HashMap();
        beans.put("records", exportVOS);
        ExcelExport.getInstance().export("pickingOutStoreExport.xlsx", beans, response);
    }

    @RequestMapping(value={"/refPickingOutStoreData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<CheckDetailVO>> refPickingOutStoreData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("materialName");
        fuzzyFields.add("materialSpec");
        IPage<CheckDetailVO> entityPage = this.detailService.queryNumPageData(searchText, pageNumber, pageSize);
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", entityPage);
    }
}

