/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.HttpTookit;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ThirdSystemUtil {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String SDBJ_CACHE_KEY_PREFIX = "SDBJ::";
    @Autowired
    private CacheManager cacheManager;
    @Value(value="${sdbj.serverUrl}")
    private String SDBJ_SERVER_URL;
    @Value(value="${sdbj.appid}")
    private String APPID;
    @Value(value="${sdbj.accessTokenUrl}")
    private String ACCESS_TOKEN_URL;

    public CommonResponse<JSONObject> sendGetReq(String url, Map<String, Object> params) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = this.SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.get((String)newUrl, params, headers, (int)10000, (int)20000);
        this.logger.info("\u53d1\u9001get\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, JSON.toJSONString(params), headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData);
    }

    public CommonResponse<JSONObject> sendPostReq(String url, String paramJson) throws Exception {
        HashMap<String, String> headers = new HashMap<String, String>(5);
        JSONObject resp = new JSONObject();
        JSONObject accessToken = this.getSDBJAccessToken();
        if (null == accessToken) {
            throw new BusinessException("\u83b7\u53d6\u670d\u52a1accessToken\u5931\u8d25\uff01");
        }
        headers.put("access_token", accessToken.get((Object)"token").toString());
        String newUrl = this.SDBJ_SERVER_URL + url;
        String reqResp = HttpTookit.postByJson((String)newUrl, (String)paramJson, headers, (Integer)10000, (Integer)20000);
        this.logger.info("\u53d1\u9001post\u8bf7\u6c42\u3010\u5730\u5740\uff1a {}, \u53c2\u6570\uff1a{}, header: {}\u3011, \u54cd\u5e94\u7ed3\u679c\uff1a{}", new Object[]{newUrl, paramJson, headers, reqResp});
        JSONObject jsonData = JSONObject.parseObject((String)reqResp);
        if (BooleanUtils.isNotTrue((Boolean)jsonData.getBoolean("success"))) {
            return CommonResponse.error((String)(null != jsonData.get((Object)"message") ? jsonData.get((Object)"message").toString() : "\u67e5\u8be2\u5931\u8d25\uff01"));
        }
        return CommonResponse.success((Object)jsonData.getJSONObject("data"));
    }

    public JSONObject getSDBJAccessToken() {
        JSONObject resp = new JSONObject();
        String key = "SDBJ::ACCESS_TOKEN";
        String reqUrl = this.SDBJ_SERVER_URL + this.ACCESS_TOKEN_URL;
        String tokenInfo = (String)((Object)this.cacheManager.get(key));
        if (StringUtils.isNotBlank((CharSequence)tokenInfo)) {
            JSONObject tokenData = JSONObject.parseObject((String)tokenInfo);
            Long invalidateTime = Long.valueOf(tokenData.get((Object)"invalidateTime").toString());
            Long curTime = System.currentTimeMillis();
            if (invalidateTime > curTime) {
                return tokenData;
            }
        }
        HashMap<String, String> params = new HashMap<String, String>(2);
        params.put("appId", this.APPID);
        try {
            String reqRespStr = HttpTookit.getAndHeader((String)reqUrl, params);
            this.logger.info("\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u670d\u52a1-[\u5730\u5740\uff1a{}, \u53c2\u6570\uff1a{}]\uff0c\u8fd4\u56de\u7ed3\u679c\uff1a{}", new Object[]{reqUrl, JSONObject.toJSONString(params), reqRespStr});
            JSONObject reqResp = JSONObject.parseObject((String)reqRespStr);
            if (BooleanUtils.isNotTrue((Boolean)((Boolean)reqResp.get((Object)"success")))) {
                this.logger.error(null != reqResp.get((Object)"message") ? reqResp.get((Object)"message").toString() : "\u83b7\u53d6\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bf7\u6c42Token\u5931\u8d25\uff01");
                return null;
            }
            Map tokenData = (Map)reqResp.get((Object)"data");
            JSONObject invalidateInfo = (JSONObject)tokenData.get("invalidate");
            Long invalidateTime = Long.valueOf(invalidateInfo.get((Object)"time").toString());
            resp.put("token", tokenData.get("access_token"));
            resp.put("invalidateTime", (Object)invalidateTime);
            this.cacheManager.setex(key, (Serializable)((Object)JSONObject.toJSONString((Object)resp)), 3000);
            return resp;
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u6c34\u7535\u516b\u5c40\u670d\u52a1\u8bbf\u95eeToken\u5f02\u5e38, ", (Throwable)e);
            return null;
        }
    }
}

