/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.wzxt.controller.api;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.wzxt.bean.OrderDetailEntity;
import com.ejianc.business.wzxt.bean.OrderEntity;
import com.ejianc.business.wzxt.service.IOrderDetailService;
import com.ejianc.business.wzxt.service.IOrderService;
import com.ejianc.business.wzxt.vo.OrderDetailVO;
import com.ejianc.business.wzxt.vo.OrderProjectVO;
import com.ejianc.business.wzxt.vo.OrderVO;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/order/"})
public class OrderApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IOrderService orderService;
    @Autowired
    private IOrderDetailService orderDetailService;

    @RequestMapping(value={"/queryOrderProjects"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OrderProjectVO>> queryOrderProjects(@RequestParam(defaultValue="1") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize, @RequestParam(value="condition", required=false) String condition, @RequestParam(value="searchText", required=false) String searchText) {
        Map conditionMap;
        QueryParam queryParam = new QueryParam();
        queryParam.setPageIndex(pageNumber.intValue());
        queryParam.setPageSize(pageSize.intValue());
        queryParam.setSearchText(searchText);
        List fuzzyFields = queryParam.getFuzzyFields();
        fuzzyFields.add("orgName");
        fuzzyFields.add("projectName");
        Long supplierId = null;
        if (StringUtils.isNotBlank((CharSequence)condition) && null != (conditionMap = (Map)JSONObject.parseObject((String)condition, Map.class)).get("supplierId")) {
            supplierId = Long.valueOf(conditionMap.get("supplierId").toString());
            this.logger.info("\u53c2\u6570supplierId--" + supplierId);
        }
        Page page = new Page((long)queryParam.getPageIndex(), (long)queryParam.getPageSize());
        QueryWrapper wrapper = BaseServiceImpl.changeToQueryWrapper((QueryParam)queryParam);
        List<OrderProjectVO> listres = this.orderService.queryOrderProjects((Page<OrderProjectVO>)page, wrapper, supplierId);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(listres);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @ApiOperation(value="\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u8ba2\u5355\u8be6\u60c5")
    @RequestMapping(value={"/queryOrderByDetailId"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OrderVO> queryOrderByDetailId(@RequestParam(value="detailId") Long detailId) {
        this.logger.info("\u7269\u8d44\u660e\u7ec6id\uff0c\u67e5\u8be2\u53c2\u6570\uff1a{}", (Object)detailId);
        OrderVO resVo = new OrderVO();
        OrderDetailEntity orderDetailEntity = (OrderDetailEntity)((Object)this.orderDetailService.getById(detailId));
        if (null != orderDetailEntity) {
            OrderEntity orderEntity = (OrderEntity)((Object)this.orderService.getById(orderDetailEntity.getOrderId()));
            resVo = (OrderVO)BeanMapper.map((Object)((Object)orderEntity), OrderVO.class);
            OrderDetailVO orderDetailVO = (OrderDetailVO)BeanMapper.map((Object)((Object)orderDetailEntity), OrderDetailVO.class);
            ArrayList<OrderDetailVO> list = new ArrayList<OrderDetailVO>();
            list.add(orderDetailVO);
            resVo.setPurchaseOrderDetail(list);
        }
        this.logger.info("\u6839\u636e\u7269\u8d44\u660e\u7ec6id \u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\uff0c\u67e5\u8be2\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString((Object)resVo));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f", (Object)resVo);
    }
}

