package com.ejianc.business.wzxt.test;


import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Maps;
import groovy.util.logging.Slf4j;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.util.HashMap;
import java.util.Map;

/**
 * <p>
 * 测试
 * </p>
 *
 * @author yqls
 * @since 2020-08-17
 */
@Slf4j
public class Test {

    private final Logger log = LoggerFactory.getLogger(getClass());

    private final static String urlPath = "https://qlh.baju.com.cn";
//    private final static String urlPath = "https://dev.17elian.com";

    /** 模拟本地缓存 */
    private static final Map<String, Object> localCache = Maps.newConcurrentMap();

    public static void main(String[] args) {
        Map<String, String> headers = new HashMap<>();
        try {
            /** 获取access_token服务 */
            Test test = new Test();
            test.getAccessToken(headers);

            /** 验收单参照查询服务 */
            test.queryCheckRef(headers);

            /** 修改验收单引用状态服务 */
            test.updateUseState(headers);

            /** 回写验收单入库数量服务 */
//            new Test().updateInstoreNum(headers);

            /** 进度累计完成比例查询服务 */
            test.queryMonthComplete(headers);

            /** 总延误工期查询服务 */
            test.queryDiffValueByProjectId(headers);
        } catch (Exception e) {
            //执行失败
            System.out.println(e);
        }
    }

    /**
     * 获取access_token服务
     *
     * @param headers
     * @throws GeneralSecurityException
     * @throws IOException
     */
    private void getAccessToken(Map<String, String> headers) throws GeneralSecurityException, IOException {
        //获取redis中的access_token，若不存在，则重新请求并放入redis中
        if(localCache.get("access_token") != null){
            //若存在，直接放到header中
            headers.put("access_token", localCache.get("access_token").toString());
        }else{
            String initContextUrl = urlPath + "/ejc-idm-web/auth/getAccessToken?appId=49ba97d3d32d092a&secret=fa68b9585dc90e24973b4f7e663757eede2b7cf7";
            String responseStr = HttpTookit.get(initContextUrl, null);
//                System.out.println(responseStr);
            JSONObject json = JSONObject.parseObject(responseStr);
            JSONObject data = json.getJSONObject("data");
            if(Boolean.parseBoolean(data.get("querysucflag").toString())){
                String access_token = data.get("access_token").toString();
                headers.put("access_token", access_token);
                //将获取到的access_token放入redis中（可依据自己的redis工具类写,注意：设置的过期时间要小于等于50分钟）
                localCache.put("access_token", access_token);
                log.info("------------  获取access_token服务，请求成功！data = " + data + "  ------------");
            }else{
                //请求失败，输出错误信息
                System.out.println(data.getJSONObject("errormsg"));
            }
        }
    }

    /**
     * 验收单参照查询服务
     *
     * @param headers
     * @throws Exception
     */
    private void queryCheckRef(Map<String, String> headers) throws Exception {
        String url = urlPath + "/ejc-wzxt-web/openapi/check/queryCheckRef";
        Map<String, String> params = new HashMap();
        params.put("projectSourceId", "8abc9fe567ed4a7a0167ed6e05ea084f");
		params.put("contractId", "8abc677375cfaae60175e334a55f0451");
//		params.put("checkDate", "2020-10-19");
		params.put("checkType", "1");
        String back = HttpTookit.get(url, params, headers);
        JSONObject jsonBack = JSONObject.parseObject(back);
        if("0".equals(jsonBack.getString("code"))){
            //调用同步方法成功
            log.info("------------  验收单参照查询服务，请求成功！data = " + jsonBack.getString("data") + "  ------------");
        }else{
            //调用同步方法失败，输出错误信息
            System.out.println(jsonBack.getString("msg"));
        }
    }

    /**
     * 修改验收单引用状态服务
     *
     * @param headers
     * @throws Exception
     */
    private void updateUseState(Map<String, String> headers) throws Exception {
        String url = urlPath + "/ejc-wzxt-web/openapi/check/updateUseState";
        JSONArray params = new JSONArray();
        JSONObject param1 = new JSONObject();
        param1.put("checkId", "384761488264409130");
//        param1.put("checkId", "374596590277754946");
        param1.put("useState", "1");
        params.add(param1);
        log.info("-->> updateUseState：" + params.toJSONString());
        String back = HttpTookit.postByJson(url, params.toJSONString(), headers);
        JSONObject jsonBack = JSONObject.parseObject(back);
        if("0".equals(jsonBack.getString("code"))){
            //调用同步方法成功
            log.info("------------  修改验收单引用状态服务，请求成功！data = " + jsonBack.getString("data") + "  ------------");
        }else{
            //调用同步方法失败，输出错误信息
            System.out.println(jsonBack.getString("msg"));
        }
    }

    /**
     * 回写验收单入库数量服务
     *
     * @param headers
     * @throws Exception
     */
    private void updateInstoreNum(Map<String, String> headers) throws Exception {
        String url = urlPath + "/ejc-wzxt-web/openapi/check/updateInstoreNum";
        JSONArray params = new JSONArray();
        JSONObject param1 = new JSONObject();
        param1.put("checkId", "371239026576064570");
        param1.put("instoreId", "xd3trete33452sdt325");

        JSONArray dparams = new JSONArray();
        JSONObject dparam1 = new JSONObject();
        dparam1.put("checkDetailId", "371240933730287635");
        dparam1.put("instoreId", "xd3trete33452sdt325");
        dparam1.put("instoreDetailId", "e5r3trf75s2sdt34g");
        dparam1.put("instoreNum", 1);
        dparams.add(dparam1);
        param1.put("detailList", dparams);

        params.add(param1);
        String back = HttpTookit.postByJson(url, params.toJSONString(), headers);
        JSONObject jsonBack = JSONObject.parseObject(back);
        if("0".equals(jsonBack.getString("code"))){
            //调用同步方法成功
            log.info("------------  回写验收单入库数量服务，请求成功！data = " + jsonBack.getString("data") + "  ------------");
        }else{
            //调用同步方法失败，输出错误信息
            System.out.println(jsonBack.getString("msg"));
        }
    }

    /**
     * 进度累计完成比例查询服务
     *
     * @param headers
     * @throws Exception
     */
    private void queryMonthComplete(Map<String, String> headers) throws Exception {
        String url = urlPath + "/sdbj-progress-web/openapi/monthLight/queryMonthComplete";
        Map<String, String> params = new HashMap();
        params.put("projectSourceId", "8abc66736f096c9c016f0d8875171144");
//        params.put("startMonth", "2023-11");
//        params.put("endMonth", "2023-11");
        String back = HttpTookit.get(url, params, headers);
        JSONObject jsonBack = JSONObject.parseObject(back);
        if("0".equals(jsonBack.getString("code"))){
            //调用同步方法成功
            log.info("------------  进度累计完成比例查询服务，请求成功！data = " + jsonBack.getString("data") + "  ------------");
        }else{
            //调用同步方法失败，输出错误信息
            System.out.println(jsonBack.getString("msg"));
        }
    }

    /**
     * 总延误工期查询服务
     *
     * @param headers
     * @throws Exception
     */
    private void queryDiffValueByProjectId(Map<String, String> headers) throws Exception {
        String url = urlPath + "/sdbj-progress-web/openapi/monthLight/queryDiffValueByProjectId";
        Map<String, String> params = new HashMap();
        params.put("projectSourceId", "8abc66736f096c9c016f0d8875171144");
        String back = HttpTookit.get(url, params, headers);
        JSONObject jsonBack = JSONObject.parseObject(back);
        if("0".equals(jsonBack.getString("code"))){
            //调用同步方法成功
            log.info("------------  总延误工期查询服务，请求成功！data = " + jsonBack.getString("data") + "  ------------");
        }else{
            //调用同步方法失败，输出错误信息
            System.out.println(jsonBack.getString("msg"));
        }
    }

}
