package com.ejianc.business.xmgs.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;

import com.ejianc.business.xmgs.vo.WorkTimeDetailVO;
import com.ejianc.business.xmgs.vo.ProjectVO;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 工时管理
 *
 * @author generator
 *
 */
public class WorkTimeVO extends BaseVO {
    private static final long serialVersionUID = 1L;

    private String createUserName; // 创建人名称
    private String billCode; // 单据编码
    private Long fillId; // 填报人主键
    private String fillName; // 填报人名称
    private BigDecimal totalWorkTime; // 工时合计
    private String memo; // 备注
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date date; // 日期
    private Integer billState; // 审批状态
    private Long orgId; // 组织主键
    private String orgName; // 组织名称
    private String orgCode; // 组织编码
    private Long phone; // 手机号

    private List<WorkTimeDetailVO> workTimeDetailList = new ArrayList<>(); // 工时管理明细
    private List<ProjectVO> projectList = new ArrayList<>(); // 工时项目

    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }
    @ReferSerialTransfer(referCode="idm-employee")
    public Long getFillId() {
        return fillId;
    }
    @ReferDeserialTransfer
    public void setFillId(Long fillId) {
        this.fillId = fillId;
    }
    public String getFillName() {
        return fillName;
    }

    public void setFillName(String fillName) {
        this.fillName = fillName;
    }
    public BigDecimal getTotalWorkTime() {
        return totalWorkTime;
    }

    public void setTotalWorkTime(BigDecimal totalWorkTime) {
        this.totalWorkTime = totalWorkTime;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }
    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }
    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public Long getPhone() {
        return phone;
    }

    public void setPhone(Long phone) {
        this.phone = phone;
    }

     public List<WorkTimeDetailVO> getWorkTimeDetailList() {
        return workTimeDetailList;
     }

     public void setWorkTimeDetailList(List<WorkTimeDetailVO> workTimeDetailList) {
        this.workTimeDetailList = workTimeDetailList;
     }
     public List<ProjectVO> getProjectList() {
        return projectList;
     }

     public void setProjectList(List<ProjectVO> projectList) {
        this.projectList = projectList;
     }
}
