/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.mq;

import com.ejianc.framework.mq.converter.FastJsonMessageConverter;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@ConfigurationProperties(prefix="zatop.rabbitmq")
public class RabbitZatopMqConfiguration {
    private String host;
    private int port;
    private String username;
    private String password;
    private String virtualHost;
    private int maxConcurrentConsumers = 50;
    private int concurrentConsumers = 20;

    @Bean(value={"connectionFactory"})
    public ConnectionFactory getConnectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(this.host, this.port);
        connectionFactory.setUsername(this.username);
        connectionFactory.setPassword(this.password);
        connectionFactory.setVirtualHost(this.virtualHost);
        connectionFactory.setPublisherConfirms(true);
        return connectionFactory;
    }

    @Bean(value={"jsonMessageConverter"})
    public FastJsonMessageConverter getFastJsonMessageConverter() {
        FastJsonMessageConverter fastJsonMessageConverter = new FastJsonMessageConverter();
        return fastJsonMessageConverter;
    }

    @Bean(value={"retryConnTemplate"})
    public RetryTemplate getRetryTemplate() {
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy exponentialBackOffPolicy = new ExponentialBackOffPolicy();
        exponentialBackOffPolicy.setInitialInterval(500L);
        exponentialBackOffPolicy.setMultiplier(10.0);
        exponentialBackOffPolicy.setMaxInterval(5000L);
        retryTemplate.setBackOffPolicy((BackOffPolicy)exponentialBackOffPolicy);
        return retryTemplate;
    }

    @Bean(value={"rabbitAdmin"})
    public RabbitAdmin getRabbitAdmin() {
        RabbitAdmin rabbitAdmin = new RabbitAdmin(this.getConnectionFactory());
        return rabbitAdmin;
    }

    @Bean(value={"rabbitTemplate"})
    public RabbitTemplate getRabbitTemplate() {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(this.getConnectionFactory());
        rabbitTemplate.setMessageConverter((MessageConverter)this.getFastJsonMessageConverter());
        rabbitTemplate.setConfirmCallback(new RabbitTemplate.ConfirmCallback(){

            public void confirm(CorrelationData correlationData, boolean ack, String cause) {
                if (!ack) {
                    throw new RuntimeException("send error " + cause);
                }
            }
        });
        return rabbitTemplate;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getMaxConcurrentConsumers() {
        return this.maxConcurrentConsumers;
    }

    public void setMaxConcurrentConsumers(int maxConcurrentConsumers) {
        this.maxConcurrentConsumers = maxConcurrentConsumers;
    }

    public int getConcurrentConsumers() {
        return this.concurrentConsumers;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }
}

