/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IFinishBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="finishBpmService")
public class FinishBpmServiceImpl
implements IFinishBpmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void finishBpm(Map<String, Object> params) {
        CommonResponse<String> afterApprovalResponse;
        CommonResponse<String> back;
        String billId = params.get("billId") != null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String userid = params.get("userid") != null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId") != null ? params.get("bpmId").toString() : null;
        String authority = this.initUserContextUtil.initUserContext(userid);
        this.request.setAttribute("authority", (Object)authority);
        BpmInfoEntity infoEntity = this.bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType("finish");
        this.bpmInfoService.saveOrUpdate((Object)infoEntity, false);
        this.logger.info("---------------\u5355\u636e\u7ec8\u5ba1\u56de\u8c03\u4e8b\u4ef6\u5f00\u59cb-------------------------");
        CommonResponse<String> approvalResponse = this.updateBillStateUtils.beforeApprovalProcessor(Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE);
        if (!approvalResponse.isSuccess()) {
            this.logger.error("\u5355\u636e\u7ec8\u5ba1\u56de\u8c03\u524d\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(approvalResponse.getMsg());
            String message = approvalResponse.getMsg() != null && approvalResponse.getMsg().length() > 1000 ? approvalResponse.getMsg().substring(0, 1000) : approvalResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approved-beforeApproval", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        this.logger.info("\u56de\u5199\u5355\u636e\u72b6\u6001\uff01===========\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a3\uff08\u5ba1\u6279\u901a\u8fc7\uff09");
        CommonResponse<String> resu = this.updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.PASSED_STATE);
        if (!resu.isSuccess() && !(back = this.updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.PASSED_STATE)).isSuccess()) {
            this.logger.info("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u56de\u5199\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a3\uff08\u5ba1\u6279\u901a\u8fc7\uff09\u5931\u8d25");
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approved-updateBillState", userid, JSONUtil.toJsonStr(params), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5931\u8d25");
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        if (!(afterApprovalResponse = this.updateBillStateUtils.afterApprovalProcessor(Long.parseLong(billId), billTypeCode, BillState.PASSED_STATE)).isSuccess()) {
            this.logger.error("\u5355\u636e\u7ec8\u5ba1\u56de\u8c03\u540e\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(afterApprovalResponse.getMsg());
            String message = afterApprovalResponse.getMsg() != null && afterApprovalResponse.getMsg().length() > 1000 ? afterApprovalResponse.getMsg().substring(0, 1000) : afterApprovalResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approved-afterApproval", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        this.logger.info("---------------\u5355\u636e\u7ec8\u5ba1\u56de\u8c03\u4e8b\u4ef6\u7ed3\u675f-------------------------");
    }
}

