package com.ejianc.zatopbpm.controller;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.IZatopbpmService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * 错误回调事件实体
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("zatopbpm")
public class ZatopbpmController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IErrorCallbackService service;
    @Autowired
    private IZatopbpmService zatopbpmService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description 提交
     */
    @RequestMapping(value = "/dosumit", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> dosumit(@RequestBody Map<String, Object> params) {
    	return zatopbpmService.dosumit(params);
    }

    /**
     * @Description 查询历史
     */
    @RequestMapping(value = "/getHistory", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<List<BpmInfoVO>> getHistory(Long billId) {
        return zatopbpmService.getHistory(billId);
    }

    /**
     * @Description bpm校验数据
     */
    @RequestMapping(value = "/checkData", method = RequestMethod.POST)
    @ResponseBody
    public JSONObject checkData(@RequestBody Map<String, Object> params) {
        JSONObject json = new JSONObject();
        json.put("status", "fresh");
        json.put("message", "string");
        return json;
    }
}
