package com.ejianc.zatopbpm.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.framework.mq.consumer.BaseConsumer;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

/**
 * 消息中心基础消息拉取监听类
 */
@Component
public class MessageCommonListener extends BaseConsumer {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IStartBpmService startBpmService;

    @Autowired
    private IBpmInfoService bpmInfoService;

    @Autowired
    private IAbandonBpmService abandonBpmService;

    @Autowired
    private IApproveBpmService approveBpmService;

    @Autowired
    private IFinishBpmService finishBpmService;

    @Autowired
    private IStopBpmService stopBpmService;
    @Autowired
    private IErrorCallbackService errorCallbackService;

    @Value("${zatopbpm.queue:ejc-test.instance.action.type}")
    private String zatopHost;

    @Override
    protected void doConsumeMsg(MqMessage mqMessage) {
        try {
            String body = JSON.toJSONString(mqMessage.getBody());
            logger.info("mq收到的消费信息:{}",body);
            JSONObject data = JSONObject.parseObject(body);
            String type = data.getString("type");
            String billTypeCode = data.getString("btid");
            String billId = data.getString("boid");
            String bpmId = data.getString("instanceid");
            String userid = data.getString("userid");
            String bpmdata = data.getString("data");
            Map<String, Object> param = new HashMap<>();
            /***************返回数据说明************************
            actionid string 是 消息的唯一标识
            type string 是 操作类型； 枚举： createResult：流程发起状态; audit：流程审批状态; approveClose：流程结束状态
            bsid string 是 业务系统标识
            例如：SAP，MySoft
            btid string 是 业务类型/业务对象
            boid string 是 业务对象 GUID，唯一标识
            instanceid string 是 流程示例 ID
            userid string 是 发起人账号
            message string 否 BPM 提供的信息反馈
            data object 是 具体的操作数据
                createResultData object 否 流程发起状态数据
                    status string 是 发起状态 枚举： success：成功; failed：失败
                    url string 是 BPM 流程查看 URL
                auditData object 否 流程审批状态数据
                    action string 是 审批动作 枚举： approve：审批同意; rejectStart：退回发起人、发起人自己撤回; rejectStep：小打回，退回到之前步骤，不是到发起人; recall：发起人发起页面取消发起
                    stepName string 是 审批的步骤名称
                    stepApproverId string 是 审批的用户 id
                    stepComment string 是 审批意见
                    stepOperateTime string 是 审批时间
                approveCloseData object 否 流程结束状态数据
                    status String 是 流程状态 枚举：rejected：审批不通过; approved：审批通过; canceled：管理员作废、申请人撤销
                    time string 是 流程结束时间
                businessObject object 否 见 3.1.4.3
                approvalHistoryData object 否 流程审批记录数据
                    ActivityID String 是 步骤 ID
                    StepName string 是 步骤名称
                    Operator string 是 审批人账号
                    OperatorName string 是 审批人名称
                    OperateDate string 是 审批时间
                    Decision string 是 审批动作
                    Comment string 是 审批意见
                    Duration string 是 停留时间
                */
            if("createResult".equals(type)){
                JSONObject createResult = JSONObject.parseObject(bpmdata);
                JSONObject createResultData = JSONObject.parseObject(createResult.getString("createResultData"));
                String status = createResultData.getString("status");
                String url = createResultData.getString("url");
                if("success".equals(status)){
                    //流程发起
                    param.put("type", type);
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", userid);
                    param.put("zatopUrl", url);
                    startBpmService.startBpm(param);
                }else{
                    ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "submit-startzatopbpm", userid, null, "流程发起失败！");
                    errorCallbackService.saveOrUpdate(entity, false);
                }
            }else if("audit".equals(type)){
                //流程审批状态
//                action string 是 审批动作 枚举： approve：审批同意; rejectStart：退回发起人、发起人自己撤回; rejectStep：小打回，退回到之前步骤，不是到发起人; recall：发起人发起页面取消发起
                JSONObject audit = JSONObject.parseObject(bpmdata);
                JSONObject auditData = JSONObject.parseObject(audit.getString("auditData"));
                String action = auditData.getString("action");
                String stepName = auditData.getString("stepName");
                String stepApproverId = auditData.getString("stepApproverId");
                if("rejectStart".equals(action) || "recall".equals(action)){
                    //单据退回到发起人，自由态
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("type", "stop");
                    param.put("userid", stepApproverId);
                    stopBpmService.stopBpm(param);
                }else if("approve".equals(action)){
                    //审批同意
                    param.put("stepName", stepName);
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", stepApproverId);
                    approveBpmService.approveBpm(param);
                }else if("rejectStep".equals(action)){
                    //小打回，退回到之前步骤，不是到发起人
                }

            }else if("approveClose".equals(type)){
                //流程结束状态
                JSONObject approveClose = JSONObject.parseObject(bpmdata);
                JSONObject approveCloseData = JSONObject.parseObject(approveClose.getString("approveCloseData"));
                String status = approveCloseData.getString("status");
                JSONArray approvalHistoryData = JSONArray.parseArray(approveClose.getString("approvalHistoryData"));
                JSONObject historyData = (JSONObject) approvalHistoryData.get(approvalHistoryData.size()-1);
                String operator = historyData.getString("Operator");
                if("rejected".equals(status)){
                    //审批不通过
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("type", "rejected");
                    param.put("userid", operator);
                    stopBpmService.stopBpm(param);
                }else if("approve".equals(status)){
                    //审批通过
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", operator);
                    finishBpmService.finishBpm(param);
                }else if("rejectStep".equals(status)){
                    //管理员作废、申请人撤销
                    //需要判断该流程是终止还是弃审
                    BpmInfoEntity infoEntity = bpmInfoService.selectByBpmId(bpmId);
                    if("approving".equals(infoEntity.getType())){
                        param.put("billTypeCode", billTypeCode);
                        param.put("billId", billId);
                        param.put("bpmId", bpmId);
                        param.put("userid", operator);
                        param.put("type", "rejected");
                        stopBpmService.stopBpm(param);
                    }else if("finish".equals(infoEntity.getType())){
                        param.put("billTypeCode", billTypeCode);
                        param.put("billId", billId);
                        param.put("bpmId", bpmId);
                        param.put("userid", operator);
                        abandonBpmService.abandonBpm(param);
                    }
                }
            }
        } catch (Exception e) {
            logger.error("监听消息异常: ", e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{zatopHost};
    }
}
