package com.ejianc.zatopbpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IZatopbpmService;
import com.ejianc.zatopbpm.utils.EncryptUtil;
import com.ejianc.zatopbpm.utils.GetBillDataUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.zatopbpm.utils.MD5Util;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("zatopbpmService")
public class ZatopbpmServiceImpl implements IZatopbpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Value("${zatop.host.businessData:http://bpmtest.zatop.cn:8084}")
    private String zatopHostBusinessData;

    @Value("${zatop.host.startPage:http://bpmtest.zatop.cn:8080}")
    private String zatopHostStartPage;

    @Value("${zatop.signatureKey:366FB2D161CAE1BE920D5788BEAAFFE9}")
    private String signatureKey;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private GetBillDataUtil getBillDataUtil;
    @Autowired
    private SessionManager sessionManager;

    @Override
    public CommonResponse<String> dosumit(Map<String, Object> params) {
        Long billId = params.get("billId")!=null ? Long.parseLong(params.get("billId").toString()) : null;
        String fileSourceType = params.get("fileSourceType")!=null ? params.get("fileSourceType").toString() : null;
        String billTypeCode = params.get("billTypeCode")!=null ? params.get("billTypeCode").toString() : null;
        String pcurl = params.get("pcurl")!=null ? params.get("pcurl").toString() : null;
        String maurl = params.get("maurl")!=null ? params.get("maurl").toString() : null;
        Long orgId = params.get("orgId")!=null ? Long.parseLong(params.get("orgId").toString()) : null;
        JSONObject billData = getBillDataUtil.getBillData(billId, billTypeCode, fileSourceType );

        try {
            String bsid = "ejc";
            String userid = InvocationInfoProxy.getUsercode();
            String signature = EncryptUtil.aesEncrypt((bsid+"|"+userid+"|"+new Date().getTime()), signatureKey);
            String btid = billTypeCode;
            String boid = billId.toString();

            String orgcode = sessionManager.getUserContext().getOrgCode();
            CommonResponse<List<OrgVO>> orgResponse = orgApi.findParentsByOrgId(orgId);
            if(orgResponse.isSuccess() && orgResponse.getData()!=null && orgResponse.getData().size()>0){
                for(OrgVO orgVO : orgResponse.getData()){
                    if(orgVO.getOrgType()!=5 && StringUtils.isNotBlank(orgVO.getSourceId())){
                        orgcode = orgVO.getSourceId();
                        break;
                    }
                }
            }

            logger.info("发送单据信息给bpm：---------------"+billData.toJSONString());
            String paramterStr = gson.toJson(billData);
            String url = zatopHostBusinessData + "/apiCenter/businessData?bsid="+bsid+"&btid="+btid+"&boid="+boid+"&userid="+userid+"&orgcode="+orgcode+"&signature="+signature;
            logger.info("发送单据信息给bpm的url：---------------"+url);
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            logger.info("发送单据信息给bpm返回的结果：---------------"+result);
            JSONObject jsonObject = JSONObject.parseObject(result);
            if(jsonObject.get("status")!=null && !"success".equals(jsonObject.get("status").toString())){
                throw new BusinessException("单据推送失败！");
            }
            //获取这个单据的流程信息，若是存在，则根据状态判断是否是结束状态若是则新增一个
            QueryWrapper<BpmInfoEntity> wrapperBillId = new QueryWrapper<>();
            wrapperBillId.eq("dr", 0);
            wrapperBillId.eq("bill_type_code", billTypeCode);
            wrapperBillId.eq("bill_id", billId);
            wrapperBillId.orderByDesc("create_time");
            List<BpmInfoEntity> data = bpmInfoService.list(wrapperBillId);
            BpmInfoEntity entity = new BpmInfoEntity();
            if(data!=null && data.size()>0){
                if(StringUtils.isNotBlank(data.get(0).getType()) || "stop".equals(data.get(0).getType())){
                    entity = data.get(0);
                }
            }
            entity.setBillId(billId);
            entity.setBillTypeCode(billTypeCode);
            entity.setPcurl(pcurl);
            entity.setMaurl(maurl);
            entity.setOrgId(orgId);
            entity.setOrgSourceId(orgcode);
            entity.setUserid(userid);
            bpmInfoService.saveOrUpdate(entity, false);
            String startUrl = zatopHostStartPage+"/Workflow/MTStart2.aspx?BSID="+bsid+"&BTID="+btid+"&BOID="+boid+"&UserID="+userid+"&signature="+signature;
            return CommonResponse.success("推送数据成功",startUrl);
        } catch (Exception e) {
            e.printStackTrace();
        }
        return CommonResponse.error("启动流程失败");
    }

    @Override
    public CommonResponse<List<BpmInfoVO>> getHistory(Long billId) {
        List<BpmInfoVO> vos = new ArrayList<>();
        QueryWrapper<BpmInfoEntity> wrapperBillId = new QueryWrapper<>();
        wrapperBillId.eq("dr", 0);
        wrapperBillId.eq("bill_id", billId);
        wrapperBillId.orderByDesc("create_time");
        List<BpmInfoEntity> data = bpmInfoService.list(wrapperBillId);
        if(vos!=null && vos.size()>0){
            for (BpmInfoEntity entity : data){
                BpmInfoVO vo = BeanMapper.map(entity, BpmInfoVO.class);
                vo.setZatopUrl(vo.getZatopUrl()+"&lalunakey="+ MD5Util.getMD5((vo.getBpmId()+InvocationInfoProxy.getUsercode())));
                vos.add(vo);
            }
            vos = BeanMapper.mapList(data, BpmInfoVO.class);
        }
        return CommonResponse.success(vos);
    }
}
