package com.ejianc.zatopbpm.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

@SuppressWarnings("unchecked")
@Component
public class GetBillDataUtil {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Value("${zatop.businessObjectUrl:https://auth.zatop.cn/oauth/authorize?client_id=web&redirect_uri=https%3A%2F%2Fpm.zatop.cn%2Fportal%2Fno_auth%2Fzatop%2FssoLogin&scope=server&response_type=code&state=}")
    private String businessObjectUrl;

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private SessionManager sessionManager;

    public JSONObject getBillData(Long billId, String billTypeCode, String sourceType) {
        String billTypeName = "";
        CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
        if(billTypeResponse.isSuccess()) {
            BillTypeVO billTypeVo = billTypeResponse.getData();
            billTypeName = billTypeVo.getBillName();
        }
        String url = businessObjectUrl+billId;
        //获取单据信息
        JSONObject businessObject = new JSONObject();
        businessObject.put("businessObjectId", billTypeCode);//业务对象 ID
        businessObject.put("businessObjectName", billTypeName);//业务对象名称
        businessObject.put("businessObjectUrl", url);//业务系统提供的业务单据查看 URL
        businessObject.put("businessObjectModifyUrl", url);//业务系统提供的业务单据修改 URL
        businessObject.put("businessObjectVersion", String.valueOf(IdWorker.getId()));//业务数据版本，业务系统可传业务数据 hash

        JSONObject billData = this.queryBillDetail(billId, billTypeCode, sourceType);

        logger.info("查询单据详情返回的结果：---------------"+billData.toJSONString());
        JSONObject data = JSONObject.parseObject(billData.get("data").toString());

        JSONArray fields = (JSONArray) data.get("fields");
        JSONObject field = new JSONObject();
        field.put("id", "TITLE");
        field.put("name", "流程主题");
        field.put("value", sessionManager.getUserContext().getUserName() + "提交的" + billTypeName);
        fields.add(field);
        businessObject.put("fields", fields);//主表字段集合（流程主题字段为TITLE）
        businessObject.put("lists", data.get("lists"));//明细表集合
        businessObject.put("attachments", data.get("attachments"));//附件集合

        businessObject.put("relatedProcess", null);//相关流程集合

        JSONObject result = new JSONObject();
        result.put("businessObject", businessObject);
        return result;
    }

    /**
     * 根据单据主键ID和单据类型， 查询单据详情
     *
     * @param businessKey  单据主键ID
     * @param billTypeCode 单据类型ID
     * @return
     */
    public JSONObject queryBillDetail(Long businessKey, String billTypeCode, String sourceType) {
        logger.info("查询单据详情api开始参数：------businessKey："+businessKey+"billType:"+billTypeCode);

        JSONObject referVo = this.getMdByTypeCode(billTypeCode);
        if(referVo==null||referVo.get("tableName")==null){
            logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
            throw new BusinessException("网络异常， 查询元数据失败");
        }
        Map<String, String> paramterMap = new HashMap<>();
        paramterMap.put("billId", String.valueOf(businessKey));
        paramterMap.put("databaseName", referVo.get("databaseName").toString());
        paramterMap.put("tableName", referVo.get("tableName").toString());
        paramterMap.put("metadataId", referVo.get("metadataId").toString());
        paramterMap.put("sourceType", sourceType);
        paramterMap.put("billTypeCode", billTypeCode);

        logger.info("查询单据详情传递的参数：---------------"+paramterMap.toString());
        String paramterStr = gson.toJson(paramterMap);
        String url = environmentTools.getBaseHost() + referVo.get("projectName") + "/commonZatop/queryZatopBillDetail";
        logger.info("查询单据详情传递的url：---------------"+url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return JSONObject.parseObject(result);
        } catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("-------根据billType："+billTypeCode+"查询单据信息失败:");
        throw new BusinessException("网络异常， 单据信息查询失败");
    }

    public JSONObject getMdByTypeCode(String billTypeCode) {
        JSONObject json = new JSONObject();
        String key = "btd-md-"+billTypeCode;
        if(cacheManager.get(key)!=null){
            json = cacheManager.get(key);
        }else{
            CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
            if(billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = billTypeResponse.getData();
                logger.info("调用元数据api参数：---------------"+billTypeVo.getMetadataId());
                if(billTypeVo.getMetadataId()!=null){
                    CommonResponse<MdReferVO> referResponse = mdApi.queryMetadataById(billTypeVo.getMetadataId());
                    if(referResponse.isSuccess()) {
                        MdReferVO vo = referResponse.getData();
                        json.put("metadataId", billTypeVo.getMetadataId());
                        json.put("billTypeCode", billTypeVo.getBillCode());
                        json.put("databaseName", vo.getDatabaseName());
                        json.put("projectName", vo.getProjectName());
                        json.put("tableName", vo.getTableName());
                        cacheManager.setex(key, json, 3000);
                    }else{
                        logger.info("调用查询元数据服务异常：---------------"+referResponse.getMsg());
                    }
                }
            }
        }
        return json;
    }

}
