/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.mq.consumer;

import com.alibaba.fastjson.JSON;
import com.ejianc.framework.mq.common.MqMessage;
import com.ejianc.zatopbpm.mq.RabbitZatopMqConfiguration;
import com.rabbitmq.client.Channel;
import javax.annotation.Resource;
import org.apache.commons.lang.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageListener;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.rabbit.listener.SimpleMessageListenerContainer;
import org.springframework.amqp.rabbit.listener.api.ChannelAwareMessageListener;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public abstract class BaseConsumer
implements InitializingBean,
ChannelAwareMessageListener,
DisposableBean {
    protected static Logger logger = LoggerFactory.getLogger(BaseConsumer.class);
    @Resource(name="rabbitAdmin")
    private RabbitAdmin rabbitAdmin;
    @Resource(name="rabbitTemplate")
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private RabbitZatopMqConfiguration mqConfig;
    private SimpleMessageListenerContainer listenerContainer;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public void afterPropertiesSet() {
        Object[] queueNames = this.getQueueNames();
        if (ArrayUtils.isEmpty((Object[])queueNames)) {
            logger.warn("\u6d88\u606f\u961f\u5217\u4e3a\u7a7a");
            return;
        }
        this.listenerContainer = new SimpleMessageListenerContainer();
        this.listenerContainer.setConnectionFactory(this.rabbitTemplate.getConnectionFactory());
        Queue[] queues = new Queue[queueNames.length];
        for (Object queueName : queueNames) {
            Queue queue = new Queue((String)queueName, true, false, false);
            this.rabbitAdmin.declareQueue(queue);
            queues[i] = queue;
        }
        this.listenerContainer.addQueues(queues);
        this.listenerContainer.setPrefetchCount(1);
        this.listenerContainer.setMaxConcurrentConsumers(this.mqConfig.getMaxConcurrentConsumers());
        this.listenerContainer.setConcurrentConsumers(this.mqConfig.getConcurrentConsumers());
        this.listenerContainer.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        this.listenerContainer.setMessageListener((MessageListener)this);
        this.listenerContainer.start();
    }

    public void destroy() {
        if (this.listenerContainer != null) {
            this.listenerContainer.stop();
        }
    }

    public void onMessage(Message message, Channel channel) throws Exception {
        String msg = new String(message.getBody(), DEFAULT_CHARSET);
        MessageProperties msgProps = message.getMessageProperties();
        try {
            MqMessage mqMessage = (MqMessage)JSON.parseObject((String)msg, MqMessage.class);
            if (mqMessage == null || mqMessage.getBody() == null) {
                logger.error("\u6d88\u606f\u4f53\u4e3a\u7a7a\uff0c\u820d\u5f03\uff01");
            } else {
                this.doConsumeMsg(mqMessage);
                logger.debug("\u6d88\u606f\u6d88\u8d39\u5b8c\u6210");
            }
            channel.basicAck(msgProps.getDeliveryTag(), false);
        }
        catch (Exception ex) {
            channel.basicAck(msgProps.getDeliveryTag(), true);
            logger.error("\u6d88\u606f\u6d88\u8d39\u5931\u8d25:", (Throwable)ex);
        }
    }

    protected abstract void doConsumeMsg(MqMessage var1);

    protected abstract String[] getQueueNames();
}

