/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IStartBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="startBpmService")
public class StartBpmServiceImpl
implements IStartBpmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void startBpm(Map<String, Object> params) {
        CommonResponse<String> afterSubmitResponse;
        BaseEntity entity;
        String billId = params.get("billId") != null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String zatopUrl = params.get("zatopUrl") != null ? params.get("zatopUrl").toString() : null;
        String bpmId = params.get("bpmId") != null ? params.get("bpmId").toString() : null;
        String type = params.get("type") != null ? params.get("type").toString() : null;
        String userid = params.get("userid") != null ? params.get("userid").toString() : null;
        String authority = this.initUserContextUtil.initUserContext(userid);
        this.request.setAttribute("authority", (Object)authority);
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"dr", (Object)0);
        wrapper.eq((Object)"bpm_id", (Object)bpmId);
        List list = this.bpmInfoService.list((Wrapper)wrapper);
        if (list != null && list.size() > 0) {
            BpmInfoEntity entity2 = (BpmInfoEntity)((Object)list.get(0));
            entity2.setZatopUrl(zatopUrl);
            entity2.setType(type);
            entity2.setBpmId(bpmId);
            entity2.setUserid(userid);
            this.bpmInfoService.saveOrUpdate((Object)entity2, false);
        } else {
            QueryWrapper wrapperBillId = new QueryWrapper();
            wrapperBillId.eq((Object)"dr", (Object)0);
            wrapperBillId.eq((Object)"bpm_id", null);
            wrapperBillId.eq((Object)"bill_type_code", (Object)billTypeCode);
            wrapperBillId.eq((Object)"bill_id", (Object)billId);
            wrapperBillId.orderByDesc((Object)"create_time");
            List data = this.bpmInfoService.list((Wrapper)wrapperBillId);
            if (data != null && data.size() > 0) {
                entity = (BpmInfoEntity)((Object)data.get(0));
                entity.setZatopUrl(zatopUrl);
                entity.setType(type);
                entity.setBpmId(bpmId);
                entity.setUserid(userid);
                this.bpmInfoService.saveOrUpdate(entity, false);
            }
        }
        this.logger.info("--------------\u63d0\u4ea4\u56de\u8c03\u4e8b\u4ef6\u5f00\u59cb-----------------");
        CommonResponse<String> brforeSubmitResponse = this.updateBillStateUtils.beforeSubmitProcessor(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!brforeSubmitResponse.isSuccess()) {
            this.logger.error("\u63d0\u4ea4\u524d\u56de\u8c03\u524d\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(brforeSubmitResponse.getMsg());
            String message = brforeSubmitResponse.getMsg() != null && brforeSubmitResponse.getMsg().length() > 1000 ? brforeSubmitResponse.getMsg().substring(0, 1000) : brforeSubmitResponse.getMsg();
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "submit-brforeSubmit", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate(entity, false);
        }
        this.logger.info("\u56de\u5199\u5355\u636e\u72b6\u6001\uff01===========\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a5\uff08\u6709\u5ba1\u6279\u7684\u63d0\u4ea4\u6001\uff09");
        CommonResponse<String> back = this.updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.APPROVING_UNEXAM_STATE);
        if (!back.isSuccess()) {
            this.logger.info("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u56de\u5199\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a5\uff08\u6709\u5ba1\u6279\u7684\u63d0\u4ea4\u6001\uff09\u5931\u8d25");
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "submit-updateBillState", userid, JSONUtil.toJsonStr(params), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5931\u8d25");
            this.errorCallbackService.saveOrUpdate(entity, false);
        }
        if (!(afterSubmitResponse = this.updateBillStateUtils.afterSubmitProcessor(Long.parseLong(billId), billTypeCode, BillState.APPROVING_UNEXAM_STATE)).isSuccess()) {
            this.logger.error("\u63d0\u4ea4\u540e\u56de\u8c03\u524d\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(afterSubmitResponse.getMsg());
            String message = afterSubmitResponse.getMsg() != null && afterSubmitResponse.getMsg().length() > 1000 ? afterSubmitResponse.getMsg().substring(0, 1000) : afterSubmitResponse.getMsg();
            ErrorCallbackEntity entity3 = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "submit-afterSubmit", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity3, false);
        }
        this.logger.info("--------------\u63d0\u4ea4\u56de\u8c03\u4e8b\u4ef6\u7ed3\u675f-----------------");
    }
}

