/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IStopBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="stopBpmService")
public class StopBpmServiceImpl
implements IStopBpmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void stopBpm(Map<String, Object> params) {
        CommonResponse<String> afterHasBpmBackResponse;
        ErrorCallbackEntity entity;
        String billId = params.get("billId") != null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String userid = params.get("userid") != null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId") != null ? params.get("bpmId").toString() : null;
        String type = params.get("type") != null ? params.get("type").toString() : null;
        String authority = this.initUserContextUtil.initUserContext(userid);
        this.request.setAttribute("authority", (Object)authority);
        BpmInfoEntity infoEntity = this.bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType(type);
        this.bpmInfoService.saveOrUpdate((Object)infoEntity, false);
        this.logger.info("-----------------\u7ec8\u6b62\u56de\u8c03\u4e8b\u4ef6\u5f00\u59cb------------------");
        CommonResponse<String> beforeHasBpmBackResponse = this.updateBillStateUtils.beforeHasBpmBack(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!beforeHasBpmBackResponse.isSuccess()) {
            this.logger.error("\u7ec8\u6b62\u524d\u56de\u8c03\u524d\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(beforeHasBpmBackResponse.getMsg());
            String message = beforeHasBpmBackResponse.getMsg() != null && beforeHasBpmBackResponse.getMsg().length() > 1000 ? beforeHasBpmBackResponse.getMsg().substring(0, 1000) : beforeHasBpmBackResponse.getMsg();
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "stop-beforeHasBpmBack", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        this.logger.info("\u56de\u5199\u5355\u636e\u72b6\u6001\uff01===========\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a0\uff08\u81ea\u7531\u6001\uff09");
        CommonResponse<String> back = this.updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!back.isSuccess()) {
            this.logger.info("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u56de\u5199\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a0\uff08\u81ea\u7531\u6001\uff09\u5931\u8d25");
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "stop-updateBillState", userid, JSONUtil.toJsonStr(params), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5931\u8d25");
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        if (!(afterHasBpmBackResponse = this.updateBillStateUtils.afterHasBpmBack(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE)).isSuccess()) {
            this.logger.error("\u7ec8\u6b62\u540e\u4e8b\u4ef6\u56de\u8c03\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(afterHasBpmBackResponse.getMsg());
            String message = afterHasBpmBackResponse.getMsg() != null && afterHasBpmBackResponse.getMsg().length() > 1000 ? afterHasBpmBackResponse.getMsg().substring(0, 1000) : afterHasBpmBackResponse.getMsg();
            ErrorCallbackEntity entity2 = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "stop-afterHasBpmBack", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity2, false);
        }
        this.logger.info("-----------------\u7ec8\u6b62\u56de\u8c03\u4e8b\u4ef6\u7ed3\u675f------------------");
    }
}

