package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IApproveBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.ErrorTypeConfig;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("approveBpmService")
public class ApproveBpmServiceImpl implements IApproveBpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void approveBpm(Map<String, Object> params) {
        String billId = params.get("billId")!=null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode")!=null ? params.get("billTypeCode").toString() : null;
        String stepName = params.get("stepName")!=null ? params.get("stepName").toString() : null;
        String userid = params.get("userid")!=null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId")!=null ? params.get("bpmId").toString() : null;

        String authority = initUserContextUtil.initUserContext(userid);
        request.setAttribute("authority", authority);

        //修改流程状态
        BpmInfoEntity infoEntity = bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType("approving");
        bpmInfoService.saveOrUpdate(infoEntity,false);
        /*--------审批中事件start--------*/
        logger.info("-----------------------审批中回调事件开始-------------------------");
        CommonResponse<String> beforeInApprovalResponse = updateBillStateUtils.beforeInApprovalBack(
                Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE, stepName);
        if (!beforeInApprovalResponse.isSuccess()) {
            logger.error("单据审批中回调前事件报错， 请检查对应服务是否正常！");
            logger.error(beforeInApprovalResponse.getMsg());
            String message = beforeInApprovalResponse.getMsg()!=null&&beforeInApprovalResponse.getMsg().length()>1000? (beforeInApprovalResponse.getMsg().substring(0,1000)):beforeInApprovalResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.BEFOREINAPPROVAL, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        //回写单据状态
        logger.info("回写单据状态！===========" + "将单据id:" + billId + "的状态改为2（审批中）");
        CommonResponse<String> back = updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE);
        if(!back.isSuccess()){
            logger.info("！！！！！！！！回写单据状态失败！！！！！！！！！" + "将单据id:" + billId + "的状态改为2（审批中）失败");
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.APPROVING_UPDATEBILLSTATE, userid, JSONUtil.toJsonStr(params), "更新单据状态失败");
            errorCallbackService.saveOrUpdate(entity, false);
        }
        CommonResponse<String> afterInApprovalResponse = updateBillStateUtils.afterInApprovalBack(
                Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE, null, false, stepName,null);
        if (!afterInApprovalResponse.isSuccess()) {
            logger.error("审批节点审批中时节点审批后回调事件报错， 请检查对应服务是否正常！");
            logger.error(afterInApprovalResponse.getMsg());
            String message = afterInApprovalResponse.getMsg()!=null&&afterInApprovalResponse.getMsg().length()>1000? (afterInApprovalResponse.getMsg().substring(0,1000)):afterInApprovalResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.AFTERINAPPROVAL, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        logger.info("-----------------------审批中回调事件结束-------------------------");
    }
}
