package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IStopBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.ErrorTypeConfig;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("stopBpmService")
public class StopBpmServiceImpl implements IStopBpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void stopBpm(Map<String, Object> params) {
        String billId = params.get("billId")!=null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode")!=null ? params.get("billTypeCode").toString() : null;
        String userid = params.get("userid")!=null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId")!=null ? params.get("bpmId").toString() : null;
        String type = params.get("type")!=null ? params.get("type").toString() : null;

        String authority = initUserContextUtil.initUserContext(userid);
        request.setAttribute("authority", authority);

        //修改流程状态
        BpmInfoEntity infoEntity = bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType(type);
        bpmInfoService.saveOrUpdate(infoEntity,false);

        logger.info("-----------------终止回调事件开始------------------");
        CommonResponse<String> beforeHasBpmBackResponse = updateBillStateUtils.beforeHasBpmBack(
                Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if(!beforeHasBpmBackResponse.isSuccess()) {
            logger.error("终止前回调前事件报错， 请检查对应服务是否正常！");
            logger.error(beforeHasBpmBackResponse.getMsg());
            String message = beforeHasBpmBackResponse.getMsg()!=null&&beforeHasBpmBackResponse.getMsg().length()>1000? (beforeHasBpmBackResponse.getMsg().substring(0,1000)):beforeHasBpmBackResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.BEFOREHASBPMBACK, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        logger.info("回写单据状态！===========" + "将单据id:" + billId + "的状态改为0（自由态）");
        CommonResponse<String> back = updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if(!back.isSuccess()){
            logger.info("！！！！！！！！回写单据状态失败！！！！！！！！！" + "将单据id:" + billId + "的状态改为0（自由态）失败");
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.STOP_UPDATEBILLSTATE, userid, JSONUtil.toJsonStr(params), "更新单据状态失败");
            errorCallbackService.saveOrUpdate(entity, false);
        }
        CommonResponse<String> afterHasBpmBackResponse = updateBillStateUtils.afterHasBpmBack(
                Long.parseLong(billId), billTypeCode, BillState.UNCOMMITED_STATE);
        if (!afterHasBpmBackResponse.isSuccess()) {
            logger.error("终止后事件回调报错， 请检查对应服务是否正常！");
            logger.error(afterHasBpmBackResponse.getMsg());
            String message = afterHasBpmBackResponse.getMsg()!=null&&afterHasBpmBackResponse.getMsg().length()>1000? (afterHasBpmBackResponse.getMsg().substring(0,1000)):afterHasBpmBackResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.AFTERHASBPMBACK, userid, JSONUtil.toJsonStr(params), message);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        logger.info("-----------------终止回调事件结束------------------");
    }
}
