package com.ejianc.zatopbpm.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.HashMap;
import java.util.Map;

@SuppressWarnings("unchecked")
@Component
public class UpdateBillStateUtils {
	// 日志
	private final Logger logger = LoggerFactory.getLogger(getClass());
	
	private Gson gson = new Gson();
	
	@Autowired
	private IBillTypeApi billTypeApi;
	@Autowired
	private IMdApi mdApi;
	@Autowired
	private CacheManager cacheManager;
	@Autowired
	private EnvironmentTools environmentTools;

	/**
	 * 更新单据状态
	 *
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> updateBillState(Long billId, String billType, Integer billState) {
		logger.info("修改单据状态api开始参数：------billId："+billId+"billType:"+billType+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billType);
		if(referVo==null){
			logger.info("根据单据类型code："+billType+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 单据状态更改失败");
		}
		Map<String, String> paramterMap = new HashMap<>();
		paramterMap.put("billId", String.valueOf(billId));
		paramterMap.put("tableName", referVo.getTableName());
		paramterMap.put("billState", String.valueOf(billState));

		logger.info("修改单据状态传递的参数：---------------"+paramterMap.toString());
		String paramterStr = gson.toJson(paramterMap);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/commonstate/updateBillState";
		logger.info("修改单据状态传递的url：---------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			logger.info("修改单据状态返回的结果：---------------"+result);
			return gson.fromJson(result, CommonResponse.class);
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据单据code："+billType+"查询单据信息失败:");
		return CommonResponse.error("网络异常， 单据状态更改失败");
	}

	/**
	 * 提交前回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> beforeSubmitProcessor(Long billId, String billTypeCode, Integer billState) {
		logger.info("提交前回调api开始参数：------billId："+billId+"billType:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeSubmit";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 提交后回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> afterSubmitProcessor(Long billId, String billTypeCode, Integer billState) {
		logger.info("提交后回调api开始参数：------billId："+billId+"billType:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterSubmit";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 有审批流的撤回前回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> beforeHasBpmBack(Long billId, String billTypeCode, Integer billState) {
		logger.info("有审批流的撤回前回调api开始参数：------billId："+billId+"billTypeCode:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeHasBpmBack";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			logger.info("调用result-----------------------"+result);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
			logger.info("调用result错误信息--------------"+e.getMessage());
			logger.info("调用result错误信息--------------{e}",e);
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 有审批流的撤回后回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> afterHasBpmBack(Long billId, String billTypeCode, Integer billState) {
		logger.info("有审批流的撤回后回调api开始参数：------billId："+billId+"billTypeCode:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterHasBpmBack";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 审批节点审批中时节点审批前回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @param sign 
	 * @return
	 */
	public CommonResponse<String> beforeInApprovalBack(Long billId, String billTypeCode, Integer billState, String sign) {
		logger.info("审批节点审批中时节点审批前回调api开始参数：------billId："+billId+"billTypeCode:"+billTypeCode+"billState:"+billState+",sign:"+sign);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);
		paramterMap.put("sign", sign);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeInApprovalBack";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}

	/**
	 * 审批节点审批中时节点审批后回调
	 * 
	 * @param billId	//单据id
	 * @param billState		//单据状态
	 * @param billType		//单据类型code
	 * @param taskId		//该流程id
	 * @param isEnd		//该节点是否结束
	 * @return
	 */
	public CommonResponse<String> afterInApprovalBack(Long billId, String billTypeCode, Integer billState, String taskId, Boolean isEnd, String sign, Map<String,Object> other) {
		logger.info("审批节点审批中时节点审批后回调api开始参数：------billId："+billId+",billType:"+billTypeCode+",billState:"+billState+",taskId:"+taskId+",isEnd:"+isEnd+",sign:"+sign);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);
		paramterMap.put("taskId", taskId);
		paramterMap.put("isEnd", isEnd);
		paramterMap.put("sign", sign);
		paramterMap.put("other", other);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterInApprovalBack";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 终审前回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> beforeApprovalProcessor(Long billId, String billTypeCode, Integer billState) {
		logger.info("终审前回调api开始参数：------billId："+billId+"billType:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeApproval";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 终审后回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> afterApprovalProcessor(Long billId, String billTypeCode, Integer billState) {
		logger.info("终审后回调api开始参数：------billId："+billId+"billType:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterApproval";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 弃审前事件回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> beforeAbstainingProcessor(Long billId, String billTypeCode, Integer billState) {
		logger.info("弃审前事件回调api开始参数：------billId："+billId+"billTypeCode:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeAbstaining";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 单据信息查询失败");
	}
	
	/**
	 * 弃审后事件回调
	 * 
	 * @param billId
	 * @param billType
	 * @param billState
	 * @return
	 */
	public CommonResponse<String> afterAbstainingProcessor(Long billId, String billTypeCode, Integer billState) {
		logger.info("弃审后事件回调api开始参数：------billId："+billId+"billTypeCode:"+billTypeCode+"billState:"+billState);
		MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
		if(referVo==null){
			logger.info("根据单据类型code："+billTypeCode+"查询获取元数据失败:");
			return CommonResponse.error("网络异常， 弃审后事件回调失败");
		}
		Map<String, Object> paramterMap = new HashMap<>();
		paramterMap.put("billId", billId);
		paramterMap.put("billState", billState);
		paramterMap.put("metadataId", referVo.getMetadataId());
		paramterMap.put("billTypeCode", billTypeCode);

		String paramterStr = gson.toJson(paramterMap);
		logger.info("调用rest开始-----------------------");
		logger.info("调用rest参数-----------------------"+paramterStr);
		String url = environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterAbstaining";
		logger.info("调用restUrl-----------------------"+url);
		try {
			String result = ReferHttpClientUtils.postByJson(url, paramterStr);
			return gson.fromJson(result, new TypeToken<CommonResponse<String>>() {}.getType());
		} catch (Exception e) {
			e.printStackTrace();
		}
		logger.info("调用support工程api失败-------根据billTypeCode："+billTypeCode+"查询信息失败.");
		return CommonResponse.error("网络异常， 弃审后事件回调失败");
	}

	public MdReferVO getMdByTypeCode(String billTypeCode) {
		MdReferVO vo = new MdReferVO();
		String key = "btc-md-"+billTypeCode;
		if(cacheManager.get(key)!=null){
			vo = cacheManager.get(key);
		}else{
			CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
			if(billTypeResponse.isSuccess()) {
				BillTypeVO billTypeVo = billTypeResponse.getData();
				logger.info("调用元数据api参数：---------------"+billTypeVo.getMetadataId());
				if(billTypeVo.getMetadataId()!=null){
					CommonResponse<MdReferVO> referResponse = mdApi.queryMetadataById(billTypeVo.getMetadataId());
					if(referResponse.isSuccess()) {
						vo = referResponse.getData();
						cacheManager.setex(key, vo, 300);
					}else{
						logger.info("调用查询元数据服务异常：---------------"+referResponse.getMsg());
					}
				}
			}
		}
		return vo;
	}


}
