/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.google.gson.Gson;
import java.io.Serializable;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GetBillDataUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Value(value="${zatop.businessObjectUrl:https://auth.zatop.cn/oauth/authorize?client_id=web&redirect_uri=https%3A%2F%2Fpm.zatop.cn%2Fportal%2Fno_auth%2Fzatop%2FssoLogin&scope=server&response_type=code&state=}")
    private String businessObjectUrl;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private SessionManager sessionManager;

    public JSONObject getBillData(Long billId, String billTypeCode, String sourceType) {
        String billTypeName = "";
        CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
        if (billTypeResponse.isSuccess()) {
            BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
            billTypeName = billTypeVo.getBillName();
        }
        String url = this.businessObjectUrl + billId;
        JSONObject businessObject = new JSONObject();
        businessObject.put("businessObjectId", (Object)billTypeCode);
        businessObject.put("businessObjectName", (Object)billTypeName);
        businessObject.put("businessObjectUrl", (Object)url);
        businessObject.put("businessObjectModifyUrl", (Object)url);
        businessObject.put("businessObjectVersion", (Object)String.valueOf(IdWorker.getId()));
        JSONObject billData = this.queryBillDetail(billId, billTypeCode, sourceType);
        this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + billData.toJSONString());
        JSONObject data = JSONObject.parseObject((String)billData.get((Object)"data").toString());
        JSONArray fields = (JSONArray)data.get((Object)"fields");
        JSONObject field = new JSONObject();
        field.put("id", (Object)"TITLE");
        field.put("name", (Object)"\u6d41\u7a0b\u4e3b\u9898");
        field.put("value", (Object)(this.sessionManager.getUserContext().getUserName() + "\u63d0\u4ea4\u7684" + billTypeName));
        fields.add((Object)field);
        businessObject.put("fields", (Object)fields);
        businessObject.put("lists", data.get((Object)"lists"));
        businessObject.put("attachments", data.get((Object)"attachments"));
        businessObject.put("relatedProcess", null);
        JSONObject result = new JSONObject();
        result.put("businessObject", (Object)businessObject);
        return result;
    }

    public JSONObject queryBillDetail(Long businessKey, String billTypeCode, String sourceType) {
        this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5api\u5f00\u59cb\u53c2\u6570\uff1a------businessKey\uff1a" + businessKey + "billType:" + billTypeCode);
        JSONObject referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null || referVo.get((Object)"tableName") == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5143\u6570\u636e\u5931\u8d25");
        }
        HashMap<String, String> paramterMap = new HashMap<String, String>();
        paramterMap.put("billId", String.valueOf(businessKey));
        paramterMap.put("databaseName", referVo.get((Object)"databaseName").toString());
        paramterMap.put("tableName", referVo.get((Object)"tableName").toString());
        paramterMap.put("metadataId", referVo.get((Object)"metadataId").toString());
        paramterMap.put("sourceType", sourceType);
        paramterMap.put("billTypeCode", billTypeCode);
        this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u4f20\u9012\u7684\u53c2\u6570\uff1a---------------" + ((Object)paramterMap).toString());
        String paramterStr = this.gson.toJson(paramterMap);
        String url = this.environmentTools.getBaseHost() + referVo.get((Object)"projectName") + "/commonZatop/queryZatopBillDetail";
        this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u4f20\u9012\u7684url\uff1a---------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
            return JSONObject.parseObject((String)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("-------\u6839\u636ebillType\uff1a" + billTypeCode + "\u67e5\u8be2\u5355\u636e\u4fe1\u606f\u5931\u8d25:");
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public JSONObject getMdByTypeCode(String billTypeCode) {
        JSONObject json = new JSONObject();
        String key = "btd-md-" + billTypeCode;
        if (this.cacheManager.get(key) != null) {
            json = (JSONObject)this.cacheManager.get(key);
        } else {
            CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
            if (billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
                this.logger.info("\u8c03\u7528\u5143\u6570\u636eapi\u53c2\u6570\uff1a---------------" + billTypeVo.getMetadataId());
                if (billTypeVo.getMetadataId() != null) {
                    CommonResponse referResponse = this.mdApi.queryMetadataById(billTypeVo.getMetadataId());
                    if (referResponse.isSuccess()) {
                        MdReferVO vo = (MdReferVO)referResponse.getData();
                        json.put("metadataId", (Object)billTypeVo.getMetadataId());
                        json.put("billTypeCode", (Object)billTypeVo.getBillCode());
                        json.put("databaseName", (Object)vo.getDatabaseName());
                        json.put("projectName", (Object)vo.getProjectName());
                        json.put("tableName", (Object)vo.getTableName());
                        this.cacheManager.setex(key, (Serializable)json, 3000);
                    } else {
                        this.logger.info("\u8c03\u7528\u67e5\u8be2\u5143\u6570\u636e\u670d\u52a1\u5f02\u5e38\uff1a---------------" + referResponse.getMsg());
                    }
                }
            }
        }
        return json;
    }
}

