/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.mq.consumer;

import com.ejianc.zatopbpm.mq.consumer.AliyunCredentialsProvider;
import com.rabbitmq.client.impl.CredentialsProvider;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Binding;
import org.springframework.amqp.core.BindingBuilder;
import org.springframework.amqp.core.DirectExchange;
import org.springframework.amqp.core.Exchange;
import org.springframework.amqp.core.Queue;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.amqp.RabbitProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConfigurationProperties(prefix="zatop.rabbitmq")
public class RabbitConfig {
    Logger logger = LoggerFactory.getLogger(RabbitConfig.class);
    private String host;
    private int port;
    private String username;
    private String password;
    private String virtualHost;
    private String instanceId;
    private String queue;
    @Autowired
    private RabbitProperties rabbitProperties;

    @Bean
    public ConnectionFactory getConnectionFactory() {
        this.logger.info("\u6d88\u606f\u961f\u5217\u53c2\u6570\uff1a----host\uff1a{}\uff0cport\uff1a{}\uff0cusername\uff1a{}\uff0cpassword\uff1a{}\uff0cvirtualHost\uff1a{}\uff0cinstanceId\uff1a{}", new Object[]{this.host, this.port, this.username, this.password, this.virtualHost, this.instanceId});
        com.rabbitmq.client.ConnectionFactory rabbitConnectionFactory = new com.rabbitmq.client.ConnectionFactory();
        rabbitConnectionFactory.setHost(this.host);
        rabbitConnectionFactory.setPort(this.port);
        rabbitConnectionFactory.setVirtualHost(this.virtualHost);
        AliyunCredentialsProvider credentialsProvider = new AliyunCredentialsProvider(this.username, this.password, this.instanceId);
        rabbitConnectionFactory.setCredentialsProvider((CredentialsProvider)credentialsProvider);
        rabbitConnectionFactory.setAutomaticRecoveryEnabled(true);
        rabbitConnectionFactory.setNetworkRecoveryInterval(5000);
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory(rabbitConnectionFactory);
        connectionFactory.setPublisherConfirms(this.rabbitProperties.isPublisherConfirms());
        connectionFactory.setPublisherReturns(this.rabbitProperties.isPublisherReturns());
        return connectionFactory;
    }

    @Bean
    public Queue queue() {
        HashMap arguments = new HashMap(4);
        return new Queue(this.queue, true, false, false, arguments);
    }

    @Bean
    public Exchange exchange() {
        HashMap arguments = new HashMap(4);
        return new DirectExchange("", true, false, arguments);
    }

    @Bean
    public Binding binding() {
        return BindingBuilder.bind((Queue)this.queue()).to(this.exchange()).with(this.queue).noargs();
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getVirtualHost() {
        return this.virtualHost;
    }

    public void setVirtualHost(String virtualHost) {
        this.virtualHost = virtualHost;
    }

    public RabbitProperties getRabbitProperties() {
        return this.rabbitProperties;
    }

    public void setRabbitProperties(RabbitProperties rabbitProperties) {
        this.rabbitProperties = rabbitProperties;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getQueue() {
        return this.queue;
    }

    public void setQueue(String queue) {
        this.queue = queue;
    }
}

