/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.utils;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.api.IMdAttributeApi;
import com.ejianc.foundation.metadata.api.IMdClassApi;
import com.ejianc.foundation.metadata.vo.MdAttributeVO;
import com.ejianc.foundation.metadata.vo.MdClassVO;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.framework.skeleton.refer.util.ContextUtil;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.zatopbpm.mapper.CommenMapper;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import com.google.gson.Gson;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class GetBillDataUtil {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Value(value="${zatop.businessObjectUrl:https://auth.zatop.cn/oauth/authorize?client_id=web&redirect_uri=https%3A%2F%2Fpm.zatop.cn%2Fportal%2Fno_auth%2Fzatop%2FssoLogin&scope=server&response_type=code&state=}")
    private String businessObjectUrl;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private EnvironmentTools environmentTools;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private CommenMapper commenMapper;
    @Autowired
    private IMdAttributeApi mdAttributeApi;
    @Autowired
    private IMdClassApi mdClassApi;

    public JSONObject getBillData(Long billId, String billTypeCode, String sourceType) {
        String billTypeName = "";
        CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
        if (billTypeResponse.isSuccess()) {
            BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
            billTypeName = billTypeVo.getBillName();
        }
        String url = this.businessObjectUrl + billId;
        JSONObject businessObject = new JSONObject();
        businessObject.put("businessObjectId", (Object)billTypeCode);
        businessObject.put("businessObjectName", (Object)billTypeName);
        businessObject.put("businessObjectUrl", (Object)url);
        businessObject.put("businessObjectModifyUrl", (Object)url);
        businessObject.put("businessObjectVersion", (Object)String.valueOf(IdWorker.getId()));
        JSONObject billData = this.queryBillDetail(billId, billTypeCode, sourceType);
        this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + billData.toJSONString());
        JSONArray fields = (JSONArray)billData.get((Object)"fields");
        JSONObject field = new JSONObject();
        field.put("id", (Object)"TITLE");
        field.put("name", (Object)"\u6d41\u7a0b\u4e3b\u9898");
        field.put("value", (Object)(this.sessionManager.getUserContext().getUserName() + "\u63d0\u4ea4\u7684" + billTypeName));
        fields.add((Object)field);
        businessObject.put("fields", (Object)fields);
        businessObject.put("lists", billData.get((Object)"lists"));
        businessObject.put("attachments", billData.get((Object)"attachments"));
        businessObject.put("relatedProcess", null);
        JSONObject result = new JSONObject();
        result.put("businessObject", (Object)businessObject);
        return result;
    }

    public JSONObject queryBillDetail(Long businessKey, String billTypeCode, String sourceType) {
        this.logger.info("\u67e5\u8be2\u5355\u636e\u8be6\u60c5api\u5f00\u59cb\u53c2\u6570\uff1a------businessKey\uff1a" + businessKey + "billType:" + billTypeCode);
        JSONObject referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null || referVo.get((Object)"tableName") == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u67e5\u8be2\u5143\u6570\u636e\u5931\u8d25");
        }
        return this.queryBillDetail(businessKey, referVo.get((Object)"databaseName").toString(), referVo.get((Object)"databaseName").toString(), referVo.get((Object)"tableName").toString(), Long.parseLong(referVo.get((Object)"metadataId").toString()), sourceType, billTypeCode);
    }

    public JSONObject getMdByTypeCode(String billTypeCode) {
        JSONObject json = new JSONObject();
        String key = "btd-md-" + billTypeCode;
        if (this.cacheManager.get(key) != null) {
            json = (JSONObject)this.cacheManager.get(key);
        } else {
            CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
            if (billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
                this.logger.info("\u8c03\u7528\u5143\u6570\u636eapi\u53c2\u6570\uff1a---------------" + billTypeVo.getMetadataId());
                if (billTypeVo.getMetadataId() != null) {
                    CommonResponse referResponse = this.mdApi.queryMetadataById(billTypeVo.getMetadataId());
                    if (referResponse.isSuccess()) {
                        MdReferVO vo = (MdReferVO)referResponse.getData();
                        json.put("metadataId", (Object)billTypeVo.getMetadataId());
                        json.put("entityName", (Object)vo.getEntityName());
                        json.put("billTypeCode", (Object)billTypeVo.getBillCode());
                        json.put("databaseName", (Object)vo.getDatabaseName());
                        json.put("projectName", (Object)vo.getProjectName());
                        json.put("tableName", (Object)vo.getTableName());
                        this.cacheManager.setex(key, (Serializable)json, 3000);
                    } else {
                        this.logger.info("\u8c03\u7528\u67e5\u8be2\u5143\u6570\u636e\u670d\u52a1\u5f02\u5e38\uff1a---------------" + referResponse.getMsg());
                    }
                }
            }
        }
        return json;
    }

    public JSONObject queryBillDetail(Long billId, String entityName, String databaseName, String tableName, Long metadataId, String sourceType, String billTypeCode) {
        JSONObject result = new JSONObject();
        ICommonZatopBusinessService commonZatopBusinessService = this.obtainBusinessService(entityName);
        List<String> columnList = this.commenMapper.queryTableAttrList(databaseName, tableName);
        HashMap<String, String> columnMap = new HashMap<String, String>();
        if (columnList != null && columnList.size() > 0) {
            for (String column : columnList) {
                columnMap.put(column, column);
            }
        }
        JSONArray fields = new JSONArray();
        JSONObject billData = new JSONObject();
        CommonResponse attributeResponse = this.mdAttributeApi.queryMainAttributeList(metadataId);
        if (attributeResponse.isSuccess()) {
            HashMap<String, MdAttributeVO> attributeMap = new HashMap<String, MdAttributeVO>();
            List mdAttributeVos = (List)attributeResponse.getData();
            StringBuffer paramBuffer = new StringBuffer("");
            if (mdAttributeVos != null && mdAttributeVos.size() > 0) {
                for (MdAttributeVO mdAttributeVo : mdAttributeVos) {
                    attributeMap.put(mdAttributeVo.getAttributeName(), mdAttributeVo);
                    if (!columnMap.containsKey(mdAttributeVo.getColumnName())) continue;
                    paramBuffer.append("`" + mdAttributeVo.getColumnName() + "`").append(" as ").append("`" + mdAttributeVo.getAttributeName() + "`").append(",");
                }
                if (StringUtils.isNotBlank((CharSequence)paramBuffer)) {
                    JSONObject jsonObject;
                    String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                    billData = jsonObject = this.commenMapper.queryBillDetail(databaseName, tableName, parameter, String.valueOf(billId));
                    jsonObject = commonZatopBusinessService.dealBillData(billId, jsonObject);
                    for (String key : attributeMap.keySet()) {
                        MdAttributeVO mdAttributeVO = (MdAttributeVO)attributeMap.get(key);
                        Object value = jsonObject.get((Object)key);
                        JSONObject field = new JSONObject();
                        field.put("id", (Object)key);
                        field.put("name", (Object)mdAttributeVO.getDisplayName());
                        if (jsonObject.get((Object)key) != null) {
                            if ("datetime".equals(mdAttributeVO.getDataType()) && !(value instanceof String)) {
                                value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
                            } else if ("date".equals(mdAttributeVO.getDataType()) && !(value instanceof String)) {
                                value = new SimpleDateFormat("yyyy-MM-dd").format(value);
                            } else if ("long".equals(mdAttributeVO.getDataType()) && !(value instanceof String) && StringUtils.isNotBlank((CharSequence)mdAttributeVO.getReferCode())) {
                                try {
                                    JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)value.toString(), (String)mdAttributeVO.getReferCode());
                                    if (jArray != null && jArray.size() > 0) {
                                        JSONObject json = (JSONObject)jArray.get(0);
                                        value = json.get((Object)"name") != null ? json.get((Object)"name").toString() : "";
                                    }
                                }
                                catch (Exception jArray) {
                                    // empty catch block
                                }
                            }
                        }
                        field.put("value", value);
                        fields.add((Object)field);
                    }
                }
            }
        }
        fields = commonZatopBusinessService.addFields(billId, billData, fields);
        result.put("fields", (Object)fields);
        JSONArray lists = new JSONArray();
        CommonResponse classChildrenResponse = this.mdClassApi.findAllByParentEntityId(metadataId);
        if (classChildrenResponse.isSuccess() && classChildrenResponse.getData() != null && ((List)classChildrenResponse.getData()).size() > 0) {
            List classChildren = (List)classChildrenResponse.getData();
            for (MdClassVO mdClassVO : classChildren) {
                CommonResponse attributeChildrenResponse;
                JSONObject list = new JSONObject();
                list.put("listId", (Object)mdClassVO.getMainAttributeField());
                list.put("listName", (Object)mdClassVO.getDisplayName());
                JSONArray items = new JSONArray();
                List<String> columnChildrenList = this.commenMapper.queryTableAttrList(databaseName, mdClassVO.getTableName());
                HashMap<String, String> columnChildrenMap = new HashMap<String, String>();
                if (columnChildrenList != null && columnChildrenList.size() > 0) {
                    for (String column : columnChildrenList) {
                        columnChildrenMap.put(column, column);
                    }
                }
                if ((attributeChildrenResponse = this.mdAttributeApi.queryMainAttributeList(mdClassVO.getId())).isSuccess()) {
                    HashMap<String, MdAttributeVO> attributeMap = new HashMap<String, MdAttributeVO>();
                    List mdAttributeVos = (List)attributeChildrenResponse.getData();
                    StringBuffer paramBuffer = new StringBuffer("");
                    String param = "";
                    if (mdAttributeVos != null && mdAttributeVos.size() > 0) {
                        for (MdAttributeVO mdAttributeVo : mdAttributeVos) {
                            attributeMap.put(mdAttributeVo.getAttributeName(), mdAttributeVo);
                            if (columnChildrenMap.containsKey(mdAttributeVo.getColumnName())) {
                                paramBuffer.append("`" + mdAttributeVo.getColumnName() + "`").append(" as ").append("`" + mdAttributeVo.getAttributeName() + "`").append(",");
                            }
                            if (!mdAttributeVo.getForeignKeyFlag()) continue;
                            param = "dr = 0 and " + mdAttributeVo.getColumnName() + "=" + billId;
                        }
                        if (StringUtils.isNotBlank((CharSequence)paramBuffer)) {
                            String parameter = paramBuffer.substring(0, paramBuffer.length() - 1);
                            JSONArray childrenData = this.commenMapper.queryBillInfoByProperty(databaseName, mdClassVO.getTableName(), parameter.toString(), param);
                            childrenData = commonZatopBusinessService.dealBillchldrenData(billId, mdClassVO.getEntityName(), childrenData);
                            for (Object object : childrenData) {
                                JSONObject jsonObject = (JSONObject)object;
                                JSONArray children = new JSONArray();
                                for (String key : attributeMap.keySet()) {
                                    MdAttributeVO mdAttributeVO = (MdAttributeVO)attributeMap.get(key);
                                    Object value = jsonObject.get((Object)key);
                                    JSONObject field = new JSONObject();
                                    field.put("id", (Object)key);
                                    field.put("name", (Object)mdAttributeVO.getDisplayName());
                                    if (jsonObject.get((Object)key) != null) {
                                        if ("datetime".equals(mdAttributeVO.getDataType()) && !(value instanceof String)) {
                                            value = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(value);
                                        } else if ("date".equals(mdAttributeVO.getDataType()) && !(value instanceof String)) {
                                            value = new SimpleDateFormat("yyyy-MM-dd").format(value);
                                        } else if ("long".equals(mdAttributeVO.getDataType()) && !(value instanceof String) && StringUtils.isNotBlank((CharSequence)mdAttributeVO.getReferCode())) {
                                            try {
                                                JSONArray jArray = ReferObjectUtil.getReferEntityValue((String)value.toString(), (String)mdAttributeVO.getReferCode());
                                                if (jArray != null && jArray.size() > 0) {
                                                    JSONObject json = (JSONObject)jArray.get(0);
                                                    value = json.get((Object)"name") != null ? json.get((Object)"name").toString() : "";
                                                }
                                            }
                                            catch (Exception exception) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    field.put("value", value);
                                    children.add((Object)field);
                                }
                                items.add((Object)children);
                            }
                        }
                    }
                }
                list.put("items", (Object)items);
                lists.add((Object)list);
            }
        }
        lists = commonZatopBusinessService.dealBillChildrenData(billId, lists);
        result.put("lists", (Object)lists);
        JSONArray attachments = new JSONArray();
        CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(billId, billTypeCode, sourceType, null);
        if (attachmentResponse.isSuccess() && attachmentResponse.getData() != null && ((List)attachmentResponse.getData()).size() > 0) {
            for (AttachmentVO attachmentVO : (List)attachmentResponse.getData()) {
                JSONObject attachment = new JSONObject();
                attachment.put("fileId", (Object)attachmentVO.getId());
                attachment.put("fileName", (Object)attachmentVO.getFileName());
                String fileType = "";
                if (attachmentVO.getFileName().contains(".")) {
                    fileType = attachmentVO.getFileName().split("\\.")[1];
                }
                attachment.put("fileType", (Object)fileType);
                String fileUrl = this.environmentTools.getBaseHost() + "ejc-file-web/attachment/filePreview?fileId=" + attachmentVO.getId();
                attachment.put("fileUrl", (Object)fileUrl);
                attachment.put("uploadUserId", (Object)attachmentVO.getCreateUserCode());
                attachment.put("uploadUserName", (Object)attachmentVO.getCreateUserName());
                attachments.add((Object)attachment);
            }
        }
        attachments = commonZatopBusinessService.dealBillAttachmentsData(billId, sourceType, attachments);
        result.put("attachments", (Object)attachments);
        return result;
    }

    public static String toLowerCaseFirstOne(String param) {
        if (Character.isLowerCase(param.charAt(0))) {
            return param;
        }
        return Character.toLowerCase(param.charAt(0)) + param.substring(1);
    }

    private ICommonZatopBusinessService obtainBusinessService(String entityName) {
        String serviceName = GetBillDataUtil.toLowerCaseFirstOne(entityName.replace("Entity", "Zatop"));
        ICommonZatopBusinessService businessService = null;
        try {
            businessService = (ICommonZatopBusinessService)ContextUtil.getBean((String)serviceName, ICommonZatopBusinessService.class);
        }
        catch (Exception e) {
            businessService = (ICommonZatopBusinessService)ContextUtil.getBean((String)"defaultZatopBusinessService", ICommonZatopBusinessService.class);
        }
        return businessService;
    }
}

