/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IApproveBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="approveBpmService")
public class ApproveBpmServiceImpl
implements IApproveBpmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void approveBpm(Map<String, Object> params) {
        CommonResponse<String> afterInApprovalResponse;
        ErrorCallbackEntity entity;
        String billId = params.get("billId") != null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String stepName = params.get("stepName") != null ? params.get("stepName").toString() : null;
        String userid = params.get("userid") != null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId") != null ? params.get("bpmId").toString() : null;
        String authority = this.initUserContextUtil.initUserContext(userid);
        if (!authority.contains("userCode")) {
            ErrorCallbackEntity entity2 = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approving-initUserContext", userid, JSONUtil.toJsonStr(params), "\u521d\u59cb\u5316\u4e0a\u4e0b\u6587\u4fe1\u606f\u5931\u8d25-----" + authority);
            this.errorCallbackService.saveOrUpdate((Object)entity2, false);
            return;
        }
        InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)authority);
        BpmInfoEntity infoEntity = this.bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType("approving");
        this.bpmInfoService.saveOrUpdate((Object)infoEntity, false);
        this.logger.info("-----------------------\u5ba1\u6279\u4e2d\u56de\u8c03\u4e8b\u4ef6\u5f00\u59cb-------------------------");
        CommonResponse<String> beforeInApprovalResponse = this.updateBillStateUtils.beforeInApprovalBack(Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE, stepName);
        if (!beforeInApprovalResponse.isSuccess()) {
            this.logger.error("\u5355\u636e\u5ba1\u6279\u4e2d\u56de\u8c03\u524d\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(beforeInApprovalResponse.getMsg());
            String message = beforeInApprovalResponse.getMsg() != null && beforeInApprovalResponse.getMsg().length() > 1000 ? beforeInApprovalResponse.getMsg().substring(0, 1000) : beforeInApprovalResponse.getMsg();
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approving-beforeInApproval", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        this.logger.info("\u56de\u5199\u5355\u636e\u72b6\u6001\uff01===========\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a2\uff08\u5ba1\u6279\u4e2d\uff09");
        CommonResponse<String> back = this.updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE);
        if (!back.isSuccess()) {
            this.logger.info("\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u56de\u5199\u5355\u636e\u72b6\u6001\u5931\u8d25\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\uff01\u5c06\u5355\u636eid:" + billId + "\u7684\u72b6\u6001\u6539\u4e3a2\uff08\u5ba1\u6279\u4e2d\uff09\u5931\u8d25");
            entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approving-updateBillState", userid, JSONUtil.toJsonStr(params), "\u66f4\u65b0\u5355\u636e\u72b6\u6001\u5931\u8d25");
            this.errorCallbackService.saveOrUpdate((Object)entity, false);
        }
        if (!(afterInApprovalResponse = this.updateBillStateUtils.afterInApprovalBack(Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE, null, false, stepName, null)).isSuccess()) {
            this.logger.error("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u540e\u56de\u8c03\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
            this.logger.error(afterInApprovalResponse.getMsg());
            String message = afterInApprovalResponse.getMsg() != null && afterInApprovalResponse.getMsg().length() > 1000 ? afterInApprovalResponse.getMsg().substring(0, 1000) : afterInApprovalResponse.getMsg();
            ErrorCallbackEntity entity3 = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "approving-afterInApproval", userid, JSONUtil.toJsonStr(params), message);
            this.errorCallbackService.saveOrUpdate((Object)entity3, false);
        }
        this.logger.info("-----------------------\u5ba1\u6279\u4e2d\u56de\u8c03\u4e8b\u4ef6\u7ed3\u675f-------------------------");
    }
}

