package com.ejianc.zatopbpm.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.vo.ModuleVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.zatopbpm.bean.BpmConfigEntity;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.BpmOrgRelationEntity;
import com.ejianc.zatopbpm.service.IBpmConfigService;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IBpmOrgRelationService;
import com.ejianc.zatopbpm.vo.BpmConfigVO;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import com.ejianc.zatopbpm.vo.BpmOrgRelationVO;
import com.ejianc.zatopbpm.vo.ErrorCallbackVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 审批配置表
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("bpmConfig")
public class BpmConfigController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBpmConfigService service;
    @Autowired
    private IBpmOrgRelationService orgRelationService;
    @Autowired
    private IModuleApi moduleApi;

    @Autowired
    private SessionManager sessionManager;


    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BpmConfigVO> queryDetail(Long id) {
        BpmConfigEntity entity = service.selectById(id);
        BpmConfigVO vo = BeanMapper.map(entity, BpmConfigVO.class);

        QueryWrapper<BpmOrgRelationEntity> queryWrapper = new QueryWrapper<BpmOrgRelationEntity>();
        queryWrapper.eq("dr", 0);
        queryWrapper.eq("config_id", vo.getId());
        List<BpmOrgRelationEntity> relation = orgRelationService.querylist(queryWrapper);
        if(relation!=null&&relation.size()>0){
            vo.setRelationList(BeanMapper.mapList(relation, BpmOrgRelationVO.class));
        }
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BpmConfigVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();

        if(param.getParams().get("moduleId")!=null){
            List<Long> moduleIds = new ArrayList<>();
            CommonResponse<List<ModuleVO>> moduleResponse = moduleApi.queryModuleListByPid(Long.parseLong(param.getParams().get("moduleId").getValue().toString()));
            if(moduleResponse.isSuccess()) {
                List<ModuleVO> modules= moduleResponse.getData();
                for(int i=0;i<modules.size();i++) {
                    moduleIds.add(modules.get(i).getId());
                }
            }
            param.getParams().get("moduleId").setType(QueryParam.IN);
            param.getParams().get("moduleId").setValue(moduleIds);
        }
        /** 租户隔离 */
        IPage<BpmConfigEntity> page = service.queryPage(param,false);
        IPage<BpmConfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BpmConfigVO.class));
        if(pageData.getRecords()!=null && pageData.getRecords().size()>0){
            for(BpmConfigVO vo : pageData.getRecords()){
                QueryWrapper<BpmOrgRelationEntity> queryWrapper = new QueryWrapper<BpmOrgRelationEntity>();
                queryWrapper.eq("dr", 0);
                queryWrapper.eq("config_id", vo.getId());
                List<BpmOrgRelationEntity> relation = orgRelationService.querylist(queryWrapper);
                if(relation!=null&&relation.size()>0){
                    String useOrg = "";
                    for(BpmOrgRelationEntity entity : relation){
                        if(entity.getOrgId()!=null){
                            try {
                                JSONArray jArray = ReferObjectUtil.getReferEntityValue(entity.getOrgId().toString(), "idm-org");
                                if(jArray!=null&&jArray.size()>0){
                                    JSONObject json = (JSONObject) jArray.get(0);
                                    if(useOrg.length()>0){
                                        if("self".equals(entity.getRange())){
                                            useOrg += ("、"+json.get("name").toString()+"(本级)");
                                        }else{
                                            useOrg += ("、"+json.get("name").toString()+"(本下)");
                                        }
                                    }else{
                                        if("self".equals(entity.getRange())){
                                            useOrg += (json.get("name").toString()+"(本级)");
                                        }else{
                                            useOrg += (json.get("name").toString()+"(本下)");
                                        }
                                    }
                                }
                            } catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }
                    vo.setUseOrg(useOrg);
                }
            }
        }
        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 保存
     *
     * @param
     * @return
     */
    @RequestMapping(value = "/save", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BpmConfigVO> save(@RequestBody BpmConfigVO saveData) {
        return service.saveData(saveData);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BpmConfigVO> vos) {
        return service.deleteVOs(vos);
    }

}
