package com.ejianc.zatopbpm.service.bpmEvent.impl;

import cn.hutool.json.JSONUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IFinishBpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.ErrorTypeConfig;
import com.ejianc.zatopbpm.utils.InitUserContextUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.servlet.http.HttpServletRequest;
import java.util.Map;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("finishBpmService")
public class FinishBpmServiceImpl implements IFinishBpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private HttpServletRequest request;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Autowired
    private InitUserContextUtil initUserContextUtil;

    @Override
    public void finishBpm(Map<String, Object> params) {
        String billId = params.get("billId") != null ? params.get("billId").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String userid = params.get("userid") != null ? params.get("userid").toString() : null;
        String bpmId = params.get("bpmId")!=null ? params.get("bpmId").toString() : null;

        String authority = initUserContextUtil.initUserContext(userid);
        if(authority.contains("userCode")){
            InvocationInfoProxy.setExtendAttribute("authority",authority);
        }else {
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.APPROVED_INITUSERCONTEXT, userid, JSONUtil.toJsonStr(params), "初始化上下文信息失败-----"+authority, bpmId);
            errorCallbackService.saveOrUpdate(entity, false);
            return;
        }

        //修改流程状态
        BpmInfoEntity infoEntity = bpmInfoService.selectByBpmId(bpmId);
        infoEntity.setType("finish");
        bpmInfoService.saveOrUpdate(infoEntity,false);

        logger.info("---------------单据终审回调事件开始-------------------------");
        CommonResponse<String> approvalResponse = updateBillStateUtils.beforeApprovalProcessor(
                Long.parseLong(billId), billTypeCode, BillState.APPROVING_HAS_STATE);
        if (!approvalResponse.isSuccess()) {
            logger.error("单据终审回调前事件报错， 请检查对应服务是否正常！");
            logger.error(approvalResponse.getMsg());
            String message = approvalResponse.getMsg() != null && approvalResponse.getMsg().length() > 1000 ? (approvalResponse.getMsg().substring(0, 1000)) : approvalResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.BEFOREAPPROVAL, userid, JSONUtil.toJsonStr(params), message, bpmId);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        // 回写单据状态
        logger.info("回写单据状态！===========" + "将单据id:" + billId + "的状态改为3（审批通过）");
        CommonResponse<String> resu = updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.PASSED_STATE);
        if (!resu.isSuccess()) {
            //为了预防第一次没有执行成功，故再执行一次
            CommonResponse<String> back = updateBillStateUtils.updateBillState(Long.parseLong(billId), billTypeCode, BillState.PASSED_STATE);
            if(!back.isSuccess()){
                logger.info("！！！！！！！！回写单据状态失败！！！！！！！！！" + "将单据id:" + billId + "的状态改为3（审批通过）失败");
                ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.APPROVED_UPDATEBILLSTATE, userid, JSONUtil.toJsonStr(params), "更新单据状态失败", bpmId);
                errorCallbackService.saveOrUpdate(entity, false);
            }
        }
        CommonResponse<String> afterApprovalResponse = updateBillStateUtils.afterApprovalProcessor(
                Long.parseLong(billId), billTypeCode, BillState.PASSED_STATE);
        if (!afterApprovalResponse.isSuccess()) {
            logger.error("单据终审回调后事件报错， 请检查对应服务是否正常！");
            logger.error(afterApprovalResponse.getMsg());
            String message = afterApprovalResponse.getMsg() != null && afterApprovalResponse.getMsg().length() > 1000 ? (afterApprovalResponse.getMsg().substring(0, 1000)) : afterApprovalResponse.getMsg();
            ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, ErrorTypeConfig.AFTERAPPROVAL, userid, JSONUtil.toJsonStr(params), message, bpmId);
            errorCallbackService.saveOrUpdate(entity, false);
        }
        logger.info("---------------单据终审回调事件结束-------------------------");
    }
}
