package com.ejianc.zatopbpm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.zatopbpm.bean.BpmConfigEntity;
import com.ejianc.zatopbpm.bean.BpmOrgRelationEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.mapper.BpmConfigMapper;
import com.ejianc.zatopbpm.service.IBpmConfigService;
import com.ejianc.zatopbpm.service.IBpmOrgRelationService;
import com.ejianc.zatopbpm.vo.BpmConfigVO;
import com.ejianc.zatopbpm.vo.BpmOrgRelationVO;
import com.ejianc.zatopbpm.vo.ErrorCallbackVO;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.jdbc.Null;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 审批
 * 
 * @author generator
 * 
 */
@Service("bpmConfigService")
public class BpmConfigServiceImpl extends BaseServiceImpl<BpmConfigMapper, BpmConfigEntity> implements IBpmConfigService {

    @Autowired
    private IBpmOrgRelationService orgRelationService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<BpmConfigVO> saveData(BpmConfigVO vo) {
        if(vo.getBillTypeId()==null){
            throw new BusinessException("缺少单据类型");
        }
        if(vo.getId() == null){
            QueryWrapper<BpmConfigEntity> wrapper = new QueryWrapper<>();
            wrapper.eq("bill_type_id", vo.getBillTypeId());
            List<BpmConfigEntity> list = this.list(wrapper);
            if(list!=null && list.size()>0){
                throw new BusinessException("该单据类型已存在配置");
            }
        }
        BpmConfigEntity entity = BeanMapper.map(vo, BpmConfigEntity.class);
        this.saveOrUpdate(entity, false);
        List<BpmOrgRelationVO> relations = vo.getRelationList();
        List<BpmOrgRelationEntity> relationEntitys = new ArrayList<>();
        List<Long> delattributosIds = new ArrayList<>();
        for (BpmOrgRelationVO rvo : relations) {
            if (StringUtils.isNotBlank(rvo.getRowState()) && rvo.getRowState().equals("add")) {
                BpmOrgRelationEntity en = BeanMapper.map(rvo, BpmOrgRelationEntity.class);
                en.setConfigId(entity.getId());
                en.setDr(0);
                relationEntitys.add(en);
            }
            if (StringUtils.isNotBlank(rvo.getRowState()) && rvo.getRowState().equals("edit")) {
                BpmOrgRelationEntity en = BeanMapper.map(rvo, BpmOrgRelationEntity.class);
                relationEntitys.add(en);
            }
            if (StringUtils.isNotBlank(rvo.getRowState()) && rvo.getRowState().equals("del")) {
                delattributosIds.add(rvo.getId());
            }
        }
        if (relationEntitys.size() > 0) {
            orgRelationService.saveOrUpdateBatch(relationEntitys, relationEntitys.size(), false);
        }
        if (delattributosIds.size() > 0) {
            orgRelationService.removeByIds(delattributosIds, false);
        }
        vo = BeanMapper.map(entity, BpmConfigVO.class);
        return CommonResponse.success(vo);
    }

    @Override
    public CommonResponse<String> deleteVOs(List<BpmConfigVO> vos) {
        List<Long> ids = new ArrayList<>();
        if(ListUtil.isNotEmpty(vos)){
            for (BpmConfigVO vo : vos) {
                ids.add(vo.getId());
            }
        }
        this.removeByIds(vos.stream().map(BpmConfigVO::getId).collect(Collectors.toList()),true);
        orgRelationService.delete(ids);
        return CommonResponse.success("删除成功！");
    }

    @Override
    public Boolean queryByOrgAndBillType(Long orgId, String billTypeCode) {
        Map<String,String> checkMap = new HashMap<>();
        Boolean flag = false;
        QueryWrapper<BpmConfigEntity> wrapper = new QueryWrapper<>();
        wrapper.eq("bill_type_code", billTypeCode);
        List<BpmConfigEntity> list = this.list(wrapper);
        if(list!=null && list.size()>0){
            if(list.get(0).getState()){
                CommonResponse<OrgVO> org = orgApi.getOneById(orgId);
                OrgVO orgVO = new OrgVO();
                if(org.isSuccess()){
                    if(org.getData()!=null){
                        orgVO = org.getData();
                    }else{
                        throw new BusinessException("未查询到所属组织详情信息");
                    }
                }else{
                    throw new BusinessException("网络错误，查询组织信息失败");
                }
                QueryWrapper<BpmOrgRelationEntity> orgwrapper = new QueryWrapper<>();
                orgwrapper.eq("config_id", list.get(0).getId());
                List<BpmOrgRelationEntity> orglist = orgRelationService.querylist(orgwrapper);

                for(BpmOrgRelationEntity vo : orglist){
                    if("self".equals(vo.getRange())){
                        flag = true;
                        break;
                    }else if("down".equals(vo.getRange())){
                        if(orgVO.getInnerCode().contains(vo.getOrgId().toString())){
                            flag = true;
                            break;
                        }
                    }
                }
            }
        }
        return flag;
    }
}
