package com.ejianc.zatopbpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.mapper.ErrorCallbackMapper;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.ErrorTypeConfig;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.ejianc.zatopbpm.vo.ErrorCallbackVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * 错误回调事件实体
 * 
 * @author generator
 * 
 */
@Service("errorCallbackService")
public class ErrorCallbackServiceImpl extends BaseServiceImpl<ErrorCallbackMapper, ErrorCallbackEntity> implements IErrorCallbackService{
    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());
    @Autowired
    private ErrorCallbackMapper errorCallbackMapper;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;

    @Override
    public CommonResponse<String> deal(ErrorCallbackVO vo) {
        if(ErrorTypeConfig.SUBMIT_INITUSERCONTEXT.equals(vo.getType())){
            //提交---获取上下文信息
            CommonResponse<String> brforeSubmitResponse = updateBillStateUtils.beforeSubmitProcessor(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!brforeSubmitResponse.isSuccess()) {
                return CommonResponse.error("提交前事件："+brforeSubmitResponse.getMsg());
            }
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_UNEXAM_STATE);
            if(!back.isSuccess()){
                return CommonResponse.error("提交修改单据状态事件："+back.getMsg());
            }
            CommonResponse<String> afterSubmitResponse = updateBillStateUtils.afterSubmitProcessor(vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_UNEXAM_STATE);
            if(!afterSubmitResponse.isSuccess()) {
                return CommonResponse.error("提交后事件："+back.getMsg());
            }
        }else if(ErrorTypeConfig.BRFORESUBMIT.equals(vo.getType())){
            //提交---提交前事件
            CommonResponse<String> brforeSubmitResponse = updateBillStateUtils.beforeSubmitProcessor(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!brforeSubmitResponse.isSuccess()) {
                return brforeSubmitResponse;
            }
        }else if(ErrorTypeConfig.SUBMIT_UPDATEBILLSTATE.equals(vo.getType())){
            //提交---修改单据状态
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_UNEXAM_STATE);
            if(!back.isSuccess()){
                return back;
            }
        }else if(ErrorTypeConfig.AFTERSUBMIT.equals(vo.getType())){
            //提交---提交后回调
            CommonResponse<String> afterSubmitResponse = updateBillStateUtils.afterSubmitProcessor(vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_UNEXAM_STATE);
            if(!afterSubmitResponse.isSuccess()) {
                return afterSubmitResponse;
            }
        }else if(ErrorTypeConfig.APPROVING_INITUSERCONTEXT.equals(vo.getType())){
            //审批中---获取上下文信息
            JSONObject params = JSONObject.parseObject(vo.getParam());
            String stepName = params.get("stepName")!=null ? params.get("stepName").toString() : null;
            CommonResponse<String> beforeInApprovalResponse = updateBillStateUtils.beforeInApprovalBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE, stepName);
            if (!beforeInApprovalResponse.isSuccess()) {
                return CommonResponse.error("审批中前事件："+beforeInApprovalResponse.getMsg());
            }
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE);
            if(!back.isSuccess()){
                return CommonResponse.error("审批中修改单据状态事件："+back.getMsg());
            }
            CommonResponse<String> afterInApprovalResponse = updateBillStateUtils.afterInApprovalBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE, null, false, stepName,null);
            if (!afterInApprovalResponse.isSuccess()) {
                return CommonResponse.error("审批中后事件："+afterInApprovalResponse.getMsg());
            }

        }else if(ErrorTypeConfig.BEFOREINAPPROVAL.equals(vo.getType())){
            //审批中---审批中前回调事件
            JSONObject params = JSONObject.parseObject(vo.getParam());
            String stepName = params.get("stepName")!=null ? params.get("stepName").toString() : null;
            CommonResponse<String> beforeInApprovalResponse = updateBillStateUtils.beforeInApprovalBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE, stepName);
            if (!beforeInApprovalResponse.isSuccess()) {
                return beforeInApprovalResponse;
            }
        }else if(ErrorTypeConfig.APPROVING_UPDATEBILLSTATE.equals(vo.getType())){
            //审批中---修改单据状态
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE);
            if(!back.isSuccess()){
                return back;
            }
        }else if(ErrorTypeConfig.AFTERINAPPROVAL.equals(vo.getType())){
            //审批中---审批中后回调事件
            JSONObject params = JSONObject.parseObject(vo.getParam());
            String stepName = params.get("stepName")!=null ? params.get("stepName").toString() : null;
            CommonResponse<String> afterInApprovalResponse = updateBillStateUtils.afterInApprovalBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE, null, false, stepName,null);
            if (!afterInApprovalResponse.isSuccess()) {
                return afterInApprovalResponse;
            }
        }else if(ErrorTypeConfig.APPROVED_INITUSERCONTEXT.equals(vo.getType())){
            //单据终审---获取上下文信息
            CommonResponse<String> approvalResponse = updateBillStateUtils.beforeApprovalProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE);
            if (!approvalResponse.isSuccess()) {
                return CommonResponse.error("单据终审前事件："+approvalResponse.getMsg());
            }
            CommonResponse<String> resu = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.PASSED_STATE);
            if (!resu.isSuccess()) {
                return CommonResponse.error("单据终审修改单据状态事件："+resu.getMsg());
            }
            CommonResponse<String> afterApprovalResponse = updateBillStateUtils.afterApprovalProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.PASSED_STATE);
            if (!afterApprovalResponse.isSuccess()) {
                return CommonResponse.error("单据终审后事件："+afterApprovalResponse.getMsg());
            }

        }else if(ErrorTypeConfig.BEFOREAPPROVAL.equals(vo.getType())){
            //单据终审---单据终审前回调事件
            CommonResponse<String> approvalResponse = updateBillStateUtils.beforeApprovalProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.APPROVING_HAS_STATE);
            if (!approvalResponse.isSuccess()) {
                return approvalResponse;
            }
        }else if(ErrorTypeConfig.APPROVED_UPDATEBILLSTATE.equals(vo.getType())){
            //单据终审---修改单据状态
            CommonResponse<String> resu = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.PASSED_STATE);
            if (!resu.isSuccess()) {
                return resu;
            }
        }else if(ErrorTypeConfig.AFTERAPPROVAL.equals(vo.getType())){
            //单据终审---单据终审后回调事件
            CommonResponse<String> afterApprovalResponse = updateBillStateUtils.afterApprovalProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.PASSED_STATE);
            if (!afterApprovalResponse.isSuccess()) {
                return afterApprovalResponse;
            }
        }else if(ErrorTypeConfig.STOP_INITUSERCONTEXT.equals(vo.getType())){
            //终止---获取上下文信息
            CommonResponse<String> beforeHasBpmBackResponse = updateBillStateUtils.beforeHasBpmBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!beforeHasBpmBackResponse.isSuccess()) {
                return CommonResponse.error("终止前事件："+beforeHasBpmBackResponse.getMsg());
            }
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!back.isSuccess()){
                return CommonResponse.error("终止修改单据状态事件："+back.getMsg());
            }
            CommonResponse<String> afterHasBpmBackResponse = updateBillStateUtils.afterHasBpmBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!afterHasBpmBackResponse.isSuccess()) {
                return CommonResponse.error("终止后事件："+afterHasBpmBackResponse.getMsg());
            }

        }else if(ErrorTypeConfig.BEFOREHASBPMBACK.equals(vo.getType())){
            //终止---终止前回调事件
            CommonResponse<String> beforeHasBpmBackResponse = updateBillStateUtils.beforeHasBpmBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!beforeHasBpmBackResponse.isSuccess()) {
                return beforeHasBpmBackResponse;
            }
        }else if(ErrorTypeConfig.STOP_UPDATEBILLSTATE.equals(vo.getType())){
            //终止---修改单据状态
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!back.isSuccess()){
                return back;
            }
        }else if(ErrorTypeConfig.AFTERHASBPMBACK.equals(vo.getType())){
            //终止---终止后回调事件
            CommonResponse<String> afterHasBpmBackResponse = updateBillStateUtils.afterHasBpmBack(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!afterHasBpmBackResponse.isSuccess()) {
                return afterHasBpmBackResponse;
            }
        }else if(ErrorTypeConfig.ABANDON_INITUSERCONTEXT.equals(vo.getType())){
            //弃审---获取上下文信息
            CommonResponse<String> beforeAbstainingResponse = updateBillStateUtils.beforeAbstainingProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!beforeAbstainingResponse.isSuccess()) {
                return CommonResponse.error("弃审前事件："+beforeAbstainingResponse.getMsg());
            }
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!back.isSuccess()){
                return CommonResponse.error("弃审修改单据状态事件："+back.getMsg());
            }
            CommonResponse<String> afterAbstainingResponse = updateBillStateUtils.afterAbstainingProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!afterAbstainingResponse.isSuccess()) {
                return CommonResponse.error("弃审后事件："+afterAbstainingResponse.getMsg());
            }

        }else if(ErrorTypeConfig.BEFOREABSTAINING.equals(vo.getType())){
            //弃审---终止前回调事件
            CommonResponse<String> beforeAbstainingResponse = updateBillStateUtils.beforeAbstainingProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!beforeAbstainingResponse.isSuccess()) {
                return beforeAbstainingResponse;
            }
        }else if(ErrorTypeConfig.ABANDON_UPDATEBILLSTATE.equals(vo.getType())){
            //弃审---修改单据状态
            CommonResponse<String> back = updateBillStateUtils.updateBillState(vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if(!back.isSuccess()){
                return back;
            }
        }else if(ErrorTypeConfig.AFTERABSTAINING.equals(vo.getType())){
            //弃审---终止后回调事件
            CommonResponse<String> afterAbstainingResponse = updateBillStateUtils.afterAbstainingProcessor(
                    vo.getBillId(), vo.getBillTypeCode(), BillState.UNCOMMITED_STATE);
            if (!afterAbstainingResponse.isSuccess()) {
                return afterAbstainingResponse;
            }
        }
        ErrorCallbackEntity entity = BeanMapper.map(vo, ErrorCallbackEntity.class);
        entity.setState("已处理");
        this.saveOrUpdate(entity, false);
        return CommonResponse.success();
    }

    @Override
    public IPage<ErrorCallbackVO> queryData(QueryParam queryParam) {
        Map<String, Parameter> params = queryParam.getParams();
        Map<String, Object> param = new HashMap<>();
        for(String key : params.keySet()){
            param.put(key, params.get(key).getValue());
        }
        IPage<ErrorCallbackVO> page = new Page<ErrorCallbackVO>();

        Long count = errorCallbackMapper.countData(param);
        if(count>=0){
            Integer pn = queryParam.getPageIndex();
            pn = pn - 1 < 0 ? 1 : pn;
            long startLine = (pn - 1) * queryParam.getPageSize();
            param.put("startLine", startLine);
            List<ErrorCallbackVO> list = errorCallbackMapper.pageData(param);
            page.setRecords(list);
        }
        page.setCurrent(queryParam.getPageIndex());
        page.setSize(queryParam.getPageSize());
        page.setTotal(count);
        return page;
    }
}
