package com.ejianc.zatopbpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.service.IBpmConfigService;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IZatopbpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.EncryptUtil;
import com.ejianc.zatopbpm.utils.GetBillDataUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import com.google.gson.Gson;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.*;

/**
 *
 * 
 * @author generator
 * 
 */
@Service("zatopbpmService")
public class ZatopbpmServiceImpl implements IZatopbpmService {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Value("${zatop.host.businessData:http://bpmtest.zatop.cn:8084}")
    private String zatopHostBusinessData;

    @Value("${zatop.host.startPage:http://bpmtest.zatop.cn:8080}")
    private String zatopHostStartPage;

    @Value("${zatop.signatureKey:366FB2D161CAE1BE920D5788BEAAFFE9}")
    private String signatureKey;

    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBpmConfigService configService;
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private GetBillDataUtil getBillDataUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;

    @Override
    public CommonResponse<String> dosumit(Map<String, Object> params) {
        Long billId = params.get("billId")!=null ? Long.parseLong(params.get("billId").toString()) : null;
        String fileSourceType = params.get("fileSourceType")!=null ? params.get("fileSourceType").toString() : null;
        String billTypeCode = params.get("billTypeCode")!=null ? params.get("billTypeCode").toString() : null;
        String pcurl = params.get("pcurl")!=null ? params.get("pcurl").toString() : null;
        String maurl = params.get("maurl")!=null ? params.get("maurl").toString() : null;
        Long orgId = params.get("orgId")!=null ? Long.parseLong(params.get("orgId").toString()) : null;
        String billCode = params.get("billCode")!=null ? params.get("billCode").toString() : null;
        String source = params.get("source")!=null ? params.get("source").toString() : null;
        //获取配置，若该单据类型配置启用，并且该组织在配置中，则走中奥审批

        Boolean flag = configService.queryByOrgAndBillType(orgId, billTypeCode);
        if(flag){
            if ("mobile".equals(source)){
                return CommonResponse.success("请在pc端提交","请在pc端提交");
            }
            JSONObject billData = getBillDataUtil.getBillData(billId, billTypeCode, fileSourceType );
            try {
                String bsid = "ejc";
                String userid = InvocationInfoProxy.getUsercode();
                String signature = EncryptUtil.aesEncrypt((bsid+"|"+userid+"|"+new Date().getTime()), signatureKey);
                String btid = billTypeCode;
                String boid = billId.toString();
                String orgcode = sessionManager.getUserContext().getOrgCode();
                CommonResponse<List<OrgVO>> orgResponse = orgApi.findParentsByOrgId(orgId);
                if(orgResponse.isSuccess() && orgResponse.getData()!=null && orgResponse.getData().size()>0){
                    for(OrgVO orgVO : orgResponse.getData()){
                        if(orgVO.getOrgType()!=5 && StringUtils.isNotBlank(orgVO.getSourceId())){
                            orgcode = orgVO.getSourceId();
                            break;
                        }
                    }
                }
                logger.info("发送单据信息给bpm：---------------"+billData.toJSONString());
                String paramterStr = gson.toJson(billData);
                String url = zatopHostBusinessData + "/apiCenter/businessData?bsid="+bsid+"&btid="+btid+"&boid="+boid+"&userid="+userid+"&orgcode="+orgcode+"&signature="+signature;
                logger.info("发送单据信息给bpm的url：---------------"+url);
                String result = ReferHttpClientUtils.postByJson(url, paramterStr);
                logger.info("发送单据信息给bpm返回的结果：---------------"+result);
                JSONObject jsonObject = JSONObject.parseObject(result);
                if(jsonObject.get("status")!=null && !"success".equals(jsonObject.get("status").toString())){
                    throw new BusinessException("单据推送失败！");
                }
                //获取这个单据的流程信息，若是存在，则根据状态判断是否是结束状态若是则新增一个
                QueryWrapper<BpmInfoEntity> wrapperBillId = new QueryWrapper<>();
                wrapperBillId.eq("dr", 0);
                wrapperBillId.eq("bill_type_code", billTypeCode);
                wrapperBillId.eq("bill_id", billId);
                wrapperBillId.orderByDesc("create_time");
                List<BpmInfoEntity> data = bpmInfoService.list(wrapperBillId);
                String billTypeName = "";
                CommonResponse<BillTypeVO> billTypeResponse = billTypeApi.getByCode(billTypeCode);
                if(billTypeResponse.isSuccess()) {
                    BillTypeVO billTypeVo = billTypeResponse.getData();
                    billTypeName = billTypeVo.getBillName();
                }
                BpmInfoEntity entity = new BpmInfoEntity();
                if(data!=null && data.size()>0){
                    if(StringUtils.isBlank(data.get(0).getType()) || "stop".equals(data.get(0).getType())){
                        entity = data.get(0);
                    }
                }
                entity.setBillId(billId);
                entity.setBillTypeCode(billTypeCode);
                entity.setBillTypeName(billTypeName);
                entity.setPcurl(pcurl);
                entity.setMaurl(maurl);
                entity.setOrgId(orgId);
                entity.setOrgSourceId(orgcode);
                entity.setUserCode(userid);
                entity.setUserId(InvocationInfoProxy.getUserid());
                entity.setUserName(sessionManager.getUserContext().getUserName());
                entity.setBillCode(billCode);
                bpmInfoService.saveOrUpdate(entity, false);
                String startUrl = zatopHostStartPage+"/Workflow/MTStart2.aspx?BSID="+bsid+"&BTID="+btid+"&BOID="+boid+"&UserID="+userid+"&signature="+signature;
                return CommonResponse.success("推送数据成功",startUrl);
            } catch (Exception e) {
                e.printStackTrace();
            }
        }else{
            if(InvocationInfoProxy.getExtendAttribute("authority")==null){
                HttpServletRequest request = ((ServletRequestAttributes) RequestContextHolder.getRequestAttributes()).getRequest();
                InvocationInfoProxy.setExtendAttribute("authority", request.getHeader("authority"));
            }
            logger.info("authority-----------------------{}",InvocationInfoProxy.getExtendAttribute("authority"));
            //走直审
            CommonResponse<String> approvalResponse = updateBillStateUtils.beforeSubmitProcessor(billId, billTypeCode, BillState.UNCOMMITED_STATE);
            logger.info("approvalResponse-----------------------"+JSONObject.toJSONString(approvalResponse));
            if (!approvalResponse.isSuccess()) {
                logger.error("单据终审回调前事件报错， 请检查对应服务是否正常！");
                throw new BusinessException(approvalResponse.getMsg());
            }
            //当根据的单据类型未查询到流程信息时，则该单据直审通过，直接修改单据状态
            CommonResponse<String> back = updateBillStateUtils.updateBillState(billId, billTypeCode, BillState.COMMITED_STATE);
            if(back.isSuccess()){
                CommonResponse<String> approvalAfterResponse = updateBillStateUtils.afterSubmitProcessor(billId, billTypeCode, BillState.APPROVING_UNEXAM_STATE);
                if (!approvalAfterResponse.isSuccess()) {
                    logger.error("单据终审回调后事件报错， 请检查对应服务是否正常！");
                    CommonResponse<String> resu = updateBillStateUtils.updateBillState(billId, billTypeCode, BillState.UNCOMMITED_STATE);
                    if(!resu.isSuccess()){
                        //为了预防第一次没有执行成功，故再执行一次
                        updateBillStateUtils.updateBillState(billId, billTypeCode, BillState.UNCOMMITED_STATE);
                    }
                    throw new BusinessException(approvalAfterResponse.getMsg());
                }
                return CommonResponse.success("直审成功","直审成功");
            }else{
                return CommonResponse.error(back.getMsg());
            }
        }

        return CommonResponse.error("启动流程失败");
    }

    @Override
    public CommonResponse<List<BpmInfoVO>> getHistory(Long billId) {
        List<BpmInfoVO> vos = new ArrayList<>();
        QueryWrapper<BpmInfoEntity> wrapperBillId = new QueryWrapper<>();
        wrapperBillId.eq("dr", 0);
        wrapperBillId.eq("bill_id", billId);
        wrapperBillId.orderByDesc("create_time");
        List<BpmInfoEntity> data = bpmInfoService.list(wrapperBillId);
        if(data!=null && data.size()>0){
            for (BpmInfoEntity entity : data){
                BpmInfoVO vo = BeanMapper.map(entity, BpmInfoVO.class);
                if(StringUtils.isNotBlank(vo.getZatopUrl())){
                    vo.setZatopUrl(vo.getZatopUrl()+"&lalunakey=MD5("+vo.getBpmId()+InvocationInfoProxy.getUsercode()+")");
                }
                vos.add(vo);
            }
        }
        return CommonResponse.success(vos);
    }
}
