package com.ejianc.zatopbpm.utils;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.framework.core.response.CommonResponse;
import com.google.gson.Gson;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@SuppressWarnings("unchecked")
@Component
public class InitUserContextUtil {

    // 日志
    private final Logger logger = LoggerFactory.getLogger(getClass());

    private Gson gson = new Gson();

    @Autowired
    private IUserApi userApi;

    public String initUserContext(String userSourceId) {
        StringBuilder authtoken = new StringBuilder();
        CommonResponse<JSONObject> userContextResponse = userApi.getUserContextBySourceId(userSourceId);
        if(userContextResponse.isSuccess()) {
            JSONObject userContext = userContextResponse.getData().getJSONObject("userContext");
            authtoken.append("userType=").append(userContext.get("userType"))
                    .append(";userCode=").append(userContext.get("userCode"))
                    .append(";orgId=").append(userContext.get("orgId"))
                    .append(";tenantid=").append(userContext.get("tenantid"))
                    .append(";token=").append(userContext.get("token"))
                    .append(";u_logints=").append(userContext.get("u_logints"))
                    .append(";u_usercode=").append(userContext.get("u_usercode"))
                    .append(";userId=").append(userContext.get("userId"));
        }else{
            authtoken.append(userContextResponse.getMsg());
        }

        return authtoken.toString();
    }
}
