/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.refer.util.ReferHttpClientUtils;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.service.IBpmConfigService;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IZatopbpmService;
import com.ejianc.zatopbpm.utils.BillState;
import com.ejianc.zatopbpm.utils.EncryptUtil;
import com.ejianc.zatopbpm.utils.GetBillDataUtil;
import com.ejianc.zatopbpm.utils.UpdateBillStateUtils;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Service(value="zatopbpmService")
public class ZatopbpmServiceImpl
implements IZatopbpmService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Value(value="${zatop.host.businessData:http://bpmtest.zatop.cn:8084}")
    private String zatopHostBusinessData;
    @Value(value="${zatop.host.startPage:http://bpmtest.zatop.cn:8080}")
    private String zatopHostStartPage;
    @Value(value="${zatop.signatureKey:366FB2D161CAE1BE920D5788BEAAFFE9}")
    private String signatureKey;
    @Autowired
    private IOrgApi orgApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBpmConfigService configService;
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private GetBillDataUtil getBillDataUtil;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private UpdateBillStateUtils updateBillStateUtils;

    @Override
    public CommonResponse<String> dosumit(Map<String, Object> params) {
        Long billId = params.get("billId") != null ? Long.valueOf(Long.parseLong(params.get("billId").toString())) : null;
        String fileSourceType = params.get("fileSourceType") != null ? params.get("fileSourceType").toString() : null;
        String billTypeCode = params.get("billTypeCode") != null ? params.get("billTypeCode").toString() : null;
        String pcurl = params.get("pcurl") != null ? params.get("pcurl").toString() : null;
        String maurl = params.get("maurl") != null ? params.get("maurl").toString() : null;
        Long orgId = params.get("orgId") != null ? Long.valueOf(Long.parseLong(params.get("orgId").toString())) : null;
        String billCode = params.get("billCode") != null ? params.get("billCode").toString() : null;
        String source = params.get("source") != null ? params.get("source").toString() : null;
        Boolean flag = this.configService.queryByOrgAndBillType(orgId, billTypeCode);
        if (flag.booleanValue()) {
            if ("mobile".equals(source)) {
                return CommonResponse.success((String)"\u8bf7\u5728pc\u7aef\u63d0\u4ea4", (Object)"\u8bf7\u5728pc\u7aef\u63d0\u4ea4");
            }
            JSONObject billData = this.getBillDataUtil.getBillData(billId, billTypeCode, fileSourceType);
            try {
                String bsid = "ejc";
                String userid = InvocationInfoProxy.getUsercode();
                String signature = EncryptUtil.aesEncrypt(bsid + "|" + userid + "|" + new Date().getTime(), this.signatureKey);
                String btid = billTypeCode;
                String boid = billId.toString();
                String orgcode = this.sessionManager.getUserContext().getOrgCode();
                CommonResponse orgResponse = this.orgApi.findParentsByOrgId(orgId);
                if (orgResponse.isSuccess() && orgResponse.getData() != null && ((List)orgResponse.getData()).size() > 0) {
                    for (OrgVO orgVO : (List)orgResponse.getData()) {
                        if (orgVO.getOrgType() == 5 || !StringUtils.isNotBlank((CharSequence)orgVO.getSourceId())) continue;
                        orgcode = orgVO.getSourceId();
                        break;
                    }
                }
                this.logger.info("\u53d1\u9001\u5355\u636e\u4fe1\u606f\u7ed9bpm\uff1a---------------" + billData.toJSONString());
                String paramterStr = this.gson.toJson((Object)billData);
                String url = this.zatopHostBusinessData + "/apiCenter/businessData?bsid=" + bsid + "&btid=" + btid + "&boid=" + boid + "&userid=" + userid + "&orgcode=" + orgcode + "&signature=" + signature;
                this.logger.info("\u53d1\u9001\u5355\u636e\u4fe1\u606f\u7ed9bpm\u7684url\uff1a---------------" + url);
                String result = ReferHttpClientUtils.postByJson((String)url, (String)paramterStr);
                this.logger.info("\u53d1\u9001\u5355\u636e\u4fe1\u606f\u7ed9bpm\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
                JSONObject jsonObject = JSONObject.parseObject((String)result);
                if (jsonObject.get((Object)"status") != null && !"success".equals(jsonObject.get((Object)"status").toString())) {
                    throw new BusinessException("\u5355\u636e\u63a8\u9001\u5931\u8d25\uff01");
                }
                QueryWrapper wrapperBillId = new QueryWrapper();
                wrapperBillId.eq((Object)"dr", (Object)0);
                wrapperBillId.eq((Object)"bill_type_code", (Object)billTypeCode);
                wrapperBillId.eq((Object)"bill_id", (Object)billId);
                wrapperBillId.orderByDesc((Object)"create_time");
                List data = this.bpmInfoService.list((Wrapper)wrapperBillId);
                String billTypeName = "";
                CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
                if (billTypeResponse.isSuccess()) {
                    BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
                    billTypeName = billTypeVo.getBillName();
                }
                BpmInfoEntity entity = new BpmInfoEntity();
                if (data != null && data.size() > 0 && (StringUtils.isBlank((CharSequence)((BpmInfoEntity)((Object)data.get(0))).getType()) || "stop".equals(((BpmInfoEntity)((Object)data.get(0))).getType()))) {
                    entity = (BpmInfoEntity)((Object)data.get(0));
                }
                entity.setBillId(billId);
                entity.setBillTypeCode(billTypeCode);
                entity.setBillTypeName(billTypeName);
                entity.setPcurl(pcurl);
                entity.setMaurl(maurl);
                entity.setOrgId(orgId);
                entity.setOrgSourceId(orgcode);
                entity.setUserCode(userid);
                entity.setUserId(InvocationInfoProxy.getUserid());
                entity.setUserName(this.sessionManager.getUserContext().getUserName());
                entity.setBillCode(billCode);
                this.bpmInfoService.saveOrUpdate((Object)entity, false);
                String startUrl = this.zatopHostStartPage + "/Workflow/MTStart2.aspx?BSID=" + bsid + "&BTID=" + btid + "&BOID=" + boid + "&UserID=" + userid + "&signature=" + signature;
                return CommonResponse.success((String)"\u63a8\u9001\u6570\u636e\u6210\u529f", (Object)startUrl);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            if (InvocationInfoProxy.getExtendAttribute((String)"authority") == null) {
                HttpServletRequest request = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                InvocationInfoProxy.setExtendAttribute((Object)"authority", (Object)request.getHeader("authority"));
            }
            this.logger.info("authority-----------------------{}", InvocationInfoProxy.getExtendAttribute((String)"authority"));
            CommonResponse<String> approvalResponse = this.updateBillStateUtils.beforeApprovalProcessor(billId, billTypeCode, BillState.UNCOMMITED_STATE);
            this.logger.info("approvalResponse-----------------------" + JSONObject.toJSONString(approvalResponse));
            if (!approvalResponse.isSuccess()) {
                this.logger.error("\u5355\u636e\u7ec8\u5ba1\u56de\u8c03\u524d\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
                throw new BusinessException(approvalResponse.getMsg());
            }
            CommonResponse<String> back = this.updateBillStateUtils.updateBillState(billId, billTypeCode, BillState.COMMITED_STATE);
            if (back.isSuccess()) {
                CommonResponse<String> approvalAfterResponse = this.updateBillStateUtils.afterApprovalProcessor(billId, billTypeCode, BillState.COMMITED_STATE);
                if (!approvalAfterResponse.isSuccess()) {
                    this.logger.error("\u5355\u636e\u7ec8\u5ba1\u56de\u8c03\u540e\u4e8b\u4ef6\u62a5\u9519\uff0c \u8bf7\u68c0\u67e5\u5bf9\u5e94\u670d\u52a1\u662f\u5426\u6b63\u5e38\uff01");
                    CommonResponse<String> resu = this.updateBillStateUtils.updateBillState(billId, billTypeCode, BillState.UNCOMMITED_STATE);
                    if (!resu.isSuccess()) {
                        this.updateBillStateUtils.updateBillState(billId, billTypeCode, BillState.UNCOMMITED_STATE);
                    }
                    throw new BusinessException(approvalAfterResponse.getMsg());
                }
                return CommonResponse.success((String)"\u76f4\u5ba1\u6210\u529f", (Object)"\u76f4\u5ba1\u6210\u529f");
            }
            return CommonResponse.error((String)back.getMsg());
        }
        return CommonResponse.error((String)"\u542f\u52a8\u6d41\u7a0b\u5931\u8d25");
    }

    @Override
    public CommonResponse<List<BpmInfoVO>> getHistory(Long billId) {
        ArrayList<BpmInfoVO> vos = new ArrayList<BpmInfoVO>();
        QueryWrapper wrapperBillId = new QueryWrapper();
        wrapperBillId.eq((Object)"dr", (Object)0);
        wrapperBillId.eq((Object)"bill_id", (Object)billId);
        wrapperBillId.isNotNull((Object)"bpm_id");
        wrapperBillId.orderByDesc((Object)"create_time");
        List data = this.bpmInfoService.list((Wrapper)wrapperBillId);
        if (data != null && data.size() > 0) {
            for (BpmInfoEntity entity : data) {
                BpmInfoVO vo = (BpmInfoVO)((Object)BeanMapper.map((Object)((Object)entity), BpmInfoVO.class));
                if (StringUtils.isNotBlank((CharSequence)vo.getZatopUrl())) {
                    vo.setZatopUrl(vo.getZatopUrl() + "&lalunakey=MD5(" + vo.getBpmId() + InvocationInfoProxy.getUsercode() + ")");
                }
                vos.add(vo);
            }
        }
        return CommonResponse.success(vos);
    }
}

