package com.ejianc.business.equipment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.consts.ZatopConstsUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;

@Service("ejc-equipment-web-purchaseSettlementZatop")
public class PurchaseSettlementZatopbpmServiceImpl extends CommonZatopDataDealService implements ICommonZatopBusinessService {

    private final Logger logger = LoggerFactory.getLogger(getClass());

    private static Map<String,String> purchaseTypeMap=new HashMap();
    private static Map<String,String> settlementTypeMap=new HashMap();
    static {
        purchaseTypeMap.put("1","是");
        purchaseTypeMap.put("2","否");
        settlementTypeMap.put("0","过程结算");
        settlementTypeMap.put("1","最终结算");
    }
    /**
     * 数据单独处理
     *
     * @param billId
     * @param billData 单据信息---从数据库中查询出来的信息
     * @return billData需要将单据信息+处理的信息返回
     */
    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        billData.put("purchaseType", purchaseTypeMap.get(billData.getString("purchaseType")));
        billData.put("settlementType", settlementTypeMap.get(billData.getString("settlementType")));
        logger.info("PurchaseSettlementZatopbpmServiceImpl-billData:{}", JSON.toJSONString(billData, SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue));
        return billData;
    }

    /**
     * 主表添加额外的表单中的字段
     *
     * @param billId
     * @param fields 主表信息集合---经过处理后的
     * @return fields 推送给第三方的最后数据,按格式返回
     * @return"fields": [
     *  {
     *  "id": "TITLE",
     *  "name": "流程主题",
     *  "value": "XXX 项目合同流程",
     *  "modifyStatus": ""
     *  },
     *  {
     *  "id": "ContractName",
     *  "name": "合同名称",
     *  "value": "XXX 项目合同",
     *  "modifyStatus": ""
     *  }
     *  ]
     */
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields){
        JSONObject field = new JSONObject();
        field.put("id", "ljjsbl");
        field.put("name", "累计结算比例");
        field.put("value",ComputeUtil.scaleTwo(ComputeUtil.safeDiv((BigDecimal) billData.get("sumSettlementTaxMny"),(BigDecimal) billData.get("contractTaxMny"))));
        fields.add(field);
        JSONObject field1 = new JSONObject();
        field1.put("id", "symny");
        field1.put("name", "剩余可冲抵金额");
        field1.put("value",ComputeUtil.scaleTwo(ComputeUtil.safeSub((BigDecimal) billData.get("sumPrepayMny"),(BigDecimal) billData.get("sumOffsetMny"))));
        fields.add(field1);
        JSONObject field2 = new JSONObject();
        field2.put("id", "containSumSettlementTaxMny");
        field2.put("name", "含本期已结算累计金额");
        field2.put("value",ComputeUtil.scaleTwo(ComputeUtil.safeAdd((BigDecimal) billData.get("sumSettlementTaxMny"),(BigDecimal) billData.get("settlementTaxMny"))));
        fields.add(field2);
        return fields;
    }

    /**
     * 子表数据库数据单独处理----子表多个时会遍历循环此方法
     *
     * @param billId
     * @param entityName 子表实体名
     * @param childrenData 单据子表信息---从数据库中查询出来的信息，一个子表的
     * @return billData需要将单据信息+处理的信息返回
     * @return
     */
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData){
        return childrenData;
    }

    /**
     * 子表数据单独处理
     *
     * @param billId
     * @param lists  子表信息集合---经过处理后的
     * @return lists 推送给第三方的最后数据,按格式返回
     * @return "lists": [[
     * {
     * "listId": "ContractPaymentDetail",
     * "listName": "合同付款比例明细",
     * "items": [
     * {
     * "id": "FKBL",
     * "name": "付款比例",
     * "value": "30%",
     * "modifyStatus": ""
     * },
     * {
     * "id": "FKBL",
     * "name": "付款比例",
     * "value": "30%",
     * "modifyStatus": ""
     * },
     * {
     * "id": "FKBL",
     * "name": "付款比例",
     * "value": "30%",
     * "modifyStatus": ""
     * }
     * ]
     * }
     * ]]]
     */
    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    /**
     * 主表数据单独处理
     *
     * @param billId
     * @param sourceType 附件类型
     * @param attachments 单据附件信息---经过处理后的
     * @return attachments 推送给第三方的最后数据,按格式返回
     * @return "attachments": [
     * {
     * "fileId": "92535855-A661-E911-80BD-90E2BABD62D1",
     * "fileName": "【打印 3 份】南京公司-璞樾钟山-大区除 24 号楼家用除霾新风设备采购合同.docx",
     * "fileType": "合同登记",
     * "fileUrl": "http:/",
     * "uploadUserId":"kook.zhang",
     * "uploadUserName":"张亮",
     * "modifyStatus":""
     * }]
     */
    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        return attachments;
    }

}
