/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.finance;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.consts.ZatopConstsUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ejc-finance-web-payContractZatop")
public class PayContractZatopbpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, String> contractTypeMap = new HashMap<String, String>();
    private static Map<String, String> purchaseTypeMap = new HashMap<String, String>();
    private static Map<String, String> paymentTypeMap = new HashMap<String, String>();
    private static Map<String, String> projectTypeMap = new HashMap<String, String>();
    private static Map<String, String> feeTypeMap = new HashMap<String, String>();
    private static Map<String, String> invoiceFlagMap = new HashMap<String, String>();

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        billData.put("contractType", (Object)contractTypeMap.get(billData.getString("contractType")));
        billData.put("purchaseType", (Object)purchaseTypeMap.get(billData.getString("purchaseType")));
        billData.put("dependOnProject", (Object)ZatopConstsUtil.getYesOrNoName(billData.getString("dependOnProject")));
        billData.put("paymentType", (Object)paymentTypeMap.get(billData.getString("paymentType")));
        billData.put("projectType", (Object)projectTypeMap.get(billData.getString("projectType")));
        billData.put("feeType", (Object)feeTypeMap.get(billData.getString("feeType")));
        this.logger.info("PayContractZatopbpmServiceImpl-billData:{}", (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        JSONObject field = new JSONObject();
        field.put("id", (Object)"settledUnPayMny");
        field.put("name", (Object)"\u5df2\u7ed3\u7b97\u672a\u4ed8\u6b3e\u91d1\u989d");
        field.put("value", (Object)ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)((BigDecimal)billData.get((Object)"sumSettleMny")), (BigDecimal)((BigDecimal)billData.get((Object)"sumPayMny")))));
        fields.add((Object)field);
        JSONObject field1 = new JSONObject();
        field1.put("id", (Object)"invoiceFlagName");
        field1.put("name", (Object)"\u662f\u5426\u6709\u53d1\u7968");
        field1.put("value", (Object)invoiceFlagMap.get(billData.getString("invoiceFlag")));
        fields.add((Object)field1);
        return this.addFieldsForBillData(billId, billData, fields);
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        return attachments;
    }

    static {
        contractTypeMap.put("1", "\u5206\u5305");
        contractTypeMap.put("2", "\u8bbe\u5907\u91c7\u8d2d");
        contractTypeMap.put("3", "\u8bbe\u5907\u79df\u8d41");
        contractTypeMap.put("4", "\u7269\u8d44\u91c7\u8d2d");
        contractTypeMap.put("5", "\u5468\u8f6c\u6750\u79df\u8d41");
        contractTypeMap.put("6", "\u5176\u4ed6\u652f\u51fa");
        purchaseTypeMap.put("1", "\u81ea\u91c7");
        purchaseTypeMap.put("2", "\u96c6\u91c7");
        paymentTypeMap.put("1", "\u4fdd\u6e29");
        paymentTypeMap.put("2", "\u9970\u9762");
        paymentTypeMap.put("3", "\u81ea\u6709\u52b3\u52a1");
        paymentTypeMap.put("4", "\u5de5\u4e1a\u4e8b\u4e1a\u90e8");
        paymentTypeMap.put("5", "\u5e55\u5899\u4e8b\u4e1a\u90e8");
        projectTypeMap.put("1", "\u81ea\u8425");
        projectTypeMap.put("2", "\u8054\u8425");
        feeTypeMap.put("1", "\u9884\u4ed8\u6b3e");
        feeTypeMap.put("2", "\u8fc7\u7a0b\u6b3e");
        feeTypeMap.put("3", "\u5176\u4ed6");
        invoiceFlagMap.put("1", "\u6709");
        invoiceFlagMap.put("2", "\u6ca1\u6709");
        invoiceFlagMap.put("3", "\u4e0d\u786e\u5b9a");
    }
}

