/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supplier;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ejc-support-web-investigateZatop")
public class InvestigateBpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private EnvironmentTools environmentTools;

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        this.logger.info("{}-billData:{}", (Object)this.getClass().getName(), (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        return this.addFieldsForBillData(billId, billData, fields);
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        attachments = new JSONArray();
        CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(billId, null, null, null);
        if (attachmentResponse.isSuccess() && attachmentResponse.getData() != null && ((List)attachmentResponse.getData()).size() > 0) {
            for (AttachmentVO attachmentVO : (List)attachmentResponse.getData()) {
                JSONObject attachment = new JSONObject();
                attachment.put("fileName", (Object)attachmentVO.getFileName());
                attachment.put("fileId", (Object)attachmentVO.getId());
                String fileType = "";
                if (attachmentVO.getFileName().contains(".")) {
                    fileType = attachmentVO.getFileName().split("\\.")[1];
                }
                attachment.put("fileType", (Object)fileType);
                String fileUrl = this.environmentTools.getBaseHost() + "ejc-file-web/attachment/filePreview?fileId=" + attachmentVO.getId();
                attachment.put("uploadUserId", (Object)attachmentVO.getCreateUserCode());
                attachment.put("fileUrl", (Object)fileUrl);
                attachment.put("uploadUserName", (Object)attachmentVO.getCreateUserName());
                attachments.add((Object)attachment);
            }
        }
        return attachments;
    }
}

