/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.mq.consumer;

import com.alibaba.fastjson.JSONObject;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.bean.ErrorCallbackEntity;
import com.ejianc.zatopbpm.mq.consumer.ZatopBaseConsumer;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.service.IErrorCallbackService;
import com.ejianc.zatopbpm.service.bpmEvent.IAbandonBpmService;
import com.ejianc.zatopbpm.service.bpmEvent.IApproveBpmService;
import com.ejianc.zatopbpm.service.bpmEvent.IFinishBpmService;
import com.ejianc.zatopbpm.service.bpmEvent.IStartBpmService;
import com.ejianc.zatopbpm.service.bpmEvent.IStopBpmService;
import com.ejianc.zatopbpm.utils.BillTypeCodeUtil;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class ZatopMessageCommonListener
extends ZatopBaseConsumer {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IStartBpmService startBpmService;
    @Autowired
    private IBpmInfoService bpmInfoService;
    @Autowired
    private IAbandonBpmService abandonBpmService;
    @Autowired
    private IApproveBpmService approveBpmService;
    @Autowired
    private IFinishBpmService finishBpmService;
    @Autowired
    private IStopBpmService stopBpmService;
    @Autowired
    private IErrorCallbackService errorCallbackService;
    @Value(value="${zatop.rabbitmq.queue:ejc-test.instance.action.type}")
    private String queue;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    protected void doConsumeMsg(JSONObject data) {
        try {
            String action;
            String type = data.getString("type");
            String billTypeCode = data.getString("btid");
            String billId = data.getString("boid");
            String bpmId = data.getString("instanceid");
            String userid = data.getString("userid");
            String bpmdata = data.getString("data");
            HashMap<String, Object> param = new HashMap<String, Object>();
            billTypeCode = BillTypeCodeUtil.toBillTypeCode(billTypeCode);
            if ("createResult".equals(type)) {
                JSONObject createResult = JSONObject.parseObject((String)bpmdata);
                JSONObject createResultData = JSONObject.parseObject((String)createResult.getString("createResultData"));
                String status = createResultData.getString("status");
                String url = createResultData.getString("url");
                if ("success".equals(status)) {
                    param.put("type", type);
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", userid);
                    param.put("zatopUrl", url);
                    this.startBpmService.startBpm(param);
                    return;
                }
                ErrorCallbackEntity entity = new ErrorCallbackEntity(Long.parseLong(billId), billTypeCode, "startzatopbpm", userid, null, "\u6d41\u7a0b\u53d1\u8d77\u5931\u8d25\uff01", bpmId);
                this.errorCallbackService.saveOrUpdate((Object)entity, false);
                return;
            }
            if ("audit".equals(type)) {
                JSONObject audit = JSONObject.parseObject((String)bpmdata);
                JSONObject auditData = JSONObject.parseObject((String)audit.getString("auditData"));
                action = auditData.getString("action");
                String stepName = auditData.getString("stepName");
                if ("rejectStart".equals(action) || "recall".equals(action)) {
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("type", "stop");
                    param.put("userid", userid);
                    this.stopBpmService.stopBpm(param);
                    return;
                }
                if ("approve".equals(action)) {
                    param.put("stepName", stepName);
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", userid);
                    this.approveBpmService.approveBpm(param);
                    return;
                }
            } else {
                if (!"approveClose".equals(type)) return;
                JSONObject approveClose = JSONObject.parseObject((String)bpmdata);
                JSONObject approveCloseData = JSONObject.parseObject((String)approveClose.getString("approveCloseData"));
                String status = approveCloseData.getString("status");
                if ("rejected".equals(status)) {
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("type", "rejected");
                    param.put("userid", userid);
                    this.stopBpmService.stopBpm(param);
                    return;
                }
                if ("approved".equals(status)) {
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", userid);
                    this.finishBpmService.finishBpm(param);
                    return;
                }
                if (!"canceled".equals(status)) return;
                BpmInfoEntity infoEntity = this.bpmInfoService.selectByBpmId(bpmId);
                if ("approving".equals(infoEntity.getType())) {
                    param.put("billTypeCode", billTypeCode);
                    param.put("billId", billId);
                    param.put("bpmId", bpmId);
                    param.put("userid", userid);
                    param.put("type", "rejected");
                    this.stopBpmService.stopBpm(param);
                    return;
                }
                if (!"finish".equals(infoEntity.getType())) return;
                param.put("billTypeCode", billTypeCode);
                param.put("billId", billId);
                param.put("bpmId", bpmId);
                param.put("userid", userid);
                this.abandonBpmService.abandonBpm(param);
                return;
            }
            if (!"rejectStep".equals(action)) return;
            return;
        }
        catch (Exception e) {
            this.logger.error("\u76d1\u542c\u6d88\u606f\u5f02\u5e38: ", (Throwable)e);
        }
    }

    @Override
    protected String[] getQueueNames() {
        return new String[]{this.queue};
    }
}

