/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.bidprice;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.consts.ZatopConstsUtil;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ejc-bidprice-web-materialPicketageZatop")
public class MaterialPicketageZatopbpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        this.logger.info("{}-billData11:{}", (Object)this.getClass().getName(), (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        billData.put("pricingType", (Object)ZatopConstsUtil.getPricingTypeName(billData.getString("pricingType")));
        String purchaseType = billData.getString("purchaseType");
        purchaseType = "1".equals(purchaseType) ? "2" : "1";
        String quotationAuthority = billData.getString("quotationAuthority");
        billData.put("purchaseType", (Object)ZatopConstsUtil.getPurchaseModeName(purchaseType));
        billData.put("quotationAuthority", (Object)ZatopConstsUtil.getQuotationAuthorityName(quotationAuthority));
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        billData.put("handleDate", (Object)sdf.format(billData.getDate("handleDate")));
        this.logger.info("{}-billData:{}", (Object)this.getClass().getName(), (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        return this.addFieldsForBillData(billId, billData, fields);
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        if (entityName.contains("MaterialPicketageQuoteEntity") && childrenData != null && childrenData.size() > 0) {
            for (int i = 0; i < childrenData.size(); ++i) {
                JSONObject obj = childrenData.getJSONObject(i);
                String bidFlag = obj.getString("bidFlag");
                bidFlag = "1".equals(bidFlag) ? "\u662f" : "\u5426";
                obj.put("bidFlag", (Object)bidFlag);
            }
        }
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        return attachments;
    }
}

