/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.equipment;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.consts.ZatopConstsUtil;
import com.ejianc.framework.core.util.ComputeUtil;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ejc-equipment-web-purchaseChangeZatop")
public class PurchaseChangeZatopbpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static Map<String, String> purchaseTypeMap = new HashMap<String, String>();

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        billData.put("purchaseType", (Object)purchaseTypeMap.get(billData.getString("purchaseType")));
        billData.put("contractStatus", (Object)ZatopConstsUtil.getContractStateName(billData.getString("contractStatus")));
        this.logger.info("PurchaseChangeZatopbpmServiceImpl-billData:{}", (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        JSONObject field = new JSONObject();
        field.put("id", (Object)"bb");
        field.put("name", (Object)"\u672c\u6b21\u53d8\u66f4\u91d1\u989d");
        BigDecimal contractTaxMny = billData.getString("contractTaxMny") == null ? BigDecimal.ZERO : (BigDecimal)billData.get((Object)"contractTaxMny");
        BigDecimal beforeChangeTaxMny = billData.getString("beforeChangeTaxMny") == null ? BigDecimal.ZERO : (BigDecimal)billData.get((Object)"beforeChangeTaxMny");
        BigDecimal bb = ComputeUtil.scaleTwo((BigDecimal)ComputeUtil.safeSub((BigDecimal)contractTaxMny, (BigDecimal)beforeChangeTaxMny));
        field.put("value", (Object)bb);
        fields.add((Object)field);
        JSONObject field1 = new JSONObject();
        field1.put("id", (Object)"scale");
        field1.put("name", (Object)"\u672c\u6b21\u53d8\u66f4\u5360\u539f\u5408\u540c\u6bd4\u4f8b%");
        field1.put("value", (Object)(beforeChangeTaxMny.compareTo(BigDecimal.ZERO) != 0 ? ComputeUtil.bigDecimalPercent((BigDecimal)bb, (BigDecimal)beforeChangeTaxMny, (int)2) : BigDecimal.ZERO));
        fields.add((Object)field1);
        return fields;
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        return attachments;
    }

    static {
        purchaseTypeMap.put("1", "\u662f");
        purchaseTypeMap.put("2", "\u5426");
    }
}

