/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.supplier;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ejianc.business.common.CommonZatopDataDealService;
import com.ejianc.business.market.vo.SupplierCooperateVO;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.file.vo.AttachmentVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.zatopbpm.service.common.ICommonZatopBusinessService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="ejc-support-web-estimateZatop")
public class EstimateBpmServiceImpl
extends CommonZatopDataDealService
implements ICommonZatopBusinessService {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IAttachmentApi attachmentApi;
    @Autowired
    private EnvironmentTools environmentTools;
    private static final String INDEX_NAME_PAY_CONTRACT = "pay_contract";
    @Autowired(required=false)
    private RestHighLevelClient client;
    private static final Integer QUERY_TIMEOUT = 60;

    @Override
    public JSONObject dealBillData(Long billId, JSONObject billData) {
        this.logger.info("{}-billData:{}", (Object)this.getClass().getName(), (Object)JSON.toJSONString((Object)billData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.PrettyFormat, SerializerFeature.WriteMapNullValue}));
        List supplierIds = Lists.asList((Object)billData.getLong("supplierId"), (Object[])new Long[0]);
        Map<Long, List<SupplierCooperateVO>> map = this.querySupplierCooperate(supplierIds);
        if (map != null && map.get(billData.getLong("supplierId")) != null) {
            List<SupplierCooperateVO> supplierCooperateVOS = map.get(billData.getLong("supplierId"));
            billData.put("cooperateVOS", supplierCooperateVOS);
        }
        return billData;
    }

    @Override
    public JSONArray addFields(Long billId, JSONObject billData, JSONArray fields) {
        return this.addFieldsForBillData(billId, billData, fields);
    }

    @Override
    public JSONArray dealBillchldrenData(Long billId, String entityName, JSONArray childrenData) {
        return childrenData;
    }

    @Override
    public JSONArray dealBillChildrenData(Long billId, JSONArray lists) {
        return lists;
    }

    @Override
    public JSONArray dealBillAttachmentsData(Long billId, String billTypeCode, String sourceType, JSONArray attachments) {
        attachments = new JSONArray();
        CommonResponse attachmentResponse = this.attachmentApi.queryListBySourceId(billId, null, null, null);
        if (attachmentResponse.isSuccess() && attachmentResponse.getData() != null && ((List)attachmentResponse.getData()).size() > 0) {
            for (AttachmentVO attachmentVO : (List)attachmentResponse.getData()) {
                JSONObject attachment = new JSONObject();
                attachment.put("fileName", (Object)attachmentVO.getFileName());
                attachment.put("fileId", (Object)attachmentVO.getId());
                String fileType = "";
                if (attachmentVO.getFileName().contains(".")) {
                    fileType = attachmentVO.getFileName().split("\\.")[1];
                }
                attachment.put("fileType", (Object)fileType);
                String fileUrl = this.environmentTools.getBaseHost() + "ejc-file-web/attachment/filePreview?fileId=" + attachmentVO.getId();
                attachment.put("uploadUserId", (Object)attachmentVO.getCreateUserCode());
                attachment.put("fileUrl", (Object)fileUrl);
                attachment.put("uploadUserName", (Object)attachmentVO.getCreateUserName());
                attachments.add((Object)attachment);
            }
        }
        return attachments;
    }

    public Map<Long, List<SupplierCooperateVO>> querySupplierCooperate(List<Long> supplierIds) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.must((QueryBuilder)QueryBuilders.termsQuery((String)"supplierId", supplierIds));
        boolQuery.must((QueryBuilder)QueryBuilders.termQuery((String)"tenantId", (String)InvocationInfoProxy.getTenantid().toString()));
        SearchRequest searchRequest = new SearchRequest(new String[]{INDEX_NAME_PAY_CONTRACT});
        SearchSourceBuilder sourceBuilder = new SearchSourceBuilder();
        sourceBuilder.trackTotalHits(true);
        sourceBuilder.query((QueryBuilder)boolQuery);
        sourceBuilder.timeout(new TimeValue((long)QUERY_TIMEOUT.intValue(), TimeUnit.SECONDS));
        searchRequest.source(sourceBuilder);
        Map<Long, List<SupplierCooperateVO>> map = new HashMap<Long, List<SupplierCooperateVO>>();
        ArrayList<Object> list = new ArrayList<Object>();
        SearchResponse response = null;
        try {
            response = this.client.search(searchRequest, RequestOptions.DEFAULT);
            SearchHits hits = response.getHits();
            for (SearchHit hit : hits) {
                String sourceAsString = hit.getSourceAsString();
                list.add(JSON.parseObject((String)sourceAsString, SupplierCooperateVO.class));
            }
            map = list.stream().collect(Collectors.groupingBy(SupplierCooperateVO::getSupplierId));
        }
        catch (IOException e) {
            this.logger.error("\u67e5\u8be2\u5386\u53f2\u4e1a\u7ee9\u5931\u8d25\uff01", (Throwable)e);
            e.printStackTrace();
        }
        return map;
    }
}

