/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.controller;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IModuleApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.zatopbpm.bean.BpmInfoEntity;
import com.ejianc.zatopbpm.service.IBpmInfoService;
import com.ejianc.zatopbpm.vo.BpmInfoVO;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"bpmInfo"})
public class BpmInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBpmInfoService service;
    @Autowired
    private IModuleApi moduleApi;
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IUserApi userApi;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<BpmInfoVO> queryDetail(Long id) {
        BpmInfoEntity entity = (BpmInfoEntity)((Object)this.service.selectById(id));
        BpmInfoVO vo = (BpmInfoVO)((Object)BeanMapper.map((Object)((Object)entity), BpmInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<BpmInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("type", new Parameter("ne", null));
        if (param.getParams().get("moduleId") != null) {
            ArrayList<String> billTypeCodes = new ArrayList<String>();
            CommonResponse moduleResponse = this.billTypeApi.queryAllBillTypeByModuleId(Long.valueOf(Long.parseLong(((Parameter)param.getParams().get("moduleId")).getValue().toString())));
            if (moduleResponse.isSuccess()) {
                List modules = (List)moduleResponse.getData();
                for (int i = 0; i < modules.size(); ++i) {
                    billTypeCodes.add(((BillTypeVO)modules.get(i)).getBillCode());
                }
            }
            param.getParams().remove("moduleId");
            if (billTypeCodes != null && billTypeCodes.size() > 0) {
                param.getParams().put("billTypeCode", new Parameter("in", billTypeCodes));
            }
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), BpmInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @RequestMapping(value={"/regainFree"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> regainFree(@RequestBody BpmInfoVO vo) {
        return this.service.regainFree(vo);
    }
}

