/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.zatopbpm.bean.BpmConfigEntity;
import com.ejianc.zatopbpm.bean.BpmOrgRelationEntity;
import com.ejianc.zatopbpm.mapper.BpmConfigMapper;
import com.ejianc.zatopbpm.service.IBpmConfigService;
import com.ejianc.zatopbpm.service.IBpmOrgRelationService;
import com.ejianc.zatopbpm.vo.BpmConfigVO;
import com.ejianc.zatopbpm.vo.BpmOrgRelationVO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="bpmConfigService")
public class BpmConfigServiceImpl
extends BaseServiceImpl<BpmConfigMapper, BpmConfigEntity>
implements IBpmConfigService {
    @Autowired
    private IBpmOrgRelationService orgRelationService;
    @Autowired
    private IOrgApi orgApi;

    @Override
    public CommonResponse<BpmConfigVO> saveData(BpmConfigVO vo) {
        if (vo.getBillTypeId() == null) {
            throw new BusinessException("\u7f3a\u5c11\u5355\u636e\u7c7b\u578b");
        }
        if (vo.getId() == null) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"bill_type_id", (Object)vo.getBillTypeId());
            List list = this.list((Wrapper)wrapper);
            if (list != null && list.size() > 0) {
                throw new BusinessException("\u8be5\u5355\u636e\u7c7b\u578b\u5df2\u5b58\u5728\u914d\u7f6e");
            }
        }
        BpmConfigEntity entity = (BpmConfigEntity)((Object)BeanMapper.map((Object)((Object)vo), BpmConfigEntity.class));
        this.saveOrUpdate((Object)entity, false);
        List<BpmOrgRelationVO> relations = vo.getRelationList();
        ArrayList<BpmOrgRelationEntity> relationEntitys = new ArrayList<BpmOrgRelationEntity>();
        ArrayList<Long> delattributosIds = new ArrayList<Long>();
        for (BpmOrgRelationVO rvo : relations) {
            BpmOrgRelationEntity en;
            if (StringUtils.isNotBlank((CharSequence)rvo.getRowState()) && rvo.getRowState().equals("add")) {
                en = (BpmOrgRelationEntity)((Object)BeanMapper.map((Object)((Object)rvo), BpmOrgRelationEntity.class));
                en.setConfigId(entity.getId());
                en.setDr(0);
                relationEntitys.add(en);
            }
            if (StringUtils.isNotBlank((CharSequence)rvo.getRowState()) && rvo.getRowState().equals("edit")) {
                en = (BpmOrgRelationEntity)((Object)BeanMapper.map((Object)((Object)rvo), BpmOrgRelationEntity.class));
                relationEntitys.add(en);
            }
            if (!StringUtils.isNotBlank((CharSequence)rvo.getRowState()) || !rvo.getRowState().equals("del")) continue;
            delattributosIds.add(rvo.getId());
        }
        if (relationEntitys.size() > 0) {
            this.orgRelationService.saveOrUpdateBatch(relationEntitys, relationEntitys.size(), false);
        }
        if (delattributosIds.size() > 0) {
            this.orgRelationService.removeByIds(delattributosIds, false);
        }
        vo = (BpmConfigVO)((Object)BeanMapper.map((Object)((Object)entity), BpmConfigVO.class));
        return CommonResponse.success((Object)((Object)vo));
    }

    @Override
    public CommonResponse<String> deleteVOs(List<BpmConfigVO> vos) {
        ArrayList<Long> ids = new ArrayList<Long>();
        if (ListUtil.isNotEmpty(vos)) {
            for (BpmConfigVO vo : vos) {
                ids.add(vo.getId());
            }
        }
        this.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        this.orgRelationService.delete(ids);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @Override
    public Boolean queryByOrgAndBillType(Long orgId, String billTypeCode) {
        HashMap checkMap = new HashMap();
        Boolean flag = false;
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"bill_type_code", (Object)billTypeCode);
        List list = this.list((Wrapper)wrapper);
        if (list != null && list.size() > 0 && ((BpmConfigEntity)((Object)list.get(0))).getState().booleanValue()) {
            CommonResponse org = this.orgApi.getOneById(orgId);
            OrgVO orgVO = new OrgVO();
            if (org.isSuccess()) {
                if (org.getData() == null) {
                    throw new BusinessException("\u672a\u67e5\u8be2\u5230\u6240\u5c5e\u7ec4\u7ec7\u8be6\u60c5\u4fe1\u606f");
                }
            } else {
                throw new BusinessException("\u7f51\u7edc\u9519\u8bef\uff0c\u67e5\u8be2\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25");
            }
            orgVO = (OrgVO)org.getData();
            QueryWrapper orgwrapper = new QueryWrapper();
            orgwrapper.eq((Object)"config_id", (Object)((BpmConfigEntity)((Object)list.get(0))).getId());
            List<BpmOrgRelationEntity> orglist = this.orgRelationService.querylist((QueryWrapper<BpmOrgRelationEntity>)orgwrapper);
            for (BpmOrgRelationEntity vo : orglist) {
                if ("self".equals(vo.getRange())) {
                    flag = true;
                    break;
                }
                if (!"down".equals(vo.getRange()) || !orgVO.getInnerCode().contains(vo.getOrgId().toString())) continue;
                flag = true;
                break;
            }
        }
        return flag;
    }
}

