/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.zatopbpm.utils;

import com.ejianc.foundation.metadata.api.IMdApi;
import com.ejianc.foundation.metadata.vo.MdReferVO;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillTypeVO;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.EnvironmentTools;
import com.ejianc.zatopbpm.utils.ReferHttpClientUtils;
import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UpdateBillStateUtils {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Gson gson = new Gson();
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IMdApi mdApi;
    @Autowired
    private CacheManager cacheManager;
    @Autowired
    private EnvironmentTools environmentTools;

    public CommonResponse<String> updateBillState(Long billId, String billType, Integer billState) {
        this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billType:" + billType + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billType);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billType + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u72b6\u6001\u66f4\u6539\u5931\u8d25");
        }
        HashMap<String, String> paramterMap = new HashMap<String, String>();
        paramterMap.put("billId", String.valueOf(billId));
        paramterMap.put("tableName", referVo.getTableName());
        paramterMap.put("billState", String.valueOf(billState));
        this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u4f20\u9012\u7684\u53c2\u6570\uff1a---------------" + ((Object)paramterMap).toString());
        String paramterStr = this.gson.toJson(paramterMap);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/commonstate/updateBillState";
        this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u4f20\u9012\u7684url\uff1a---------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            this.logger.info("\u4fee\u6539\u5355\u636e\u72b6\u6001\u8fd4\u56de\u7684\u7ed3\u679c\uff1a---------------" + result);
            return (CommonResponse)this.gson.fromJson(result, CommonResponse.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u72b6\u6001\u66f4\u6539\u5931\u8d25");
        }
    }

    public CommonResponse<String> beforeSubmitProcessor(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u63d0\u4ea4\u524d\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billType:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeSubmit";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            this.logger.info("result-----------------------" + result);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> afterSubmitProcessor(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u63d0\u4ea4\u540e\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billType:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterSubmit";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> beforeHasBpmBack(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u524d\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billTypeCode:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeHasBpmBack";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            this.logger.info("\u8c03\u7528result-----------------------" + result);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> afterHasBpmBack(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u6709\u5ba1\u6279\u6d41\u7684\u64a4\u56de\u540e\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billTypeCode:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterHasBpmBack";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> beforeInApprovalBack(Long billId, String billTypeCode, Integer billState, String sign) {
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u524d\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billTypeCode:" + billTypeCode + "billState:" + billState + ",sign:" + sign);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        paramterMap.put("sign", sign);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeInApprovalBack";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> afterInApprovalBack(Long billId, String billTypeCode, Integer billState, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        this.logger.info("\u5ba1\u6279\u8282\u70b9\u5ba1\u6279\u4e2d\u65f6\u8282\u70b9\u5ba1\u6279\u540e\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + ",billType:" + billTypeCode + ",billState:" + billState + ",taskId:" + taskId + ",isEnd:" + isEnd + ",sign:" + sign);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        paramterMap.put("taskId", taskId);
        paramterMap.put("isEnd", isEnd);
        paramterMap.put("sign", sign);
        paramterMap.put("other", other);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterInApprovalBack";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> beforeApprovalProcessor(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u7ec8\u5ba1\u524d\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billType:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeApproval";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> afterApprovalProcessor(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u7ec8\u5ba1\u540e\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billType:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterApproval";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> beforeAbstainingProcessor(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u5f03\u5ba1\u524d\u4e8b\u4ef6\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billTypeCode:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/beforeAbstaining";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5355\u636e\u4fe1\u606f\u67e5\u8be2\u5931\u8d25");
        }
    }

    public CommonResponse<String> afterAbstainingProcessor(Long billId, String billTypeCode, Integer billState) {
        this.logger.info("\u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03api\u5f00\u59cb\u53c2\u6570\uff1a------billId\uff1a" + billId + "billTypeCode:" + billTypeCode + "billState:" + billState);
        MdReferVO referVo = this.getMdByTypeCode(billTypeCode);
        if (referVo == null) {
            this.logger.info("\u6839\u636e\u5355\u636e\u7c7b\u578bcode\uff1a" + billTypeCode + "\u67e5\u8be2\u83b7\u53d6\u5143\u6570\u636e\u5931\u8d25:");
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
        HashMap<String, Object> paramterMap = new HashMap<String, Object>();
        paramterMap.put("billId", billId);
        paramterMap.put("billState", billState);
        paramterMap.put("metadataId", referVo.getMetadataId());
        paramterMap.put("billTypeCode", billTypeCode);
        String paramterStr = this.gson.toJson(paramterMap);
        this.logger.info("\u8c03\u7528rest\u5f00\u59cb-----------------------");
        this.logger.info("\u8c03\u7528rest\u53c2\u6570-----------------------" + paramterStr);
        String url = this.environmentTools.getBaseHost() + referVo.getProjectName() + "/common/business/afterAbstaining";
        this.logger.info("\u8c03\u7528restUrl-----------------------" + url);
        try {
            String result = ReferHttpClientUtils.postByJson(url, paramterStr);
            return (CommonResponse)this.gson.fromJson(result, new TypeToken<CommonResponse<String>>(){}.getType());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.logger.info("\u8c03\u7528result\u9519\u8bef\u4fe1\u606f--------------{}", (Throwable)e);
            return CommonResponse.error((String)"\u7f51\u7edc\u5f02\u5e38\uff0c \u5f03\u5ba1\u540e\u4e8b\u4ef6\u56de\u8c03\u5931\u8d25");
        }
    }

    public MdReferVO getMdByTypeCode(String billTypeCode) {
        MdReferVO vo = new MdReferVO();
        String key = "btc-md-" + billTypeCode;
        if (this.cacheManager.get(key) != null) {
            vo = (MdReferVO)this.cacheManager.get(key);
        } else {
            CommonResponse billTypeResponse = this.billTypeApi.getByCode(billTypeCode);
            if (billTypeResponse.isSuccess()) {
                BillTypeVO billTypeVo = (BillTypeVO)billTypeResponse.getData();
                this.logger.info("\u8c03\u7528\u5143\u6570\u636eapi\u53c2\u6570\uff1a---------------" + billTypeVo.getMetadataId());
                if (billTypeVo.getMetadataId() != null) {
                    CommonResponse referResponse = this.mdApi.queryMetadataById(billTypeVo.getMetadataId());
                    if (referResponse.isSuccess()) {
                        vo = (MdReferVO)referResponse.getData();
                        this.cacheManager.setex(key, (Serializable)vo, 300);
                    } else {
                        this.logger.info("\u8c03\u7528\u67e5\u8be2\u5143\u6570\u636e\u670d\u52a1\u5f02\u5e38\uff1a---------------" + referResponse.getMsg());
                    }
                }
            } else {
                this.logger.info("\u8c03\u7528\u67e5\u8be2support\u670d\u52a1\u5f02\u5e38\uff1a---------------" + billTypeResponse.getMsg());
            }
        }
        return vo;
    }
}

