package com.ejianc.business.common;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.business.market.api.IProjectApi;
import com.ejianc.business.market.vo.ProjectRegisterVO;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Arrays;
import java.util.List;

/**
 * @description: 中奥公共数据处理
 * @author songlx
 * @date 2023/9/22
 * @version 1.0
 */
@Service
public class CommonZatopDataDealService {

    @Autowired
    private IProjectApi projectApi;


    /**
     * @description: 给主表添加公共数据
     *
     * @param billId
     * @param billData
     * @param fields
     * @return {@link JSONArray}
     * @author songlx
     * @date: 2023/9/22
     */
    public JSONArray addFieldsForBillData(Long billId, JSONObject billData, JSONArray fields) {
        Long projectId = billData.getLong("projectId");
        if (projectId != null) {
            CommonResponse<List<ProjectRegisterVO>> projectResponse = projectApi.queryProjectByIds(Arrays.asList(projectId));
            if (projectResponse.isSuccess() && projectResponse.getData().size() > 0) {
                ProjectRegisterVO projectVO = projectResponse.getData().get(0);
                JSONObject field = new JSONObject();
                field.put("id", "engineeringType");
                field.put("name", "工程类型");
                field.put("value", projectVO.getEngineeringTypeName());
                fields.add(field);
            }
        }
        return fields;
    }
}
